/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.views;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.connection.SplusExpressionToTableModel;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableModel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class SearchPathView
extends ViewPart {
    public static final String ID = "com.insightful.splus.eclipse.views.SearchPathView";
    public static final String SEARCH_PATH_FXN = "(function(){s<-search(); sl<-length(s);p<-as.character(1:sl);javaGuiStringMatrix(as.matrix(array(c(p,s), dim=c(sl, 2))),justify=\"none\")})()";
    private static final String[] UNDETACHABLE = new String[]{"winjava", "spjava"};
    private Action m_refreshAction;
    private Action m_addLibraryAction;
    private Action m_addModuleAction;
    private Action m_attachAction;
    private Action m_detachAction;
    private SplusExpressionToTableModel m_model;
    private TableViewer m_table;
    private final String POS_COLUMN = "";
    private final String NAME_COLUMN = "Search Path";
    private String[] columnNames = new String[]{"", "Search Path"};
    private int[] columnWidths = new int[]{50, 450};
    private int m_sortColumn = -1;
    private int m_reverseSort = 1;

    private boolean canDetach(String string) {
        for (int i = 0; i < UNDETACHABLE.length; ++i) {
            if (!UNDETACHABLE[i].equals(string)) continue;
            return false;
        }
        return true;
    }

    public SearchPathView() {
        SplusEditorPlugin.getDefault().setSearchPath(this);
    }

    public void refreshSearchPath() {
        this.m_refreshAction.run();
    }

    public Viewer getViewer() {
        return this.m_table;
    }

    public void dispose() {
    }

    private void makeActions() {
        this.m_refreshAction = new Action(){

            public void run() {
                SearchPathView.this.m_model.refresh();
                SearchPathView.this.m_table.setInput((Object)SearchPathView.this.m_model);
            }
        };
        this.m_refreshAction.setText("Refresh");
        this.m_refreshAction.setToolTipText("Refresh Search Path View");
        this.m_detachAction = new Action(){

            public void run() {
                StructuredSelection structuredSelection = (StructuredSelection)SearchPathView.this.m_table.getSelection();
                if (structuredSelection != null && !structuredSelection.isEmpty()) {
                    String[] stringArray = new String[structuredSelection.size()];
                    List list = structuredSelection.toList();
                    boolean bl = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string;
                        Vector vector = (Vector)list.get(i);
                        String string2 = (String)vector.get(1);
                        String string3 = string2.replaceAll("\\\\", "/");
                        if (SearchPathView.this.canDetach(string3)) {
                            string = "detach(\"" + string3 + "\")";
                            if (!SearchPathView.this.processDataQuery(string, false)) continue;
                            bl = true;
                            continue;
                        }
                        string = "S-PLUS Workbench requires: " + string3;
                        SplusEditorPlugin.displayWarning("Cannot Detach", string);
                    }
                    if (bl) {
                        SearchPathView.this.m_refreshAction.run();
                    }
                }
            }
        };
        this.m_detachAction.setText("Detach");
        this.m_detachAction.setToolTipText("Detach From Search Path");
        this.m_addLibraryAction = new Action(){

            public void run() {
                AddToSearchPathDialog addToSearchPathDialog = new AddToSearchPathDialog(SearchPathView.this.getSite().getShell(), true);
                addToSearchPathDialog.open();
                if (addToSearchPathDialog.getReturnCode() == 1) {
                    return;
                }
                String string = addToSearchPathDialog.getString();
                if (string.length() == 0) {
                    return;
                }
                SearchPathView.this.processDataQuery(string, true);
            }
        };
        this.m_addLibraryAction.setText("Add Library");
        this.m_addLibraryAction.setToolTipText("Add Library");
        this.m_addModuleAction = new Action(){

            public void run() {
                AddToSearchPathDialog addToSearchPathDialog = new AddToSearchPathDialog(SearchPathView.this.getSite().getShell(), false);
                addToSearchPathDialog.open();
                if (addToSearchPathDialog.getReturnCode() == 1) {
                    return;
                }
                String string = addToSearchPathDialog.getString();
                if (string.length() == 0) {
                    return;
                }
                SearchPathView.this.processDataQuery(string, true);
            }
        };
        this.m_addModuleAction.setText("Add Module");
        this.m_addModuleAction.setToolTipText("Add Module");
        this.m_attachAction = new Action(){

            public void run() {
                AttachDialog attachDialog = new AttachDialog(SearchPathView.this.getSite().getShell());
                attachDialog.open();
                if (attachDialog.getReturnCode() == 1) {
                    return;
                }
                String string = attachDialog.getString();
                if (string.length() == 0) {
                    return;
                }
                SearchPathView.this.processDataQuery(string, true);
            }
        };
        this.m_attachAction.setText("Attach Directory");
        this.m_attachAction.setToolTipText("Attach Directory");
    }

    private boolean processDataQuery(String string, boolean bl) {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection) {
            return ((DefaultConnection)noConnection).processDataQuery(string, this.getSite(), (IAction)(bl ? this.m_refreshAction : null));
        }
        return false;
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        this.fillContextMenu(iMenuManager);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection) {
            iMenuManager.add((IAction)this.m_addLibraryAction);
            iMenuManager.add((IAction)this.m_addModuleAction);
            iMenuManager.add((IAction)this.m_attachAction);
            iMenuManager.add((IAction)this.m_detachAction);
            iMenuManager.add((IContributionItem)new Separator("additions"));
            iMenuManager.add((IAction)this.m_refreshAction);
        }
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
    }

    private void hookContextMenu() {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection) {
            MenuManager menuManager = new MenuManager("#PopupMenu");
            menuManager.setRemoveAllWhenShown(true);
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager iMenuManager) {
                    SearchPathView.this.fillContextMenu(iMenuManager);
                }
            });
            Menu menu = menuManager.createContextMenu(this.m_table.getControl());
            this.m_table.getControl().setMenu(menu);
            this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.m_table);
        }
    }

    public void createPartControl(Composite composite) {
        int n = 66308;
        SplusEditorPlugin.getDefault().getConnection();
        this.m_table = new TableViewer(composite, n){

            protected void handleDispose(DisposeEvent disposeEvent) {
            }
        };
        final Table table = this.m_table.getTable();
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
            }
        });
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setFont(SplusEditorPlugin.getDefaultFont(composite.getDisplay()));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = table.indexOf((TableColumn)selectionEvent.widget);
                if (SearchPathView.this.m_sortColumn == n) {
                    SearchPathView.this.m_reverseSort = SearchPathView.this.m_reverseSort * -1;
                } else {
                    SearchPathView.this.m_sortColumn = n;
                    SearchPathView.this.m_reverseSort = 1;
                }
                SearchPathView.this.m_table.refresh();
            }
        };
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.createTableColumn(table, (SelectionListener)selectionAdapter, i);
        }
        this.m_table.setUseHashlookup(true);
        this.m_table.setColumnProperties(this.columnNames);
        this.m_table.setSorter((ViewerSorter)new SplusObjectSorter());
        try {
            NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
            if (noConnection instanceof DefaultConnection) {
                this.m_model = new SplusExpressionToTableModel(SEARCH_PATH_FXN);
                this.m_table.setContentProvider((IContentProvider)new ObjectDescriptionProvider((TableModel)((Object)this.m_model)));
                this.m_table.setLabelProvider((IBaseLabelProvider)new ObjectDescriptionLabelProvider());
                this.m_table.setInput((Object)this.m_model);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Error error) {
            error.printStackTrace();
        }
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private TableColumn createTableColumn(Table table, SelectionListener selectionListener, int n) {
        TableColumn tableColumn = new TableColumn(table, 0, n);
        tableColumn.setText(this.columnNames[n]);
        tableColumn.setWidth(this.columnWidths[n]);
        tableColumn.addSelectionListener(selectionListener);
        return tableColumn;
    }

    public void setFocus() {
    }

    private class AttachDialog
    extends Dialog {
        private String m_str;
        private String m_fxn;
        private String m_pos;
        private String m_lbl;

        public AttachDialog(Shell shell) {
            super(shell);
            this.m_str = "";
            this.m_fxn = "attach";
            this.m_pos = "-1";
            this.m_lbl = "";
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        }

        public String getString() {
            if (this.m_str.length() == 0) {
                return this.m_str;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m_fxn + "(\"" + this.m_str + "\"");
            if (this.m_lbl.length() > 0) {
                stringBuffer.append(", name=\"" + this.m_lbl + "\"");
            }
            stringBuffer.append(", pos=" + this.m_pos);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            composite2.setLayout((Layout)gridLayout);
            Composite composite3 = new Composite(composite2, 0);
            composite3.setLayoutData((Object)new GridData(768));
            DirectoryFieldEditor directoryFieldEditor = new DirectoryFieldEditor("chapter", "Directory to attach:", composite3);
            final Text text = directoryFieldEditor.getTextControl(composite3);
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    AttachDialog.this.m_str = text.getText().replace('\\', '/');
                }
            });
            composite3 = new Composite(composite2, 0);
            composite3.setLayoutData((Object)new GridData(768));
            StringFieldEditor stringFieldEditor = new StringFieldEditor("label", "Label:", composite3);
            final Text text2 = stringFieldEditor.getTextControl(composite3);
            text2.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    AttachDialog.this.m_lbl = text2.getText();
                }
            });
            composite3 = new Composite(composite2, 0);
            composite3.setLayoutData((Object)new GridData(768));
            IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor("position", "Position", composite3);
            final Text text3 = integerFieldEditor.getTextControl(composite3);
            text3.setText(this.m_pos);
            text3.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    AttachDialog.this.m_pos = text3.getText();
                }
            });
            return composite2;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Attach");
        }

        protected Point getInitialSize() {
            Point point = super.getInitialSize();
            point.x *= 2;
            return point;
        }
    }

    private class AddToSearchPathDialog
    extends Dialog {
        private String m_str;
        private String m_fxn;
        private String m_top;
        private String m_title;

        public AddToSearchPathDialog(Shell shell, boolean bl) {
            super(shell);
            this.m_str = "";
            this.m_fxn = "";
            this.m_top = "F";
            this.m_title = "";
            this.m_fxn = bl ? "library" : "module";
            this.m_title = bl ? "Library" : "Module";
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        }

        public String getString() {
            if (this.m_str.length() == 0) {
                return this.m_str;
            }
            return this.m_fxn + "(\"" + this.m_str + "\", first=" + this.m_top + ")";
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            Label label = new Label(composite2, 0);
            label.setLayoutData((Object)new GridData(128));
            label.setText(this.m_title + " Name to Attach:");
            final Text text = new Text(composite2, 2048);
            text.setLayoutData((Object)new GridData(768));
            text.setText("");
            Label label2 = new Label(composite2, 0);
            label2.setLayoutData((Object)new GridData(128));
            label2.setText("Attach at top of search list:");
            final Button button = new Button(composite2, 32);
            button.setLayoutData((Object)new GridData(768));
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    AddToSearchPathDialog.this.m_str = text.getText();
                }
            });
            button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    this.setFirst();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.setFirst();
                }

                private void setFirst() {
                    AddToSearchPathDialog.this.m_top = button.getSelection() ? "T" : "F";
                }
            });
            return composite2;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Attach " + this.m_title);
        }

        protected Point getInitialSize() {
            Point point = super.getInitialSize();
            point.x *= 2;
            return point;
        }
    }

    public class SplusObjectSorter
    extends ViewerSorter {
        public int compare(Viewer viewer, Object object, Object object2) {
            if (SearchPathView.this.m_sortColumn == -1) {
                return 0;
            }
            if (object instanceof Vector && object2 instanceof Vector) {
                String string = (String)((Vector)object).get(SearchPathView.this.m_sortColumn);
                String string2 = (String)((Vector)object2).get(SearchPathView.this.m_sortColumn);
                try {
                    double d = Double.parseDouble(string);
                    double d2 = Double.parseDouble(string2);
                    if (d == d2) {
                        return 0;
                    }
                    if (d > d2) {
                        return 1 * SearchPathView.this.m_reverseSort;
                    }
                    return -1 * SearchPathView.this.m_reverseSort;
                }
                catch (NumberFormatException numberFormatException) {
                    return string.compareTo(string2) * SearchPathView.this.m_reverseSort;
                }
            }
            return super.compare(viewer, object, object2);
        }
    }

    public class ObjectDescriptionLabelProvider
    implements ITableLabelProvider {
        private Vector m_listeners = new Vector();

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof Vector) {
                return (String)((Vector)object).get(n);
            }
            return "";
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return true;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
            this.m_listeners.add(iLabelProviderListener);
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
            this.m_listeners.remove(iLabelProviderListener);
        }
    }

    public class ObjectDescriptionProvider
    implements IStructuredContentProvider {
        private TableModel m_model;

        public ObjectDescriptionProvider(TableModel tableModel) {
            this.m_model = tableModel;
        }

        public Object[] getElements(Object object) {
            int n = this.m_model.getColumnCount();
            int n2 = this.m_model.getRowCount();
            Object[] objectArray = new Vector[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = new Vector();
                for (int j = 0; j < n; ++j) {
                    ((Vector)objectArray[i]).add(this.m_model.getValueAt(i, j));
                }
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            viewer.refresh();
        }

        public void dispose() {
        }
    }
}

