/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.api.webservice;

import com.insightful.splusserver.api.webservice.IWebServiceSecurity;
import com.insightful.splusserver.configuration.ServerPropertyManager;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

public class WebServiceClientCommon
implements IWebServiceSecurity,
Serializable {
    private static final long serialVersionUID = 1L;
    private final URL endpointURI;
    private final Service service = new Service();
    private String userName;
    private String password;
    private static Log log = LogFactory.getLog(WebServiceClientCommon.class);

    protected WebServiceClientCommon(String urlPropName) throws MalformedURLException {
        this.endpointURI = new URL(WebServiceClientCommon.getPropertyValue(urlPropName));
    }

    protected WebServiceClientCommon(URL url) {
        this.endpointURI = url;
    }

    public String getEndpointURI() {
        return this.endpointURI.toString();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean validateUserCredentials() throws Exception {
        Call call = this.createCall("validateUserCredentials");
        return (Boolean)call.invoke(new Object[0]);
    }

    public String[] getUserRoles() throws Exception {
        Call call = this.createCall("getUserRoles");
        return (String[])call.invoke(new Object[0]);
    }

    public static String getPropertyValue(String urlPropName) {
        String endpointUri = null;
        try {
            InitialContext initCtx = new InitialContext();
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            log.debug((Object)("Looking up: " + urlPropName + " in java:comp/env"));
            endpointUri = (String)envCtx.lookup(urlPropName);
            endpointUri = WebServiceClientCommon.getTrueHostName(endpointUri);
        }
        catch (Exception e) {
            log.error((Object)("Retrieving global property: " + urlPropName + "  failed with exception: "), (Throwable)e);
        }
        return endpointUri;
    }

    public static String getTrueHostName(String connectString) {
        if (!connectString.contains("//localhost")) {
            return connectString;
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String trueHostName = "//" + addr.getHostName();
            String returnString = new String(connectString);
            String trueHostString = returnString.replace("//localhost", trueHostName);
            return trueHostString;
        }
        catch (UnknownHostException e) {
            log.error((Object)"Could not get local host name!", (Throwable)e);
            return connectString;
        }
    }

    protected Call createCall(String operationName) throws Exception {
        Call call = (Call)this.service.createCall();
        call.setTargetEndpointAddress(this.endpointURI);
        call.setOperationName(new QName(this.endpointURI.toString(), operationName));
        if (this.userName != null) {
            call.setUsername(this.userName);
            call.setPassword(this.password);
        }
        return call;
    }

    public String invokeCall(String funcName, Object[] args) throws Exception {
        Call call = this.createCall(funcName);
        String ret = (String)call.invoke(args);
        return ret;
    }

    public Object unmarshal(Class clazz, String xml) throws MarshalException, MappingException, ValidationException {
        Unmarshaller unm = new Unmarshaller(clazz);
        unm.setMapping(ServerPropertyManager.getXmlMapping());
        StringReader sr = new StringReader(xml);
        return unm.unmarshal((Reader)sr);
    }
}

