/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.debug.ui.views;

import com.insightful.splus.SplusProfileHandler;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.debug.preferences.SplusProfilePreferencePage;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class AllocationView
extends ViewPart
implements IPropertyChangeListener {
    public static String ID = "com.insightful.splus.eclipse.debug.ui.AllocationView";
    private RefreshTimer m_refreshThread;
    private TableViewer m_tableViewer;
    private Action m_refreshAction;
    private Action m_resetAction;
    private boolean m_alive = true;
    private final String NAME_COLUMN = "Type";
    private final String COUNT_COLUMN = "Amount";
    private String[] columnNames = new String[]{"Type", "Amount"};
    private int[] columnWidths = new int[]{125, 110};
    private int m_sortColumn = -1;
    private int m_reverseSort = 1;

    public AllocationView() {
        this.m_refreshThread = new RefreshTimer();
        this.m_refreshThread.start();
        SplusEditorPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        this.m_alive = false;
    }

    public void createPartControl(Composite composite) {
        this.createTableViewer(composite);
        this.createActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
            }
        });
        Menu menu = menuManager.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.m_tableViewer);
    }

    private void createActions() {
        this.m_refreshAction = new Action(){

            public void run() {
                AllocationView.this.updateView();
            }
        };
        this.m_refreshAction.setToolTipText("Refresh Allocations");
        this.m_refreshAction.setDescription("Refresh Allocations");
        this.m_refreshAction.setText("Refresh Allocations");
        this.m_resetAction = new Action(){

            public void run() {
                SplusProfileHandler.resetAllocations();
            }
        };
        this.m_resetAction.setToolTipText("Reset Allocations");
        this.m_resetAction.setDescription("Reset Allocations");
        this.m_resetAction.setText("Reset Allocations");
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IAction)this.m_refreshAction);
        iMenuManager.add((IAction)this.m_resetAction);
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                iMenuManager.removeAll();
                AllocationView.this.fillContextMenu(iMenuManager);
            }
        });
        this.fillContextMenu(iMenuManager);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
    }

    private void createTableViewer(Composite composite) {
        this.m_tableViewer = new TableViewer(composite);
        final Table table = this.m_tableViewer.getTable();
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setFont(SplusEditorPlugin.getDefaultFont((Display)composite.getDisplay()));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = table.indexOf((TableColumn)selectionEvent.widget);
                if (AllocationView.this.m_sortColumn == n) {
                    AllocationView.this.m_reverseSort = AllocationView.this.m_reverseSort * -1;
                } else {
                    AllocationView.this.m_sortColumn = n;
                    AllocationView.this.m_reverseSort = 1;
                }
                AllocationView.this.m_tableViewer.refresh();
            }
        };
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.createTableColumn(table, (SelectionListener)selectionAdapter, i);
        }
        this.m_tableViewer.setUseHashlookup(true);
        this.m_tableViewer.setColumnProperties(this.columnNames);
        this.m_tableViewer.setSorter((ViewerSorter)new SplusObjectSorter());
        this.m_tableViewer.setContentProvider((IContentProvider)new AllocationTableProvider());
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)new AllocationTableLabelProvider());
        this.m_tableViewer.setInput((Object)this);
    }

    private TableColumn createTableColumn(Table table, SelectionListener selectionListener, int n) {
        TableColumn tableColumn = new TableColumn(table, 0, n);
        tableColumn.setText(this.columnNames[n]);
        tableColumn.setWidth(this.columnWidths[n]);
        tableColumn.addSelectionListener(selectionListener);
        return tableColumn;
    }

    public void setFocus() {
        this.m_tableViewer.getControl().setFocus();
    }

    public boolean updateView() {
        if (this.m_alive) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    AllocationView.this.m_tableViewer.refresh(true);
                }
            });
        }
        return this.m_alive;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.equals(SplusProfilePreferencePage.REFRESH_RATE)) {
            this.m_refreshThread.setTimerIncrement(SplusProfilePreferencePage.getRefreshRate());
        }
    }

    private class RefreshTimer
    extends Thread {
        private int m_increment = 5;

        public void setTimerIncrement(int n) {
            this.m_increment = n;
        }

        public void run() {
            do {
                try {
                    Thread.sleep(this.m_increment * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (AllocationView.this.updateView());
        }
    }

    public class SplusObjectSorter
    extends ViewerSorter {
        public int compare(Viewer viewer, Object object, Object object2) {
            if (AllocationView.this.m_sortColumn != -1 && object instanceof Vector && object2 instanceof Vector) {
                String string = (String)((Vector)object).get(AllocationView.this.m_sortColumn);
                String string2 = (String)((Vector)object2).get(AllocationView.this.m_sortColumn);
                try {
                    double d = Double.parseDouble(string);
                    double d2 = Double.parseDouble(string2);
                    if (d == d2) {
                        return 0;
                    }
                    if (d > d2) {
                        return 1 * AllocationView.this.m_reverseSort;
                    }
                    return -1 * AllocationView.this.m_reverseSort;
                }
                catch (NumberFormatException numberFormatException) {
                    return string.compareTo(string2) * AllocationView.this.m_reverseSort;
                }
            }
            return super.compare(viewer, object, object2);
        }
    }

    public class AllocationTableLabelProvider
    implements ITableLabelProvider {
        private Vector m_listeners = new Vector();

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof Vector && ((Vector)object).size() > n) {
                return (String)((Vector)object).get(n);
            }
            return "";
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return true;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
            this.m_listeners.add(iLabelProviderListener);
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
            this.m_listeners.remove(iLabelProviderListener);
        }
    }

    public class AllocationTableProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object object) {
            String[] stringArray = SplusProfileHandler.getTypesAllocated();
            Object[] objectArray = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Vector<String> vector = new Vector<String>();
                vector.add(stringArray[i]);
                vector.add(Long.toString(SplusProfileHandler.getTotalAllocation((String)stringArray[i])));
                objectArray[i] = vector;
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            if (object2 != null) {
                viewer.refresh();
            }
        }

        public void dispose() {
        }
    }
}

