/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.FiltersConfigurationDialog;
import org.eclipse.ui.internal.views.markers.MarkerCategory;
import org.eclipse.ui.internal.views.markers.MarkerColumnLabelProvider;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.MarkerCopyHandler;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.internal.views.markers.MarkersTreeViewer;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;

public class ExtendedMarkersView
extends ViewPart {
    private static int instanceCount = 1;
    private static final String TAG_GENERATOR = "markerContentGenerator";
    private static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    private static final String TAG_VERTICAL_POSITION = "verticalPosition";
    private static final String MARKER_FIELD = "MARKER_FIELD";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_CATEGORY = "category";
    private static final String TAG_PART_NAME = "partName";
    private static final String TAG_COLUMN_WIDTHS = "columnWidths";
    private CachedMarkerBuilder builder;
    Collection categoriesToExpand;
    private Clipboard clipboard;
    Collection preservedSelection = new ArrayList();
    private Job updateJob;
    private MarkersTreeViewer viewer;
    private IPropertyChangeListener preferenceListener;
    private ISelectionListener pageSelectionListener;
    private IPartListener2 partListener;
    private IMemento memento;
    private String[] defaultGeneratorIds = new String[0];
    private IPropertyChangeListener workingSetListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    static {
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        IAdapterFactory iAdapterFactory = new IAdapterFactory(){

            public Object getAdapter(Object adaptableObject, Class adapterType) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IMarker");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapterType == clazz && adaptableObject instanceof MarkerEntry) {
                    return ((MarkerEntry)adaptableObject).getMarker();
                }
                return null;
            }

            public Class[] getAdapterList() {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IMarker");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                return classArray;
            }
        };
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.internal.views.markers.MarkerEntry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters(iAdapterFactory, (Class)clazz);
    }

    static String newSecondaryID(IViewPart part) {
        while (part.getSite().getPage().findViewReference(part.getSite().getId(), String.valueOf(instanceCount)) != null) {
            ++instanceCount;
        }
        return String.valueOf(instanceCount);
    }

    public static void openMarkerInEditor(IMarker marker, IWorkbenchPage page) {
        IEditorInput input;
        IFile file;
        IEditorPart editor = page.getActiveEditor();
        if (editor != null && (file = ResourceUtil.getFile(input = editor.getEditorInput())) != null && marker.getResource().equals((Object)file)) {
            page.activate((IWorkbenchPart)editor);
        }
        if (marker != null && marker.getResource() instanceof IFile) {
            try {
                IDE.openEditor(page, marker, OpenStrategy.activateOnOpen());
            }
            catch (PartInitException e) {
                IStatus status = e.getStatus();
                if (status != null && status.getException() instanceof CoreException) {
                    status = ((CoreException)status.getException()).getStatus();
                }
                if (status == null) {
                    StatusManager.getManager().handle(StatusUtil.newStatus(4, e.getMessage(), (Throwable)e), 2);
                }
                StatusManager.getManager().handle(status, 2);
            }
        }
    }

    public ExtendedMarkersView(String contentGeneratorId) {
        this.defaultGeneratorIds = new String[]{contentGeneratorId};
        this.preferenceListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String propertyName = event.getProperty();
                if (propertyName.equals("USE_MARKER_LIMITS") || propertyName.equals("MARKER_LIMITS_VALUE")) {
                    ExtendedMarkersView.this.viewer.refresh();
                    ExtendedMarkersView.this.updateTitle();
                }
            }
        };
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferenceListener);
    }

    private void addAllConcreteItems(MarkerSupportItem markerItem, Collection allMarkers) {
        if (markerItem.isConcrete()) {
            allMarkers.add(markerItem);
            return;
        }
        MarkerSupportItem[] children = markerItem.getChildren();
        int i = 0;
        while (i < children.length) {
            this.addAllConcreteItems(children[i], allMarkers);
            ++i;
        }
    }

    void addExpandedCategory(MarkerCategory category) {
        this.getCategoriesToExpand().add(category.getName());
    }

    private void addMarkers(MarkerSupportItem markerItem, Collection allMarkers) {
        if (markerItem.getMarker() != null) {
            allMarkers.add(markerItem.getMarker());
        }
        MarkerSupportItem[] children = markerItem.getChildren();
        int i = 0;
        while (i < children.length) {
            this.addMarkers(children[i], allMarkers);
            ++i;
        }
    }

    private void createColumns(TreeColumn[] currentColumns) {
        Tree tree = this.viewer.getTree();
        TableLayout layout = new TableLayout();
        MarkerField[] fields = this.builder.getVisibleFields();
        IMemento columnWidths = null;
        if (this.memento != null) {
            columnWidths = this.memento.getChild(TAG_COLUMN_WIDTHS);
        }
        int i = 0;
        while (i < fields.length) {
            Integer value;
            TreeViewerColumn column;
            MarkerField markerField = fields[i];
            if (i < currentColumns.length) {
                column = new TreeViewerColumn((TreeViewer)this.viewer, currentColumns[i]);
            } else {
                column = new TreeViewerColumn((TreeViewer)this.viewer, 0);
                column.getColumn().setResizable(true);
                column.getColumn().setMoveable(true);
                column.getColumn().addSelectionListener(this.getHeaderListener());
            }
            column.getColumn().setData(MARKER_FIELD, (Object)markerField);
            column.setLabelProvider((CellLabelProvider)new MarkerColumnLabelProvider(markerField));
            column.getColumn().setText(markerField.getColumnHeaderText());
            column.getColumn().setToolTipText(markerField.getColumnTooltipText());
            column.getColumn().setImage(markerField.getColumnHeaderImage());
            EditingSupport support = markerField.getEditingSupport((ColumnViewer)this.viewer);
            if (support != null) {
                column.setEditingSupport(support);
            }
            if (this.builder.getPrimarySortField().equals(markerField)) {
                this.updateDirectionIndicator(column.getColumn(), markerField);
            }
            int columnWidth = markerField.getDefaultColumnWidth((Control)tree);
            if (i == 0) {
                GC gc = new GC((Drawable)tree);
                gc.setFont(tree.getFont());
                FontMetrics fontMetrics = gc.getFontMetrics();
                gc.dispose();
                columnWidth = Math.max(columnWidth, fontMetrics.getAverageCharWidth() * 5);
            }
            if (columnWidths != null && (value = columnWidths.getInteger(this.getFieldId(column.getColumn()))) != null && value > 0) {
                columnWidth = value;
            }
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(columnWidth, true, true));
            ++i;
        }
        if (currentColumns.length > fields.length) {
            i = fields.length;
            while (i < currentColumns.length) {
                currentColumns[i].dispose();
                ++i;
            }
        }
        this.viewer.getTree().setLayout((Layout)layout);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.layout(true);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new MarkersTreeViewer(new Tree(parent, 66306));
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.setUseHashlookup(true);
        this.createColumns(new TreeColumn[0]);
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setInput(this.builder);
        if (this.memento != null) {
            Integer position;
            Scrollable scrollable = (Scrollable)this.viewer.getControl();
            ScrollBar bar = scrollable.getVerticalBar();
            if (bar != null && (position = this.memento.getInteger(TAG_VERTICAL_POSITION)) != null) {
                bar.setSelection(position.intValue());
            }
            if ((bar = scrollable.getHorizontalBar()) != null && (position = this.memento.getInteger(TAG_HORIZONTAL_POSITION)) != null) {
                bar.setSelection(position.intValue());
            }
        }
        this.pageSelectionListener = this.getPageSelectionListener();
        this.getSite().getPage().addPostSelectionListener(this.pageSelectionListener);
        this.partListener = this.getPartListener();
        this.getSite().getPage().addPartListener(this.partListener);
        this.pageSelectionListener.selectionChanged(this.getSite().getPage().getActivePart(), this.getSite().getPage().getSelection());
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ExtendedMarkersView.this.openSelectedMarkers();
            }
        });
        this.viewer.getTree().addTreeListener((TreeListener)new TreeAdapter(){

            public void treeCollapsed(TreeEvent e) {
                ExtendedMarkersView.this.removeExpandedCategory((MarkerCategory)e.item.getData());
            }

            public void treeExpanded(TreeEvent e) {
                ExtendedMarkersView.this.addExpandedCategory((MarkerCategory)e.item.getData());
            }
        });
        this.viewer.getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                Object provider;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.help.IContextProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((provider = ExtendedMarkersView.this.getAdapter(clazz)) == null) {
                    return;
                }
                IContext context = ((IContextProvider)provider).getContext((Object)ExtendedMarkersView.this.viewer.getControl());
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(context);
            }
        });
        this.viewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = ExtendedMarkersView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    ExtendedMarkersView.this.updateStatusLine((IStructuredSelection)ExtendedMarkersView.this.viewer.getSelection());
                }
            }
        });
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.getWorkingSetListener());
        this.registerContextMenu();
        this.initDragAndDrop();
    }

    void disableAllFilters() {
        this.builder.disableAllFilters();
    }

    public void dispose() {
        super.dispose();
        this.builder.dispose();
        this.updateJob.cancel();
        --instanceCount;
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
        this.getSite().getPage().removePostSelectionListener(this.pageSelectionListener);
        this.getSite().getPage().removePartListener(this.partListener);
        PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.workingSetListener);
    }

    MarkerSupportItem[] getAllConcreteItems() {
        MarkerSupportItem[] elements = this.builder.getElements();
        ArrayList allMarkers = new ArrayList();
        int i = 0;
        while (i < elements.length) {
            this.addAllConcreteItems(elements[i], allMarkers);
            ++i;
        }
        MarkerSupportItem[] markers = new MarkerSupportItem[allMarkers.size()];
        allMarkers.toArray(markers);
        return markers;
    }

    Collection getAllFilters() {
        return this.builder.getAllFilters();
    }

    IMarker[] getAllMarkers() {
        MarkerSupportItem[] elements = this.builder.getElements();
        ArrayList allMarkers = new ArrayList();
        int i = 0;
        while (i < elements.length) {
            this.addMarkers(elements[i], allMarkers);
            ++i;
        }
        IMarker[] markers = new IMarker[allMarkers.size()];
        allMarkers.toArray(markers);
        return markers;
    }

    CachedMarkerBuilder getBuilder() {
        return this.builder;
    }

    private Collection getCategoriesToExpand() {
        if (this.categoriesToExpand == null) {
            IMemento expanded;
            this.categoriesToExpand = new HashSet();
            if (this.memento != null && (expanded = this.memento.getChild(TAG_EXPANDED)) != null) {
                IMemento[] mementoCategories = expanded.getChildren(TAG_CATEGORY);
                MarkerCategory[] markerCategories = this.builder.getCategories();
                if (markerCategories != null) {
                    int i = 0;
                    while (i < markerCategories.length) {
                        int j = 0;
                        while (j < mementoCategories.length) {
                            if (markerCategories[i].getName().equals(mementoCategories[j].getID())) {
                                this.categoriesToExpand.add(markerCategories[i].getName());
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        }
        return this.categoriesToExpand;
    }

    MarkerGroup getCategoryGroup() {
        return this.builder.getCategoryGroup();
    }

    Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = new Clipboard(this.viewer.getControl().getDisplay());
        }
        return this.clipboard;
    }

    private ITreeContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                Object[] children = ((MarkerSupportItem)parentElement).getChildren();
                return this.getLimitedChildren(children);
            }

            public Object[] getElements(Object inputElement) {
                return this.getLimitedChildren(((CachedMarkerBuilder)inputElement).getElements());
            }

            private Object[] getLimitedChildren(Object[] children) {
                int newLength = MarkerSupportInternalUtilities.getMarkerLimit();
                if (newLength > 0 && newLength < children.length) {
                    Object[] newChildren = new Object[newLength];
                    System.arraycopy(children, 0, newChildren, 0, newLength);
                    return newChildren;
                }
                return children;
            }

            public Object getParent(Object element) {
                MarkerSupportItem parent = ((MarkerSupportItem)element).getParent();
                if (parent == null) {
                    return ExtendedMarkersView.this.builder;
                }
                return parent;
            }

            public boolean hasChildren(Object element) {
                return ((MarkerSupportItem)element).getChildren().length > 0;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private String getFieldId(TreeColumn treeColumn) {
        return ((MarkerField)treeColumn.getData(MARKER_FIELD)).getConfigurationElement().getAttribute("id");
    }

    String[] getGeneratorIds() {
        return this.defaultGeneratorIds;
    }

    private SelectionListener getHeaderListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeColumn column = (TreeColumn)e.widget;
                MarkerField field = (MarkerField)column.getData(ExtendedMarkersView.MARKER_FIELD);
                ExtendedMarkersView.this.setPrimarySortField(field, column);
            }
        };
    }

    private ISelectionListener getPageSelectionListener() {
        return new ISelectionListener(){

            private ITaskListResourceAdapter getDefaultTaskListAdapter() {
                return new ITaskListResourceAdapter(this){
                    final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public IResource getAffectedResource(IAdaptable adaptable) {
                        Object resource;
                        Class<?> clazz = class$3;
                        if (clazz == null) {
                            try {
                                clazz = class$3 = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((resource = adaptable.getAdapter((Class)clazz)) == null) {
                            Class<?> clazz2 = class$4;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = class$4 = Class.forName("org.eclipse.core.resources.IFile");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            resource = adaptable.getAdapter((Class)clazz2);
                        }
                        if (resource == null) {
                            return null;
                        }
                        return (IResource)resource;
                    }
                };
            }

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                ArrayList<Object> selectedElements;
                block16: {
                    block14: {
                        IFile file;
                        block15: {
                            Object mapping;
                            if (part == ExtendedMarkersView.this || !ExtendedMarkersView.this.getSite().getPage().isPartVisible(part)) {
                                return;
                            }
                            selectedElements = new ArrayList<Object>();
                            if (!(part instanceof IEditorPart)) break block14;
                            IEditorPart editor = (IEditorPart)part;
                            file = ResourceUtil.getFile(editor.getEditorInput());
                            if (file != null) break block15;
                            IEditorInput editorInput = editor.getEditorInput();
                            if (editorInput == null) break block16;
                            Class<?> clazz = class$5;
                            if (clazz == null) {
                                try {
                                    clazz = class$5 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((mapping = editorInput.getAdapter((Class)clazz)) == null) break block16;
                            selectedElements.add(mapping);
                            break block16;
                        }
                        selectedElements.add(file);
                        break block16;
                    }
                    if (selection instanceof IStructuredSelection) {
                        Iterator iterator = ((IStructuredSelection)selection).iterator();
                        while (iterator.hasNext()) {
                            Object adapter;
                            ITaskListResourceAdapter taskListResourceAdapter;
                            IResource resource;
                            Object object = iterator.next();
                            if (!(object instanceof IAdaptable)) continue;
                            IAdaptable iAdaptable = (IAdaptable)object;
                            Class<?> clazz = class$6;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.ui.views.tasklist.ITaskListResourceAdapter");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((resource = (taskListResourceAdapter = (adapter = iAdaptable.getAdapter((Class)clazz)) != null && adapter instanceof ITaskListResourceAdapter ? (ITaskListResourceAdapter)adapter : this.getDefaultTaskListAdapter()).getAffectedResource((IAdaptable)object)) == null) {
                                Object mapping;
                                IAdaptable iAdaptable2 = (IAdaptable)object;
                                Class<?> clazz2 = class$5;
                                if (clazz2 == null) {
                                    try {
                                        clazz2 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if ((mapping = iAdaptable2.getAdapter((Class)clazz2)) == null) continue;
                                selectedElements.add(mapping);
                                continue;
                            }
                            selectedElements.add(resource);
                        }
                    }
                }
                ExtendedMarkersView.this.builder.updateForNewSelection(selectedElements.toArray());
            }
        };
    }

    private IPartListener2 getPartListener() {
        return new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals(ExtendedMarkersView.this.getSite().getId())) {
                    ExtendedMarkersView.this.pageSelectionListener.selectionChanged(ExtendedMarkersView.this.getSite().getPage().getActivePart(), ExtendedMarkersView.this.getSite().getPage().getSelection());
                }
            }
        };
    }

    public IMarker[] getSelectedMarkers() {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            Iterator elements = structured.iterator();
            ArrayList<IMarker> result = new ArrayList<IMarker>();
            while (elements.hasNext()) {
                MarkerSupportItem next = (MarkerSupportItem)elements.next();
                if (!next.isConcrete()) continue;
                result.add(((MarkerEntry)next).getMarker());
            }
            if (result.isEmpty()) {
                return MarkerSupportInternalUtilities.EMPTY_MARKER_ARRAY;
            }
            IMarker[] markers = new IMarker[result.size()];
            result.toArray(markers);
            return markers;
        }
        return MarkerSupportInternalUtilities.EMPTY_MARKER_ARRAY;
    }

    public boolean getSortAscending() {
        return this.viewer.getTree().getSortDirection() == 128;
    }

    private String getStatusMessage() {
        String status = "";
        int totalCount = this.builder.getTotalMarkerCount();
        int filteredCount = 0;
        MarkerCategory[] categories = this.builder.getCategories();
        if (categories != null && this.builder.isShowingHierarchy()) {
            int markerLimit = MarkerSupportInternalUtilities.getMarkerLimit();
            int i = 0;
            while (i < categories.length) {
                filteredCount += markerLimit < 0 ? ((MarkerSupportItem)categories[i]).getChildrenCount() : Math.min(((MarkerSupportItem)categories[i]).getChildrenCount(), markerLimit);
                ++i;
            }
        } else {
            filteredCount = MarkerSupportInternalUtilities.getMarkerLimit();
        }
        Object[] counts = this.builder.getMarkerCounts();
        if (counts[0] == 0 && counts[1] == 0) {
            status = filteredCount < 0 || filteredCount >= totalCount ? NLS.bind((String)MarkerMessages.filter_itemsMessage, (Object)new Integer(totalCount)) : NLS.bind((String)MarkerMessages.filter_matchedMessage, (Object)new Integer(filteredCount), (Object)new Integer(totalCount));
            return status;
        }
        if (filteredCount < 0 || filteredCount >= totalCount) {
            return MessageFormat.format((String)MarkerMessages.errorsAndWarningsSummaryBreakdown, (Object[])counts);
        }
        return NLS.bind((String)MarkerMessages.problem_filter_matchedMessage, (Object[])new Object[]{MessageFormat.format((String)MarkerMessages.errorsAndWarningsSummaryBreakdown, (Object[])counts), new Integer(filteredCount), new Integer(totalCount)});
    }

    private Job getUpdateJob(final CachedMarkerBuilder builder) {
        this.updateJob = new WorkbenchJob(MarkerMessages.MarkerView_queueing_updates){

            public boolean belongsTo(Object family) {
                return family == MarkerContentGenerator.CACHE_UPDATE_FAMILY;
            }

            private TreeViewer getViewer() {
                return ExtendedMarkersView.this.viewer;
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                MarkerCategory[] categories;
                if (ExtendedMarkersView.this.viewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (builder.isShowingHierarchy() && ExtendedMarkersView.this.getCategoriesToExpand().isEmpty() && (categories = builder.getCategories()) != null && categories.length == 1) {
                    ExtendedMarkersView.this.getCategoriesToExpand().add(categories[0].getDescription());
                }
                this.getViewer().refresh(true);
                ExtendedMarkersView.this.updateTitle();
                if (ExtendedMarkersView.this.preservedSelection.size() > 0) {
                    ArrayList<MarkerEntry> newSelection = new ArrayList<MarkerEntry>();
                    MarkerEntry[] markerEntries = builder.getMarkerEntries();
                    int i = 0;
                    while (i < markerEntries.length) {
                        Iterator preserved = ExtendedMarkersView.this.preservedSelection.iterator();
                        while (preserved.hasNext()) {
                            MarkerSelectionEntry next = (MarkerSelectionEntry)preserved.next();
                            if (!next.isEquivalentTo(markerEntries[i])) continue;
                            newSelection.add(markerEntries[i]);
                        }
                        ++i;
                    }
                    this.getViewer().setSelection((ISelection)new StructuredSelection(newSelection.toArray()), true);
                    ExtendedMarkersView.this.preservedSelection.clear();
                }
                if (this.getViewer().getTree().getItemCount() > 0) {
                    this.getViewer().getTree().setTopItem(this.getViewer().getTree().getItem(0));
                }
                ExtendedMarkersView.this.reexpandCategories(builder);
                return Status.OK_STATUS;
            }

            public boolean shouldRun() {
                return !builder.isBuilding() && IDEWorkbenchPlugin.getDefault().getBundle().getState() == 32;
            }
        };
        this.updateJob.setSystem(true);
        return this.updateJob;
    }

    Object getViewerInput() {
        return this.viewer.getInput();
    }

    MarkerField[] getVisibleFields() {
        return this.builder.getVisibleFields();
    }

    private IPropertyChangeListener getWorkingSetListener() {
        this.workingSetListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ExtendedMarkersView.this.builder.scheduleMarkerUpdate();
            }
        };
        return this.workingSetListener;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        Object service;
        Class<?> clazz;
        super.init(site, memento);
        MarkerContentGenerator generator = null;
        if (memento != null) {
            generator = MarkerSupportRegistry.getInstance().getGenerator(memento.getString(TAG_GENERATOR));
        }
        if (generator == null && this.defaultGeneratorIds.length > 0 && (generator = MarkerSupportRegistry.getInstance().getGenerator(this.defaultGeneratorIds[0])) == null) {
            this.logInvalidGenerator(this.defaultGeneratorIds[0]);
        }
        if (generator == null) {
            generator = MarkerSupportRegistry.getInstance().getDefaultGenerator();
        }
        if ((clazz = class$7) == null) {
            try {
                clazz = class$7 = Class.forName("org.eclipse.ui.menus.IMenuService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMenuService menuService = (IMenuService)site.getService((Class)clazz);
        menuService.populateContributionManager((ContributionManager)site.getActionBars().getMenuManager(), "menu:org.eclipse.ui.ide.MarkersView");
        menuService.populateContributionManager((ContributionManager)site.getActionBars().getToolBarManager(), "toolbar:org.eclipse.ui.ide.MarkersView");
        String viewId = site.getId();
        if (site.getSecondaryId() != null) {
            viewId = String.valueOf(viewId) + site.getSecondaryId();
        }
        this.builder = new CachedMarkerBuilder(generator, viewId, memento);
        this.builder.setUpdateJob(this.getUpdateJob(this.builder));
        Class<?> clazz2 = class$8;
        if (clazz2 == null) {
            try {
                clazz2 = class$8 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((service = site.getAdapter((Class)clazz2)) != null) {
            this.builder.setProgressService((IWorkbenchSiteProgressService)service);
        }
        this.memento = memento;
        if (memento == null || memento.getString(TAG_PART_NAME) == null) {
            return;
        }
        this.setPartName(memento.getString(TAG_PART_NAME));
    }

    void initializeTitle(String name) {
        this.setPartName(name);
    }

    boolean isEnabled(MarkerFieldFilterGroup group) {
        return this.builder.getEnabledFilters().contains(group);
    }

    boolean isPrimarySortField(MarkerField field) {
        return this.builder.getPrimarySortField().equals(field);
    }

    boolean isShowing(MarkerContentGenerator generator) {
        return this.builder.getGenerator().equals(generator);
    }

    void logInvalidGenerator(String id) {
        StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.ui.ide", NLS.bind((String)"Invalid markerContentGenerator {0} ", (Object)id)));
    }

    void openFiltersDialog() {
        FiltersConfigurationDialog dialog = new FiltersConfigurationDialog((IShellProvider)new SameShellProvider((Control)this.getSite().getWorkbenchWindow().getShell()), this.builder);
        if (dialog.open() == 0) {
            this.builder.updateFrom(dialog);
        }
    }

    void openSelectedMarkers() {
        IMarker[] markers = this.getSelectedMarkers();
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            IWorkbenchPage page = this.getSite().getPage();
            ExtendedMarkersView.openMarkerInEditor(marker, page);
            ++i;
        }
    }

    void reexpandCategories(CachedMarkerBuilder builder) {
        if (!this.getCategoriesToExpand().isEmpty() && builder.isShowingHierarchy()) {
            MarkerSupportItem[] items = builder.getElements();
            int i = 0;
            while (i < items.length) {
                String name = ((MarkerCategory)items[i]).getName();
                if (this.getCategoriesToExpand().contains(name)) {
                    this.viewer.expandToLevel(items[i], 2);
                }
                ++i;
            }
        }
    }

    private void registerContextMenu() {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.viewer);
        if (!this.getSite().getId().equals("org.eclipse.ui.ide.MarkersView")) {
            this.getSite().registerContextMenu("org.eclipse.ui.ide.MarkersView", contextMenu, (ISelectionProvider)this.viewer);
        }
        Control control = this.viewer.getControl();
        Menu menu = contextMenu.createContextMenu(control);
        control.setMenu(menu);
    }

    void removeExpandedCategory(MarkerCategory category) {
        this.getCategoriesToExpand().remove(category.getName());
    }

    void saveSelection(ISelection selection) {
        this.preservedSelection.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            Iterator iterator = structured.iterator();
            while (iterator.hasNext()) {
                MarkerSupportItem next = (MarkerSupportItem)iterator.next();
                if (next.isConcrete()) {
                    this.preservedSelection.add(new MarkerSelectionEntry(next));
                    this.getCategoriesToExpand().add(next.getParent());
                    continue;
                }
                this.getCategoriesToExpand().add(next);
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString(TAG_GENERATOR, this.builder.getGenerator().getId());
        memento.putString(TAG_PART_NAME, this.getPartName());
        if (!this.getCategoriesToExpand().isEmpty()) {
            IMemento expanded = memento.createChild(TAG_EXPANDED);
            Iterator categories = this.getCategoriesToExpand().iterator();
            while (categories.hasNext()) {
                expanded.createChild(TAG_CATEGORY, (String)categories.next());
            }
        }
        IMemento columnEntry = memento.createChild(TAG_COLUMN_WIDTHS);
        MarkerField[] fields = new MarkerField[this.viewer.getTree().getColumnCount()];
        int[] positions = this.viewer.getTree().getColumnOrder();
        int i = 0;
        while (i < fields.length) {
            TreeColumn column = this.viewer.getTree().getColumn(i);
            columnEntry.putInteger(this.getFieldId(column), column.getWidth());
            fields[positions[i]] = (MarkerField)column.getData(MARKER_FIELD);
            ++i;
        }
        this.builder.saveState(memento, fields);
    }

    void selectAll() {
        this.viewer.getTree().selectAll();
    }

    void setCategoryGroup(MarkerGroup group) {
        this.getCategoriesToExpand().clear();
        this.builder.setCategoryGroup(group);
    }

    void setContentGenerator(MarkerContentGenerator generator) {
        this.viewer.setSelection((ISelection)new StructuredSelection());
        this.viewer.removeAndClearAll();
        this.builder.setGenerator(generator);
        this.createColumns(this.viewer.getTree().getColumns());
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    void setPrimarySortField(MarkerField field) {
        TreeColumn[] columns = this.viewer.getTree().getColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn treeColumn = columns[i];
            if (columns[i].getData(MARKER_FIELD).equals(field)) {
                this.setPrimarySortField(field, treeColumn);
                return;
            }
            ++i;
        }
        StatusManager.getManager().handle(StatusUtil.newStatus(2, "Sorting by non visible field " + field.getColumnHeaderText(), null));
    }

    private void setPrimarySortField(MarkerField field, TreeColumn column) {
        this.builder.setPrimarySortField(field);
        IViewSite iViewSite = this.getViewSite();
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)iViewSite.getAdapter((Class)clazz);
        this.builder.refreshContents(service);
        this.updateDirectionIndicator(column, field);
        this.viewer.refresh();
        this.reexpandCategories(this.builder);
    }

    void setSelection(StructuredSelection structuredSelection, boolean reveal) {
        ArrayList<MarkerItem> newSelection = new ArrayList<MarkerItem>(structuredSelection.size());
        Iterator i = structuredSelection.iterator();
        while (i.hasNext()) {
            MarkerItem marker;
            Object next = i.next();
            if (!(next instanceof IMarker) || (marker = this.builder.getMarkerItem((IMarker)next)) == null) continue;
            newSelection.add(marker);
        }
        StructuredSelection structured = new StructuredSelection(newSelection);
        this.viewer.setSelection((ISelection)structured, reveal);
        this.updateStatusLine((IStructuredSelection)structured);
    }

    void toggleFilter(MarkerFieldFilterGroup group) {
        this.builder.toggleFilter(group);
    }

    void toggleSortDirection() {
        this.setPrimarySortField(this.builder.getPrimarySortField());
    }

    void updateDirectionIndicator(TreeColumn column, MarkerField field) {
        this.viewer.getTree().setSortColumn(column);
        if (this.builder.getSortDirection(field) == 1) {
            this.viewer.getTree().setSortDirection(128);
        } else {
            this.viewer.getTree().setSortDirection(1024);
        }
    }

    private void updateStatusLine(IStructuredSelection newSelection) {
        String message = newSelection == null || newSelection.size() == 0 ? "" : (newSelection.size() == 1 ? ((MarkerSupportItem)newSelection.getFirstElement()).getDescription() : MessageFormat.format((String)MarkerMessages.marker_statusSummarySelected, (Object[])new Object[]{new Integer(newSelection.size()), this.getStatusMessage()}));
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    void updateTitle() {
        this.setContentDescription(this.getStatusMessage());
    }

    private void initDragAndDrop() {
        int operations = 1;
        Transfer[] transferTypes = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
        DragSourceAdapter listener = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                ExtendedMarkersView.this.performDragSetData(event);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        };
        this.viewer.addDragSupport(operations, transferTypes, (DragSourceListener)listener);
    }

    private void performDragSetData(DragSourceEvent event) {
        IMarker[] markers;
        if (MarkerTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.getSelectedMarkers();
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(event.dataType) && (markers = this.getSelectedMarkers()) != null) {
            event.data = MarkerCopyHandler.createMarkerReport(this, markers);
        }
    }

    Object[] getHiddenFields() {
        return this.builder.getHiddenFields();
    }

    void setVisibleFields(Collection visible) {
        this.builder.setVisibleFields(visible);
        this.viewer.setSelection((ISelection)new StructuredSelection());
        this.viewer.removeAndClearAll();
        this.createColumns(this.viewer.getTree().getColumns());
    }

    TreeViewer getViewer() {
        return this.viewer;
    }

    final class MarkerSelectionEntry {
        Object[] cachedValues;

        MarkerSelectionEntry(MarkerItem item) {
            MarkerField[] fields = ExtendedMarkersView.this.builder.getVisibleFields();
            this.cachedValues = new Object[fields.length];
            int i = 0;
            while (i < fields.length) {
                this.cachedValues[i] = fields[i].getValue(item);
                ++i;
            }
        }

        boolean isEquivalentTo(MarkerItem item) {
            MarkerField[] fields = ExtendedMarkersView.this.builder.getVisibleFields();
            if (this.cachedValues.length != fields.length) {
                return false;
            }
            int i = 0;
            while (i < fields.length) {
                if (this.cachedValues[i] != fields[i].getValue(item)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

