/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.RenameResourceAction;

public class ResourceNavigatorRenameAction
extends RenameResourceAction {
    private TreeViewer viewer;

    public ResourceNavigatorRenameAction(Shell shell, TreeViewer treeViewer) {
        super(shell, treeViewer.getTree());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.resource_navigator_rename_action_context");
        this.viewer = treeViewer;
    }

    protected void runWithNewPath(IPath path, IResource resource) {
        IResource newResource;
        IWorkspaceRoot root = resource.getProject().getWorkspace().getRoot();
        super.runWithNewPath(path, resource);
        if (this.viewer != null && (newResource = root.findMember(path)) != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)newResource), true);
        }
    }

    public void handleKeyReleased(KeyEvent event) {
        if (event.keyCode == 0x100000B && event.stateMask == 0 && this.isEnabled()) {
            this.run();
        }
    }
}

