/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObjList;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class JGoPort
extends JGoDrawable {
    public static final int StyleHidden = 0;
    public static final int StyleObject = 1;
    public static final int StyleEllipse = 2;
    public static final int StyleTriangle = 3;
    public static final int StyleRectangle = 4;
    public static final int StyleDiamond = 5;
    public static final int ChangedStyle = 301;
    public static final int ChangedObject = 302;
    public static final int ChangedValidSource = 303;
    public static final int ChangedValidDestination = 304;
    public static final int ChangedFromSpot = 305;
    public static final int ChangedToSpot = 306;
    public static final int ChangedAddedLink = 307;
    public static final int ChangedRemovedLink = 308;
    private static double \u013d = 0.15;
    private static double \u013e = 0.25;
    private int myStyle = 2;
    private JGoObject myObject = null;
    private int myFromLinkSpot = 4;
    private int myToLinkSpot = 8;
    private JGoObjList myLinks = new JGoObjList();

    public JGoPort() {
        this.\u00c0(2);
    }

    public JGoPort(Rectangle rectangle) {
        super(rectangle);
        this.\u00c0(2);
    }

    public JGoPort(Point point, Dimension dimension) {
        super(point, dimension);
        this.\u00c0(2);
    }

    public JGoPort(Rectangle rectangle, JGoObject jGoObject) {
        super(rectangle);
        this.\u00c0(1);
        if (jGoObject.getLayer() != null) {
            jGoObject.getLayer().removeObject(jGoObject.getTopLevelObject());
        } else if (jGoObject.getView() != null) {
            jGoObject.getView().removeObject(jGoObject.getTopLevelObject());
        }
        jGoObject.setSelectable(false);
        jGoObject.setDraggable(false);
        jGoObject.setResizable(false);
        this.myObject = jGoObject;
    }

    private final void \u00c0(int n) {
        this.myStyle = n;
        this.setFlags(this.getFlags() & 0xFFFFFFFB & 0xFFFFFFEF | 0x4000 | 0x2000);
        this.setBrush(JGoBrush.black);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        JGoPort jGoPort = (JGoPort)super.copyObject(jGoCopyEnvironment);
        if (jGoPort != null) {
            jGoPort.setFlags(jGoPort.getFlags() & 0xFFFF7FFF);
            jGoPort.myStyle = this.myStyle;
            jGoPort.myFromLinkSpot = this.myFromLinkSpot;
            jGoPort.myToLinkSpot = this.myToLinkSpot;
            jGoPort.myObject = this.myObject;
        }
        return jGoPort;
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        if (this.paintGreek(graphics2D, jGoView)) {
            return;
        }
        Rectangle rectangle = this.getBoundingRect();
        switch (this.getStyle()) {
            case 0: {
                return;
            }
            case 1: {
                JGoObject jGoObject = this.getPortObject();
                if (jGoObject == null) break;
                jGoObject.setBoundingRect(rectangle);
                jGoObject.paint(graphics2D, jGoView);
                break;
            }
            case 3: {
                int[] nArray = jGoView.\u00cc();
                int[] nArray2 = jGoView.\u00cd();
                switch (this.getToSpot()) {
                    case 1: {
                        nArray[0] = rectangle.x + rectangle.width / 2;
                        nArray2[0] = rectangle.y;
                        nArray[1] = rectangle.x + rectangle.width;
                        nArray2[1] = rectangle.y + rectangle.height;
                        nArray[2] = rectangle.x;
                        nArray2[2] = rectangle.y + rectangle.height / 2;
                        break;
                    }
                    case 2: {
                        nArray[0] = rectangle.x + rectangle.width;
                        nArray2[0] = rectangle.y;
                        nArray[1] = rectangle.x + rectangle.width / 2;
                        nArray2[1] = rectangle.y + rectangle.height;
                        nArray[2] = rectangle.x;
                        nArray2[2] = rectangle.y;
                        break;
                    }
                    case 3: {
                        nArray[0] = rectangle.x + rectangle.width;
                        nArray2[0] = rectangle.y + rectangle.height / 2;
                        nArray[1] = rectangle.x;
                        nArray2[1] = rectangle.y + rectangle.height;
                        nArray[2] = rectangle.x + rectangle.width / 2;
                        nArray2[2] = rectangle.y;
                        break;
                    }
                    case 4: {
                        nArray[0] = rectangle.x + rectangle.width;
                        nArray2[0] = rectangle.y + rectangle.height;
                        nArray[1] = rectangle.x;
                        nArray2[1] = rectangle.y + rectangle.height / 2;
                        nArray[2] = rectangle.x + rectangle.width;
                        nArray2[2] = rectangle.y;
                        break;
                    }
                    case 5: {
                        nArray[0] = rectangle.x + rectangle.width / 2;
                        nArray2[0] = rectangle.y + rectangle.height;
                        nArray[1] = rectangle.x;
                        nArray2[1] = rectangle.y;
                        nArray[2] = rectangle.x + rectangle.width;
                        nArray2[2] = rectangle.y + rectangle.height / 2;
                        break;
                    }
                    case 6: {
                        nArray[0] = rectangle.x;
                        nArray2[0] = rectangle.y + rectangle.height;
                        nArray[1] = rectangle.x + rectangle.width / 2;
                        nArray2[1] = rectangle.y;
                        nArray[2] = rectangle.x + rectangle.width;
                        nArray2[2] = rectangle.y + rectangle.height;
                        break;
                    }
                    case 7: {
                        nArray[0] = rectangle.x;
                        nArray2[0] = rectangle.y + rectangle.height / 2;
                        nArray[1] = rectangle.x + rectangle.width;
                        nArray2[1] = rectangle.y;
                        nArray[2] = rectangle.x + rectangle.width / 2;
                        nArray2[2] = rectangle.y + rectangle.height;
                        break;
                    }
                    default: {
                        nArray[0] = rectangle.x;
                        nArray2[0] = rectangle.y;
                        nArray[1] = rectangle.x + rectangle.width;
                        nArray2[1] = rectangle.y + rectangle.height / 2;
                        nArray[2] = rectangle.x;
                        nArray2[2] = rectangle.y + rectangle.height;
                    }
                }
                this.drawPolygon(graphics2D, nArray, nArray2, 3);
                break;
            }
            case 4: {
                this.drawRect(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                break;
            }
            case 5: {
                int[] nArray = jGoView.\u00cc();
                int[] nArray3 = jGoView.\u00cd();
                nArray[0] = rectangle.x + rectangle.width / 2;
                nArray3[0] = rectangle.y;
                nArray[1] = rectangle.x + rectangle.width;
                nArray3[1] = rectangle.y + rectangle.height / 2;
                nArray[2] = nArray[0];
                nArray3[2] = rectangle.y + rectangle.height;
                nArray[3] = rectangle.x;
                nArray3[3] = nArray3[1];
                this.drawPolygon(graphics2D, nArray, nArray3, 4);
                break;
            }
            default: {
                this.drawEllipse(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public boolean paintGreek(Graphics2D graphics2D, JGoView jGoView) {
        double d = jGoView.getScale();
        double d2 = JGoPort.getDefaultPaintNothingScale();
        double d3 = JGoPort.getDefaultPaintGreekScale();
        if (jGoView.isPrinting()) {
            d2 /= 3.0;
            d3 /= 3.0;
        }
        if (d <= d2) {
            return true;
        }
        if (d <= d3) {
            if (this.getStyle() != 0) {
                Rectangle rectangle = this.getBoundingRect();
                graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            return true;
        }
        return false;
    }

    public void expandRectByPenWidth(Rectangle rectangle) {
        JGoObject jGoObject = this.getPortObject();
        if (jGoObject != null) {
            jGoObject.expandRectByPenWidth(rectangle);
        } else {
            super.expandRectByPenWidth(rectangle);
        }
    }

    public int getStyle() {
        return this.myStyle;
    }

    public void setStyle(int n) {
        int n2 = this.getStyle();
        if (n2 != n) {
            this.myStyle = n;
            this.update(301, n2, null);
            this.portChange(301, n2, null);
        }
    }

    public JGoObject getPortObject() {
        return this.myObject;
    }

    public void setPortObject(JGoObject jGoObject) {
        JGoObject jGoObject2;
        if (jGoObject != null) {
            if (jGoObject.getLayer() != null) {
                jGoObject.getLayer().removeObject(jGoObject.getTopLevelObject());
            } else if (jGoObject.getView() != null) {
                jGoObject.getView().removeObject(jGoObject.getTopLevelObject());
            }
        }
        if ((jGoObject2 = this.getPortObject()) != jGoObject) {
            this.myObject = jGoObject;
            this.update(302, 0, jGoObject2);
            this.portChange(302, 0, jGoObject2);
        }
    }

    public int getNumLinks() {
        return this.myLinks.getNumObjects();
    }

    public boolean hasNoLinks() {
        return this.myLinks.isEmpty();
    }

    public JGoListPosition getFirstLinkPos() {
        return this.myLinks.getFirstObjectPos();
    }

    public JGoLink getLinkAtPos(JGoListPosition jGoListPosition) {
        return (JGoLink)this.myLinks.getObjectAtPos(jGoListPosition);
    }

    public JGoListPosition getNextLinkPos(JGoListPosition jGoListPosition) {
        return this.myLinks.getNextObjectPos(jGoListPosition);
    }

    public void removeAllLinks() {
        JGoListPosition jGoListPosition = this.getFirstLinkPos();
        while (jGoListPosition != null) {
            JGoLink jGoLink = this.getLinkAtPos(jGoListPosition);
            jGoLink.unlink();
            jGoListPosition = this.getFirstLinkPos();
        }
    }

    public Point getLinkPoint(int n, Point point) {
        Rectangle rectangle = this.getBoundingRect();
        if (point == null) {
            point = new Point();
        }
        int n2 = rectangle.x;
        int n3 = rectangle.x + rectangle.width / 2;
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y;
        int n6 = rectangle.y + rectangle.height / 2;
        int n7 = rectangle.y + rectangle.height;
        switch (n) {
            default: {
                point.x = n3;
                point.y = n6;
                break;
            }
            case 1: {
                point.x = n2;
                point.y = n5;
                break;
            }
            case 2: {
                point.x = n3;
                point.y = n5;
                break;
            }
            case 3: {
                point.x = n4;
                point.y = n5;
                break;
            }
            case 4: {
                point.x = n4;
                point.y = n6;
                break;
            }
            case 5: {
                point.x = n4;
                point.y = n7;
                break;
            }
            case 6: {
                point.x = n3;
                point.y = n7;
                break;
            }
            case 7: {
                point.x = n2;
                point.y = n7;
                break;
            }
            case 8: {
                point.x = n2;
                point.y = n6;
            }
        }
        return point;
    }

    public final Point getLinkPoint(int n) {
        return this.getLinkPoint(n, null);
    }

    public Point getLinkPointFromPoint(int n, int n2, Point point) {
        return this.getLinkPoint(0, point);
    }

    public Point getFromLinkPoint(Point point) {
        return this.getLinkPoint(this.getFromSpot(), point);
    }

    public final Point getFromLinkPoint() {
        return this.getLinkPoint(this.getFromSpot(), null);
    }

    public Point getToLinkPoint(Point point) {
        return this.getLinkPoint(this.getToSpot(), point);
    }

    public final Point getToLinkPoint() {
        return this.getLinkPoint(this.getToSpot(), null);
    }

    public int getFromSpot() {
        return this.myFromLinkSpot;
    }

    public void setFromSpot(int n) {
        int n2 = this.getFromSpot();
        if (n2 != n) {
            this.myFromLinkSpot = n;
            this.update(305, n2, null);
            this.portChange(305, n2, null);
        }
    }

    public int getToSpot() {
        return this.myToLinkSpot;
    }

    public void setToSpot(int n) {
        int n2 = this.getToSpot();
        if (n2 != n) {
            this.myToLinkSpot = n;
            this.update(306, n2, null);
            this.portChange(306, n2, null);
        }
    }

    public double getLinkDir(int n) {
        switch (n) {
            default: {
                return -1.0;
            }
            case 1: {
                return 3.9269908169872414;
            }
            case 2: {
                return 4.71238898038469;
            }
            case 3: {
                return 5.497787143782138;
            }
            case 4: {
                return 0.0;
            }
            case 5: {
                return 0.7853981633974483;
            }
            case 6: {
                return 1.5707963267948966;
            }
            case 7: {
                return 2.356194490192345;
            }
            case 8: 
        }
        return Math.PI;
    }

    public double getFromLinkDir() {
        return this.getLinkDir(this.getFromSpot());
    }

    public double getToLinkDir() {
        return this.getLinkDir(this.getToSpot());
    }

    public boolean validLink(JGoPort jGoPort) {
        return this != jGoPort && this.isVisible() && this.isValidSource() && jGoPort.isVisible() && jGoPort.isValidDestination();
    }

    public boolean isValidLink() {
        return (this.getFlags() & 0x8000) != 0;
    }

    public boolean isValidSource() {
        return (this.getFlags() & 0x4000) != 0;
    }

    public void setValidSource(boolean bl) {
        boolean bl2 = this.isValidSource();
        if (bl2 != bl) {
            if (bl) {
                this.setFlags(this.getFlags() | 0x4000);
            } else {
                this.setFlags(this.getFlags() & 0xFFFFBFFF);
            }
            this.update(303, bl2 ? 1 : 0, null);
        }
    }

    public boolean isValidDestination() {
        return (this.getFlags() & 0x2000) != 0;
    }

    public void setValidDestination(boolean bl) {
        boolean bl2 = this.isValidDestination();
        if (bl2 != bl) {
            if (bl) {
                this.setFlags(this.getFlags() | 0x2000);
            } else {
                this.setFlags(this.getFlags() & 0xFFFFDFFF);
            }
            this.update(304, bl2 ? 1 : 0, null);
        }
    }

    void \u013d(boolean bl) {
        if (bl) {
            this.setFlags(this.getFlags() | 0x8000);
        } else {
            this.setFlags(this.getFlags() & 0xFFFF7FFF);
        }
    }

    void \u013e(JGoLink jGoLink) {
        if (this.myLinks.findObject(jGoLink) == null) {
            this.myLinks.addObjectAtTail(jGoLink);
            this.linkChange();
            this.update(307, 0, jGoLink);
        }
    }

    void \u013f(JGoLink jGoLink) {
        JGoListPosition jGoListPosition = this.myLinks.findObject(jGoLink);
        if (jGoListPosition != null) {
            this.myLinks.removeObjectAtPos(jGoListPosition);
            this.linkChange();
            this.update(308, 0, jGoLink);
        }
    }

    protected void geometryChange(Rectangle rectangle) {
        super.geometryChange(rectangle);
        this.portChange(1, 0, rectangle);
    }

    public void portChange(int n, int n2, Object object) {
        JGoListPosition jGoListPosition = this.getFirstLinkPos();
        while (jGoListPosition != null) {
            JGoLink jGoLink = this.getLinkAtPos(jGoListPosition);
            jGoListPosition = this.getNextLinkPos(jGoListPosition);
            jGoLink.portChange(this, n, n2, object);
        }
    }

    public final void portChange() {
        this.portChange(0, 0, null);
    }

    public void linkChange() {
    }

    public void ownerChange(Object object, Object object2) {
        super.ownerChange(object, object2);
        if (object2 == null) {
            this.removeAllLinks();
        }
    }

    public int getEndSegmentLength() {
        return 10;
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 301: {
                jGoDocumentChangedEdit.setNewValueInt(this.getStyle());
                return;
            }
            case 302: {
                jGoDocumentChangedEdit.setNewValue(this.getPortObject());
                return;
            }
            case 303: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isValidSource());
                return;
            }
            case 304: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isValidDestination());
                return;
            }
            case 305: {
                jGoDocumentChangedEdit.setNewValueInt(this.getFromSpot());
                return;
            }
            case 306: {
                jGoDocumentChangedEdit.setNewValueInt(this.getToSpot());
                return;
            }
            case 307: {
                return;
            }
            case 308: {
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 301: {
                this.setStyle(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
            case 302: {
                this.setPortObject((JGoObject)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 303: {
                this.setValidSource(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 304: {
                this.setValidDestination(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 305: {
                this.setFromSpot(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
            case 306: {
                this.setToSpot(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
            case 307: {
                JGoLink jGoLink = (JGoLink)jGoDocumentChangedEdit.getOldValue();
                if (bl) {
                    this.\u013f(jGoLink);
                } else {
                    this.\u013e(jGoLink);
                }
                return;
            }
            case 308: {
                JGoLink jGoLink = (JGoLink)jGoDocumentChangedEdit.getOldValue();
                if (bl) {
                    this.\u013e(jGoLink);
                } else {
                    this.\u013f(jGoLink);
                }
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }

    public static double getDefaultPaintNothingScale() {
        return \u013d;
    }

    public static void setDefaultPaintNothingScale(double d) {
        \u013d = d;
    }

    public static double getDefaultPaintGreekScale() {
        return \u013e;
    }

    public static void setDefaultPaintGreekScale(double d) {
        \u013e = d;
    }
}

