/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.combination;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.VerticalSymbolicAxis;
import com.jrefinery.chart.combination.AxisRange;
import com.jrefinery.chart.combination.CombinableAxis;
import com.jrefinery.chart.combination.NumberAxisRange;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class CombinedVerticalSymbolicAxis
extends VerticalSymbolicAxis
implements CombinableAxis {
    private VerticalSymbolicAxis axis = null;
    private boolean visible = true;
    private double reserveWidth = 0.0;

    public CombinedVerticalSymbolicAxis(VerticalSymbolicAxis verticalSymbolicAxis, boolean bl) {
        this(verticalSymbolicAxis, true, bl);
    }

    public CombinedVerticalSymbolicAxis(VerticalSymbolicAxis verticalSymbolicAxis, boolean bl, boolean bl2) {
        super(verticalSymbolicAxis.getLabel(), verticalSymbolicAxis.getSymbolicValue(), verticalSymbolicAxis.getLabelFont(), verticalSymbolicAxis.getLabelPaint(), verticalSymbolicAxis.getLabelInsets(), verticalSymbolicAxis.isVerticalLabel(), verticalSymbolicAxis.isTickLabelsVisible(), verticalSymbolicAxis.getTickLabelFont(), verticalSymbolicAxis.getTickLabelPaint(), verticalSymbolicAxis.getTickLabelInsets(), verticalSymbolicAxis.isTickMarksVisible(), verticalSymbolicAxis.getTickMarkStroke(), verticalSymbolicAxis.isAutoRange(), verticalSymbolicAxis.autoRangeIncludesZero(), verticalSymbolicAxis.autoRangeStickyZero(), verticalSymbolicAxis.getAutoRangeMinimumSize(), verticalSymbolicAxis.getMinimumAxisValue(), verticalSymbolicAxis.getMaximumAxisValue(), verticalSymbolicAxis.isInverted(), verticalSymbolicAxis.isAutoTickUnitSelection(), verticalSymbolicAxis.getTickUnit(), verticalSymbolicAxis.isGridLinesVisible(), verticalSymbolicAxis.getGridStroke(), verticalSymbolicAxis.getGridPaint(), verticalSymbolicAxis.isCrosshairVisible(), verticalSymbolicAxis.getCrosshairValue(), verticalSymbolicAxis.getCrosshairStroke(), verticalSymbolicAxis.getCrosshairPaint(), bl2, verticalSymbolicAxis.getSymbolicGridPaint());
        this.axis = verticalSymbolicAxis;
        this.visible = bl;
        this.setCrosshairVisible(verticalSymbolicAxis.isCrosshairVisible());
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (this.visible) {
            this.axis.draw(graphics2D, rectangle2D, rectangle2D2);
        } else if (this.symbolicGridLinesVisible) {
            this.axis.drawSymbolicGridLines(graphics2D, rectangle2D, rectangle2D2);
        }
    }

    public void setReserveDimension(double d) {
        this.reserveWidth = d;
    }

    public double reserveWidth(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D) {
        if (!this.visible) {
            return 0.0;
        }
        if (this.reserveWidth > 0.0) {
            return this.reserveWidth;
        }
        return this.axis.reserveWidth(graphics2D, plot, rectangle2D);
    }

    public Rectangle2D reserveAxisArea(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, double d) {
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), this.reserveWidth(graphics2D, plot, rectangle2D), rectangle2D.getHeight() - d);
    }

    public Axis getParentAxis() {
        return this.axis;
    }

    public AxisRange getRange() {
        this.autoAdjustRange();
        return new NumberAxisRange(new Double(this.getMinimumAxisValue()), new Double(this.getMaximumAxisValue()));
    }

    public void setRange(AxisRange axisRange) {
        this.setAutoRange(false);
        Number number = (Number)axisRange.getMin();
        Number number2 = (Number)axisRange.getMax();
        this.setMinimumAxisValue(number.doubleValue());
        this.setMaximumAxisValue(number2.doubleValue());
        if (this.visible) {
            VerticalSymbolicAxis verticalSymbolicAxis = (VerticalSymbolicAxis)this.getParentAxis();
            verticalSymbolicAxis.setAutoRange(false);
            verticalSymbolicAxis.setMinimumAxisValue(number.doubleValue());
            verticalSymbolicAxis.setMaximumAxisValue(number2.doubleValue());
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Rectangle2D.Double getSymbolicGridLine(int n) {
        return this.axis.getSymbolicGridLine(n);
    }
}

