/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse;

import com.insightful.splus.SplusBadDataException;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class SplusProjectWizard
extends BasicNewProjectResourceWizard {
    private SplusNewProjectCreationPage packagePage;
    private final String PKG_UTILS_ERROR_TITLE = "pkgutils Error";

    public static boolean isSplusProject(IProject iProject) {
        try {
            return iProject.getNature("com.insightful.splus.eclipse.splusnature") != null;
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            return false;
        }
    }

    public void addPages() {
        this.packagePage = new SplusNewProjectCreationPage("S-PLUS Project");
        this.packagePage.setTitle("S-PLUS Project");
        this.packagePage.setDescription("Create S-PLUS Project.");
        this.addPage((IWizardPage)this.packagePage);
    }

    private IProject createNewProject(final IProjectDescription iProjectDescription, IProject iProject) {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                CreateProjectOperation createProjectOperation = new CreateProjectOperation(iProjectDescription, ResourceMessages.NewProject_windowTitle);
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)createProjectOperation, iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)SplusProjectWizard.this.getShell()));
                }
                catch (ExecutionException executionException) {
                    throw new InvocationTargetException(executionException);
                }
            }
        };
        try {
            this.getContainer().run(true, true, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ExecutionException && throwable.getCause() instanceof CoreException) {
                CoreException coreException = (CoreException)throwable.getCause();
                StatusAdapter statusAdapter = coreException.getStatus().getCode() == 275 ? new StatusAdapter(StatusUtil.newStatus((int)2, (String)NLS.bind((String)ResourceMessages.NewProject_caseVariantExistsError, (Object)iProject.getName()), (Throwable)coreException)) : new StatusAdapter(StatusUtil.newStatus((int)coreException.getStatus().getSeverity(), (String)ResourceMessages.NewProject_errorMessage, (Throwable)coreException));
                statusAdapter.setProperty(StatusAdapter.TITLE_PROPERTY, (Object)ResourceMessages.NewProject_errorMessage);
                StatusManager.getManager().handle(statusAdapter, 4);
            } else {
                StatusAdapter statusAdapter = new StatusAdapter((IStatus)new Status(2, "org.eclipse.ui.ide", 0, NLS.bind((String)ResourceMessages.NewProject_internalError, (Object)throwable.getMessage()), throwable));
                statusAdapter.setProperty(StatusAdapter.TITLE_PROPERTY, (Object)ResourceMessages.NewProject_errorMessage);
                StatusManager.getManager().handle(statusAdapter, 5);
            }
            return null;
        }
        return iProject;
    }

    public boolean performFinish() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        String string = this.packagePage.getProjectName();
        IPath iPath = this.packagePage.getLocationPath();
        try {
            IProject iProject = iWorkspace.getRoot().getProject(string);
            IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(string);
            if (iPath.equals(iWorkspace.getRoot().getLocation())) {
                iPath = iPath.append(string);
                iProjectDescription.setLocation(null);
            } else {
                iProjectDescription.setLocation(iPath);
            }
            iProjectDescription.setNatureIds(new String[]{"com.insightful.splus.eclipse.splusnature"});
            ICommand[] iCommandArray = new ICommand[2];
            iCommandArray[0] = iProjectDescription.newCommand();
            iCommandArray[0].setBuilderName("com.insightful.splus.eclipse.taskfinder");
            iCommandArray[1] = iProjectDescription.newCommand();
            iCommandArray[1].setBuilderName("com.insightful.splus.eclipse.parser");
            iProjectDescription.setBuildSpec(iCommandArray);
            if (this.packagePage.createPackageStructure() && !this.createPackage(iPath)) {
                return false;
            }
            this.createNewProject(iProjectDescription, iProject);
            SplusEditorPlugin.getDefault().toggleActiveProject(iProject.getName());
            iProject.refreshLocal(2, null);
            IFolder iFolder = iProject.getFolder(".Data");
            iFolder.setDerived(true);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return true;
    }

    private boolean createPackage(IPath iPath) {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection) {
            DefaultConnection defaultConnection = (DefaultConnection)noConnection;
            String string = "library(pkgutils)";
            SplusDataResult splusDataResult = defaultConnection.processDataQuery(string);
            if (this.handleSplusError(splusDataResult)) {
                return false;
            }
            String string2 = "identical(packageDescription('pkgutils')$Package, 'pkgutilsStub')";
            splusDataResult = defaultConnection.processDataQuery(string2);
            try {
                if (splusDataResult.getBooleanData()[0]) {
                    String string3 = "A placeholder version of pkgutils library was detected.\nCancel out of the Create New Project wizard.\nRun install.pkgutils() when connected to the Internet.";
                    this.handleSplusError(string3, "pkgutils Error");
                    return false;
                }
            }
            catch (SplusBadDataException splusBadDataException) {
                splusBadDataException.printStackTrace();
                return false;
            }
            String string4 = iPath.lastSegment();
            String string5 = iPath.removeLastSegments(1).toString();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("package.skeleton(");
            stringBuffer.append("force=T, ");
            stringBuffer.append("name=\"");
            stringBuffer.append(string4);
            stringBuffer.append("\", ");
            stringBuffer.append("path=\"");
            stringBuffer.append(string5);
            stringBuffer.append("\")");
            splusDataResult = defaultConnection.processDataQuery(stringBuffer.toString());
            if (this.handleSplusError(splusDataResult)) {
                return false;
            }
            SplusEditorPlugin.getDefault().getConsoleDocument().pollForOutput();
            return true;
        }
        return false;
    }

    private boolean handleSplusError(SplusDataResult splusDataResult) {
        if (splusDataResult.hasError()) {
            return this.handleSplusError(splusDataResult.getError(), "pkgutils Error");
        }
        return false;
    }

    private boolean handleSplusError(final String string, final String string2) {
        Display display = SplusEditorPlugin.getDefault().getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                MessageDialog.openWarning(null, (String)string2, (String)string);
            }
        });
        return true;
    }

    private class SplusNewProjectCreationPage
    extends WizardNewProjectCreationPage {
        private Button skeleton;

        public SplusNewProjectCreationPage(String string) {
            super(string);
        }

        public void createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            composite2.setLayout((Layout)gridLayout);
            composite2.setLayoutData((Object)new GridData(768));
            super.createControl(composite2);
            Composite composite3 = new Composite(composite2, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            composite3.setLayout((Layout)gridLayout);
            composite3.setLayoutData((Object)new GridData(1808));
            this.skeleton = new Button(composite3, 32);
            this.skeleton.setText("Create S-PLUS Package structure");
            this.setControl((Control)composite2);
        }

        private boolean createPackageStructure() {
            return this.skeleton.getSelection();
        }
    }
}

