/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.connection;

import com.insightful.gdevice.SCanvas;
import com.insightful.splus.ClientObjectFactory;
import com.insightful.splus.ClientObjectFactoryImpl;
import com.insightful.splus.RemoteFileInputStream;
import com.insightful.splus.SplusBadDataException;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusEngineBusyException;
import com.insightful.splus.SplusEngineQueryHandler;
import com.insightful.splus.SplusHelpManagerInstance;
import com.insightful.splus.SplusHelpQueryHandler;
import com.insightful.splus.SplusIncompleteExpressionException;
import com.insightful.splus.SplusLicenseException;
import com.insightful.splus.SplusOutputHandler;
import com.insightful.splus.SplusSession;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.SplusWinSessionEvent;
import com.insightful.splus.SplusWinSessionListener;
import com.insightful.splus.eclipse.SplusEclipseSession;
import com.insightful.splus.eclipse.SplusEclipseSessionImpl;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.SplusRemoteEclipseSessionImpl;
import com.insightful.splus.eclipse.connection.ConsoleOutputHandler;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.connection.SplusEclipseGui;
import com.insightful.splus.eclipse.preferences.SplusConnectionPreferencePage;
import com.insightful.splus.eclipse.preferences.SplusPreferencePage;
import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import com.insightful.splus.util.ClassUtilities;
import com.insightful.splus.util.FileUtilities;
import com.insightful.splus.util.StringUtilities;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class DefaultConnection
extends NoConnection
implements IPropertyChangeListener,
SplusEngineQueryHandler,
SplusWinSessionListener,
SplusHelpQueryHandler {
    protected ConsoleOutputHandler m_outputHandler = null;
    protected SplusEclipseSession m_splusSession = null;
    protected SplusEclipseGui m_eclipseGui = null;
    private boolean m_splusBusy = false;
    private static boolean m_isWindowsOS = SplusEditorPlugin.g_isWindowsOS;
    private static boolean m_isSolarisOS = SplusEditorPlugin.g_isSolarisOS;
    private static boolean g_localSameProcessEngineExisted = false;
    public static String COMPLETE_EXPRESSION = "complete";
    public static String INCOMPLETE_EXPRESSION = "incomplete";
    public static String INCOMPLETE_STRING = "continue string";
    public static String FAILED_EXPRESSION = "stop";
    public boolean m_initializeOutputHandler = true;
    public boolean m_isNonExternalConnection = true;
    public String m_connectionDescription = "";
    public String m_connectionErrorString = "";
    private ClientObjectFactory m_clientObjectFactory = null;
    private boolean m_escape = false;
    private boolean m_escaped = false;
    private boolean m_noEval = false;
    private boolean m_beginEval = false;
    private boolean m_endEval = false;
    private boolean m_sendOutput = false;
    private boolean m_wantInput = false;
    private boolean m_gotInput = false;
    private boolean m_doQuit = false;
    private static HashMap m_sessionListeners = new HashMap();
    private Object m_syncObject = new Object();
    private boolean m_hasCanvas = false;
    private Vector m_storedCanvas = new Vector();

    public DefaultConnection(ConsoleHistoryDocument consoleHistoryDocument) throws Exception {
        super(consoleHistoryDocument);
        SplusEditorPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.createSplusSession();
        SplusEditorPlugin.getDefault().getSplusIntelliSenseHelper(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SplusConnectionPreferencePage.isRelevantProperty(propertyChangeEvent.getProperty()) && (!this.m_connectionDescription.equals(this.getConnectionDescription()) || SplusConnectionPreferencePage.isResetForced())) {
            try {
                this.createSplusSession();
                this.getOutputHandler().pollPreexistingEngineOutput(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static boolean localSameProcessConnectionRestart() {
        return g_localSameProcessEngineExisted;
    }

    public boolean isNonExternalConnection() {
        return this.m_isNonExternalConnection;
    }

    public String getConnectionDescription() {
        return this.getConnectionDescription(SplusConnectionPreferencePage.useExternal(), SplusConnectionPreferencePage.useLocal());
    }

    public String getConnectionDescription(boolean bl, boolean bl2) {
        if (!bl) {
            return "sameProcess | " + SplusConnectionPreferencePage.getSproj().toLowerCase();
        }
        if (bl2) {
            String string = SplusConnectionPreferencePage.getSproj().toLowerCase();
            String string2 = Integer.toString(SplusConnectionPreferencePage.getLocalRmiPort());
            String string3 = SplusConnectionPreferencePage.getOptions().toLowerCase();
            return "external | " + string + " | " + string2 + " | " + string3;
        }
        String string = SplusConnectionPreferencePage.getServer().toLowerCase();
        String string4 = Integer.toString(SplusConnectionPreferencePage.getRemoteRmiPort());
        return "external | " + string + " | " + string4;
    }

    public void closeSession() {
        try {
            if (this.m_splusSession != null) {
                this.m_splusSession.sessionExit(false);
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    private ClientObjectFactory getClientObjectFactory() throws RemoteException {
        if (this.m_clientObjectFactory == null) {
            this.m_clientObjectFactory = new ClientObjectFactoryImpl(){

                public void shutdown() {
                }
            };
        }
        return this.m_clientObjectFactory;
    }

    public ConsoleOutputHandler getOutputHandler() {
        try {
            if (this.m_outputHandler == null) {
                this.m_outputHandler = new ConsoleOutputHandler(this.m_doc);
            }
            if (this.m_connectionErrorString.length() != 0) {
                this.m_outputHandler.write(this.m_connectionErrorString, false);
                this.m_connectionErrorString = "";
            }
            if (this.m_initializeOutputHandler) {
                this.m_initializeOutputHandler = false;
                if (this.isNonExternalConnection()) {
                    this.m_splusSession.startPollOutput((SplusOutputHandler)this.m_outputHandler);
                } else {
                    this.m_splusSession.setClientObjectFactory(this.getClientObjectFactory());
                }
                this.m_outputHandler.pollPreexistingEngineOutput(this);
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return this.m_outputHandler;
    }

    public static String getShome() {
        return System.getProperty("splus.shome", "");
    }

    public static String getSproj() {
        String string = System.getProperty("splus.sproj", "");
        if (string == null || string.length() == 0) {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription iWorkspaceDescription = iWorkspace.getDescription();
            IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
            IResource iResource = iWorkspaceRoot.findMember(".");
            IPath iPath = iResource.getLocation();
            string = iPath.toOSString();
        }
        return string;
    }

    public void resetSplusConnection(String string, String string2) throws RemoteException, SplusLicenseException {
        String[] stringArray;
        int n;
        SplusEclipseSession splusEclipseSession = this.m_splusSession;
        if (splusEclipseSession != null) {
            this.getOutputHandler().write("\n", false);
        }
        String string3 = System.getProperty("splus.environment.vars", "");
        String[] stringArray2 = string3.split(",");
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n2 == -1 && n3 == -1 && n < stringArray2.length; ++n) {
            stringArray = stringArray2[n].trim();
            if (n2 == -1 && stringArray.startsWith("S_HOME=")) {
                n2 = n;
                continue;
            }
            if (n3 != -1 || !stringArray.startsWith("S_PROJ=")) continue;
            n3 = n;
        }
        n = stringArray2.length + 1;
        if (n2 == -1) {
            ++n;
        }
        if (n3 == -1) {
            ++n;
        }
        stringArray = new String[n];
        stringArray[0] = "java.exe";
        stringArray[1] = n2 == -1 ? "S_HOME=" + string : "S_HOME=" + stringArray2[n2].substring("S_HOME=".length());
        stringArray[2] = n3 == -1 ? "S_PROJ=" + string2 : "S_PROJ=" + stringArray2[n3].substring("S_PROJ=".length());
        int n4 = 3;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (i == n2 || i == n3) continue;
            stringArray[n4++] = stringArray2[i].trim();
        }
        System.setProperty("splus.interactive.commandline", System.getProperty("splus.interactive.commandline", "T"));
        if (!m_isWindowsOS) {
            System.setProperty("splus.help.off", "true");
        }
        ClassUtilities.setClassLoader((ClassLoader)((Object)((Object)SplusEditorPlugin.getDefault())).getClass().getClassLoader());
        this.m_splusSession = new SplusEclipseSessionImpl(stringArray);
        if (splusEclipseSession != null) {
            this.removeSplusWinSessionListener(this);
            splusEclipseSession.writeSplusIn("q()");
        }
        this.m_connectionDescription = this.getConnectionDescription(false, true);
        this.m_isNonExternalConnection = true;
        g_localSameProcessEngineExisted = true;
        this.engageSplusConnection();
        this.addSplusWinSessionListener(this);
        SplusSystem.setEngineQueryHandler((SplusEngineQueryHandler)this);
        this.m_initializeOutputHandler = true;
    }

    public void resetLocalExternalSplusConnection(String string, int n, String string2) throws Exception {
        String string3 = SplusRemoteEclipseSessionImpl.getRmiSessionId();
        String string4 = DefaultConnection.getShome();
        StringBuffer stringBuffer = new StringBuffer();
        String string5 = System.getProperty("java.home", string4 + "/java/jre");
        if (m_isWindowsOS) {
            stringBuffer.append('\"');
            stringBuffer.append(string5);
            stringBuffer.append("/bin/java.exe");
            stringBuffer.append('\"');
            stringBuffer.append(" -Dsplus.shome=\"");
            stringBuffer.append(string4);
            stringBuffer.append("\"");
            stringBuffer.append(" -Dsplus.session.id=");
            stringBuffer.append(string3);
            stringBuffer.append(" -Dsplus.server.rmiport=");
            stringBuffer.append(n);
            stringBuffer.append(" ");
            stringBuffer.append(string2);
            stringBuffer.append(" com.insightful.splus.eclipse.SplusRemoteEclipseSessionImpl");
            stringBuffer.append(" S_PROJ=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        } else {
            stringBuffer.append(string4);
            stringBuffer.append("/cmd/SESSION ");
            stringBuffer.append(string4);
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(InetAddress.getLocalHost().getHostAddress());
            stringBuffer.append(" ");
            stringBuffer.append(SplusRemoteEclipseSessionImpl.getRmiSessionId());
            stringBuffer.append(" ");
            stringBuffer.append(InetAddress.getLocalHost().getHostName());
            stringBuffer.append(" ");
            stringBuffer.append(n);
            stringBuffer.append(" false false -workbench");
            stringBuffer.append(" S_PROJ=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
            stringBuffer.append(" &");
        }
        Runtime.getRuntime().exec(stringBuffer.toString());
        this.resetRemoteExternalSplusConnection(InetAddress.getLocalHost().getHostName(), n);
        this.m_connectionDescription = this.getConnectionDescription(true, true);
    }

    public void resetRemoteExternalSplusConnection(String string, int n) throws Exception {
        SplusEclipseSession splusEclipseSession = this.m_splusSession;
        if (splusEclipseSession != null) {
            this.getOutputHandler().write("\n", false);
        }
        String string2 = SplusRemoteEclipseSessionImpl.getRmiString((String)string, (int)n);
        this.m_splusSession = (SplusEclipseSession)Naming.lookup(string2);
        if (splusEclipseSession != null) {
            this.removeSplusWinSessionListener(this);
            splusEclipseSession.writeSplusIn("q()");
        }
        this.m_connectionDescription = this.getConnectionDescription(true, false);
        this.m_isNonExternalConnection = false;
        this.engageSplusConnection();
        SplusSystem.setEngineQueryHandler((SplusEngineQueryHandler)this);
        this.m_initializeOutputHandler = true;
    }

    protected void engageSplusConnection() {
        this.doWait(50);
        while (true) {
            try {
                this.m_splusSession.evalDataQuery("\n");
            }
            catch (Exception exception) {
                if ("Result info is NULL".equals(exception.getMessage()) || exception instanceof SplusEngineBusyException) {
                    this.doWait(50);
                    continue;
                }
                exception.printStackTrace();
            }
            break;
        }
        boolean bl = this.isNonExternalConnection();
        while (bl && m_isWindowsOS && SplusSystem.getCanvasHandler() == null) {
            this.doWait(50);
        }
        this.m_eclipseGui = new SplusEclipseGui();
        this.doStartupCode();
    }

    protected void createSplusSession() throws Exception {
        SplusEclipseSession splusEclipseSession = this.m_splusSession;
        boolean bl = SplusConnectionPreferencePage.useExternal();
        String string = "";
        boolean bl2 = false;
        if (bl) {
            boolean bl3 = SplusConnectionPreferencePage.useLocal();
            try {
                if (bl3) {
                    this.resetLocalExternalSplusConnection(SplusConnectionPreferencePage.getSproj(), SplusConnectionPreferencePage.getLocalRmiPort(), SplusConnectionPreferencePage.getOptions());
                } else {
                    this.resetRemoteExternalSplusConnection(SplusConnectionPreferencePage.getServer(), SplusConnectionPreferencePage.getRemoteRmiPort());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string = exception.getMessage();
                bl2 = true;
            }
        }
        if (!bl || bl2 && splusEclipseSession == null) {
            if (DefaultConnection.localSameProcessConnectionRestart()) {
                SplusEditorPlugin.getDefault().getWorkbench().restart();
                return;
            }
            this.resetSplusConnection(DefaultConnection.getShome(), SplusConnectionPreferencePage.getSproj());
        }
        if (this.m_splusSession == null) {
            this.m_splusSession = splusEclipseSession;
        }
        if (string.length() != 0) {
            this.m_connectionErrorString = "\nError creating connection: " + string + "\n\n";
        }
    }

    private void doWait(int n) {
        try {
            Thread.sleep(n);
            Thread.yield();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void doStartupCode() {
        boolean bl = SplusPreferencePage.getDoStartupCode();
        if (bl) {
            String string = SplusPreferencePage.getStartupCode();
            while (true) {
                try {
                    String[] stringArray;
                    SplusDataResult splusDataResult = this.m_splusSession.evalDataQuery(string);
                    if (splusDataResult.hasError()) {
                        stringArray = splusDataResult.getError();
                        MessageDialog.openError(null, (String)"Startup Code Error", (String)stringArray);
                    }
                    if (splusDataResult.hasOutput()) {
                        stringArray = splusDataResult.getOutput();
                        MessageDialog.openInformation(null, (String)"Startup Code Output", (String)stringArray);
                    }
                    if (splusDataResult.hasWarning()) {
                        stringArray = splusDataResult.getWarning();
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringBuffer.append(stringArray[i] + "\n");
                        }
                        MessageDialog.openWarning(null, (String)"Startup Code Warnings", (String)stringBuffer.toString());
                    }
                    return;
                }
                catch (SplusEngineBusyException splusEngineBusyException) {
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                break;
            }
        }
    }

    public void sendCmd(String string) {
        this.getOutputHandler().reset();
        this.m_doc.executeSplusCommand(string, this);
    }

    public void openEditor(String string) {
        SplusSystem.getEngineQueryHandler().processDataQuery("Edit(\"" + string + "\")");
    }

    public void flushOutputHandler() {
        this.getOutputHandler().flush();
    }

    /*
     * Loose catch block
     */
    public String isWorkbenchLicensed() {
        while (true) {
            try {
                this.m_splusSession.evalDataQuery("\n");
                return "";
            }
            catch (SplusEngineBusyException splusEngineBusyException) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                continue;
            }
            break;
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public void writeEngineInput(String string) {
        try {
            this.m_splusSession.writeSplusIn(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public SplusDataResult doDataQuery(String string) throws SplusIncompleteExpressionException, SplusEngineBusyException, RemoteException {
        SplusDataResult splusDataResult = this.m_splusSession.evalDataQuery(string);
        return splusDataResult;
    }

    public SplusDataResult doDataQueryWithOutput(String string) throws SplusIncompleteExpressionException, SplusEngineBusyException, RemoteException {
        SplusDataResult splusDataResult = this.m_splusSession.evalDataQuery(string, true, true, true, true, false);
        return splusDataResult;
    }

    public SplusDataResult doDataQuery(String string, int n) throws SplusIncompleteExpressionException, SplusEngineBusyException, RemoteException {
        SplusDataResult splusDataResult = this.m_splusSession.evalDataQuery(string, n);
        return splusDataResult;
    }

    public SplusDataResult processDataQuery(String string) {
        try {
            SplusDataResult splusDataResult = this.doDataQuery(string);
            return splusDataResult;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        catch (SplusIncompleteExpressionException splusIncompleteExpressionException) {
            splusIncompleteExpressionException.printStackTrace();
        }
        catch (SplusEngineBusyException splusEngineBusyException) {
            splusEngineBusyException.printStackTrace();
        }
        return null;
    }

    public SplusDataResult processDataQuery(String string, int n) {
        try {
            SplusDataResult splusDataResult = this.doDataQuery(string, n);
            return splusDataResult;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        catch (SplusIncompleteExpressionException splusIncompleteExpressionException) {
            splusIncompleteExpressionException.printStackTrace();
        }
        catch (SplusEngineBusyException splusEngineBusyException) {
            splusEngineBusyException.printStackTrace();
        }
        return null;
    }

    public void processDialogCommand(String string) {
        try {
            this.m_splusSession.writeSplusIn(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void writeEngineOutput(String string, boolean bl) {
        this.getOutputHandler().write(string, bl);
        this.m_doc.pollForOutput();
    }

    public boolean processDataQuery(String string, IWorkbenchPartSite iWorkbenchPartSite, IAction iAction) {
        boolean bl;
        SplusDataResult splusDataResult = this.processDataQuery(string);
        boolean bl2 = bl = !this.handledError(splusDataResult, iWorkbenchPartSite);
        if (bl && iAction != null) {
            iAction.run();
        }
        return bl;
    }

    private boolean handledError(SplusDataResult splusDataResult, IWorkbenchPartSite iWorkbenchPartSite) {
        return DefaultConnection.handledError(iWorkbenchPartSite.getShell(), splusDataResult);
    }

    public static boolean handledError(Shell shell, SplusDataResult splusDataResult) {
        if (splusDataResult == null) {
            return true;
        }
        String string = splusDataResult.getError();
        if (string != null) {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)string);
            return true;
        }
        return false;
    }

    public String[] processDataQueryAsStrings(String string, int n) {
        SplusDataResult splusDataResult = this.processDataQuery(string, n);
        if (splusDataResult != null) {
            try {
                return splusDataResult.getStringData();
            }
            catch (SplusBadDataException splusBadDataException) {
                // empty catch block
            }
        }
        return new String[0];
    }

    public boolean escapeRequested() {
        return this.m_escape;
    }

    public boolean hasEscaped() {
        return this.m_escaped;
    }

    public void setEscaped() {
        this.m_escape = true;
    }

    public void sendEscape() {
        try {
            this.m_splusSession.Interrupt();
            this.m_escaped = true;
            this.m_escape = false;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public boolean isEngineBusy() {
        return this.wantsInput() || this.hasEvalBegan() && !this.hasEvalEnded();
    }

    public boolean noEval() {
        return this.m_noEval;
    }

    public boolean hasEvalBegan() {
        return this.m_beginEval;
    }

    public boolean hasEvalEnded() {
        return this.m_endEval;
    }

    public boolean wantsInput() {
        return this.m_wantInput;
    }

    public boolean doQuit() {
        return this.m_doQuit;
    }

    public static void staticEventOccurred(SplusWinSessionEvent splusWinSessionEvent) {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection) {
            ((DefaultConnection)noConnection).eventOccurred(splusWinSessionEvent);
            for (SplusWinSessionListener splusWinSessionListener : m_sessionListeners.keySet()) {
                try {
                    splusWinSessionListener.eventOccurred(splusWinSessionEvent);
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        }
    }

    public void addSplusWinSessionListener(SplusWinSessionListener splusWinSessionListener) {
        try {
            if (!this.m_splusSession.isRemote()) {
                this.m_splusSession.addListener(splusWinSessionListener);
            } else if (m_sessionListeners.get(splusWinSessionListener) == null) {
                m_sessionListeners.put(splusWinSessionListener, splusWinSessionListener);
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void removeSplusWinSessionListener(SplusWinSessionListener splusWinSessionListener) {
        try {
            if (!this.m_splusSession.isRemote()) {
                this.m_splusSession.removeListener(splusWinSessionListener);
            } else {
                m_sessionListeners.remove(splusWinSessionListener);
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void eventOccurred(SplusWinSessionEvent splusWinSessionEvent) {
        int n = splusWinSessionEvent == null ? -1 : splusWinSessionEvent.getType();
        switch (n) {
            case 31: {
                break;
            }
            case 32: {
                this.m_doQuit = true;
                break;
            }
            case 1: {
                this.m_beginEval = true;
                break;
            }
            case 2: {
                this.m_endEval = true;
                this.m_escape = false;
                this.m_escaped = false;
                break;
            }
            case 10: {
                this.m_sendOutput = true;
                break;
            }
            case 21: {
                this.m_wantInput = true;
                break;
            }
            case 22: {
                this.m_gotInput = true;
                break;
            }
            case 999: 
            case 1000: 
            case 1001: 
            case 1003: {
                this.m_noEval = true;
                break;
            }
            case -1: {
                this.m_beginEval = false;
                this.m_endEval = false;
                this.m_noEval = false;
                this.m_sendOutput = false;
                this.m_wantInput = false;
                this.m_doQuit = false;
                this.m_escape = false;
                this.m_escaped = false;
                break;
            }
        }
        boolean bl = !this.m_noEval && this.m_beginEval && !this.m_endEval;
        SplusEditorPlugin.getDefault().setSplusBusy(bl);
    }

    public boolean hasCanvas() {
        return this.m_hasCanvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCanvas(SCanvas sCanvas) {
        Object object = this.m_syncObject;
        synchronized (object) {
            this.m_storedCanvas.add(sCanvas);
            this.m_hasCanvas = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SCanvas[] getCanvas() {
        Object object = this.m_syncObject;
        synchronized (object) {
            SCanvas[] sCanvasArray = new SCanvas[this.m_storedCanvas.size()];
            this.m_storedCanvas.toArray(sCanvasArray);
            this.m_storedCanvas.removeAllElements();
            this.m_hasCanvas = false;
            return sCanvasArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCanvas() {
        Object object = this.m_syncObject;
        synchronized (object) {
            SCanvas[] sCanvasArray = this.getCanvas();
            for (int i = 0; i < sCanvasArray.length; ++i) {
                this.m_eclipseGui.displaySWTCanvas(sCanvasArray[i]);
            }
        }
    }

    public String escapeSpecialCharacters(String string) {
        return StringUtilities.escapeSpecialCharacters((String)string);
    }

    public void displayHelpView(String string) {
        this.processDataQuery("help.start(view=\"" + string + "\")");
    }

    public void displayHelpOnTopic(String string) {
        try {
            this.processDataQuery("help.start()");
            String string2 = "displayJhelp(\"" + string + "\")";
            this.processDataQuery(string2);
        }
        catch (Exception exception) {
            System.err.println("Could not enable HelpSet for " + string);
        }
    }

    public SplusHelpManagerInstance getHelpManagerInstance() {
        return null;
    }

    public String parseSplusString(String string) {
        try {
            switch (this.m_splusSession.parseSplusString(string)) {
                case 1003: {
                    return INCOMPLETE_EXPRESSION;
                }
                case 1004: {
                    return INCOMPLETE_STRING;
                }
                case 999: 
                case 1001: {
                    return FAILED_EXPRESSION;
                }
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return COMPLETE_EXPRESSION;
    }

    public String getHoverText(String string) {
        if (!this.isEngineBusy()) {
            try {
                this.eventOccurred(null);
                String string2 = "eclipse.internal.get.hover(\"" + string + "\")";
                SplusDataResult splusDataResult = this.m_splusSession.evalDataQuery(string2, true, true, false, false, false);
                return splusDataResult.getStringData()[0];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getHoverText(string);
    }

    public void copyFile(String string, String string2) throws RemoteException, FileNotFoundException, IOException {
        RemoteFileInputStream remoteFileInputStream = new RemoteFileInputStream(string, (SplusSession)this.m_splusSession);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        FileUtilities.transferBytes((FileInputStream)remoteFileInputStream, (FileOutputStream)fileOutputStream);
        remoteFileInputStream.close();
        fileOutputStream.flush();
        fileOutputStream.close();
    }
}

