/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context;

import com.insightful.splus.eclipse.editors.spluseditor.util.IColorManager;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusColorProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractSplusScanner
extends BufferedRuleBasedScanner {
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private Map fTokenMap = new HashMap();
    private String[] fPropertyNamesColor;
    private String[] fPropertyNamesBold;
    private String[] fPropertyNamesItalic;
    private boolean fNeedsLazyColorLoading;

    protected abstract String[] getTokenProperties();

    protected abstract List createRules();

    public AbstractSplusScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore) {
        this.fColorManager = iColorManager;
        this.fPreferenceStore = iPreferenceStore;
    }

    public final void initialize() {
        this.fPropertyNamesColor = this.getTokenProperties();
        int n = this.fPropertyNamesColor.length;
        this.fPropertyNamesBold = new String[n];
        this.fPropertyNamesItalic = new String[n];
        this.fNeedsLazyColorLoading = Display.getCurrent() == null;
        for (int i = 0; i < n; ++i) {
            this.fPropertyNamesBold[i] = this.fPropertyNamesColor[i] + "_bold";
            this.fPropertyNamesItalic[i] = this.fPropertyNamesColor[i] + "_italic";
            if (this.fNeedsLazyColorLoading) {
                this.addTokenWithProxyAttribute(this.fPropertyNamesColor[i], this.fPropertyNamesBold[i], this.fPropertyNamesItalic[i]);
                continue;
            }
            this.addToken(this.fPropertyNamesColor[i], this.fPropertyNamesBold[i], this.fPropertyNamesItalic[i]);
        }
        this.initializeRules();
    }

    public IToken nextToken() {
        if (this.fNeedsLazyColorLoading) {
            this.resolveProxyAttributes();
        }
        return super.nextToken();
    }

    private void resolveProxyAttributes() {
        if (this.fNeedsLazyColorLoading && Display.getCurrent() != null) {
            for (int i = 0; i < this.fPropertyNamesColor.length; ++i) {
                this.addToken(this.fPropertyNamesColor[i], this.fPropertyNamesBold[i], this.fPropertyNamesItalic[i]);
            }
            this.fNeedsLazyColorLoading = true;
        }
    }

    private void addTokenWithProxyAttribute(String string, String string2, String string3) {
        this.fTokenMap.put(string, new Token((Object)this.createTextAttribute(null, string2, string3)));
    }

    private void addToken(String string, String string2, String string3) {
        if (!this.fNeedsLazyColorLoading) {
            this.fTokenMap.put(string, new Token((Object)this.createTextAttribute(string, string2, string3)));
        } else {
            Token token = (Token)this.fTokenMap.get(string);
            if (token != null) {
                token.setData((Object)this.createTextAttribute(string, string2, string3));
            }
        }
    }

    private TextAttribute createTextAttribute(String string, String string2, String string3) {
        int n;
        Color color = null;
        if (string != null) {
            color = this.fColorManager.getColor(string);
        }
        int n2 = n = this.fPreferenceStore.getBoolean(string2) ? 1 : 0;
        if (this.fPreferenceStore.getBoolean(string3)) {
            n |= 2;
        }
        return new TextAttribute(color, null, n);
    }

    protected Token getToken(String string) {
        if (this.fNeedsLazyColorLoading) {
            this.resolveProxyAttributes();
        }
        return (Token)this.fTokenMap.get(string);
    }

    private void initializeRules() {
        List list = this.createRules();
        if (list != null) {
            IRule[] iRuleArray = new IRule[list.size()];
            list.toArray(iRuleArray);
            this.setRules(iRuleArray);
        }
    }

    private int indexOf(String string) {
        if (string != null) {
            int n = this.fPropertyNamesColor.length;
            for (int i = 0; i < n; ++i) {
                if (!string.equals(this.fPropertyNamesColor[i]) && !string.equals(this.fPropertyNamesBold[i]) && !string.equals(this.fPropertyNamesItalic[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean affectsBehavior(PropertyChangeEvent propertyChangeEvent) {
        return this.indexOf(propertyChangeEvent.getProperty()) >= 0;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        int n = this.indexOf(string);
        Token token = this.getToken(this.fPropertyNamesColor[n]);
        if (this.fPropertyNamesColor[n].equals(string)) {
            this.adaptToColorChange(token, propertyChangeEvent);
        } else if (this.fPropertyNamesBold[n].equals(string)) {
            this.adaptToStyleChange(token, propertyChangeEvent, 1);
        } else if (this.fPropertyNamesItalic[n].equals(string)) {
            this.adaptToStyleChange(token, propertyChangeEvent, 2);
        }
    }

    private void adaptToColorChange(Token token, PropertyChangeEvent propertyChangeEvent) {
        RGB rGB = null;
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof RGB) {
            rGB = (RGB)object;
        } else if (object instanceof String) {
            rGB = StringConverter.asRGB((String)((String)object));
        }
        if (rGB != null) {
            Object object2;
            String string = propertyChangeEvent.getProperty();
            if (this.fColorManager instanceof SplusColorProvider) {
                object2 = (SplusColorProvider)this.fColorManager;
                ((SplusColorProvider)object2).unbindColor(string);
                ((SplusColorProvider)object2).bindColor(string, rGB);
            }
            if ((object2 = token.getData()) instanceof TextAttribute) {
                TextAttribute textAttribute = (TextAttribute)object2;
                token.setData((Object)new TextAttribute(this.fColorManager.getColor(string), textAttribute.getBackground(), textAttribute.getStyle()));
            }
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent propertyChangeEvent, int n) {
        boolean bl = false;
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        } else if ("true".equals(object)) {
            bl = true;
        }
        Object object2 = token.getData();
        if (object2 instanceof TextAttribute) {
            boolean bl2;
            TextAttribute textAttribute = (TextAttribute)object2;
            boolean bl3 = bl2 = (textAttribute.getStyle() & n) == n;
            if (bl2 != bl) {
                token.setData((Object)new TextAttribute(textAttribute.getForeground(), textAttribute.getBackground(), bl ? textAttribute.getStyle() | n : textAttribute.getStyle() & ~n));
            }
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }
}

