/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context;

import com.insightful.splus.eclipse.editors.spluseditor.SplusEditor;
import com.insightful.splus.eclipse.editors.spluseditor.context.AbstractSplusScanner;
import com.insightful.splus.eclipse.editors.spluseditor.context.CombinedWordRule;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusWordDetector;
import com.insightful.splus.eclipse.editors.spluseditor.util.IColorManager;
import com.insightful.splus.eclipse.preferences.SplusTaskPreferencePage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;

public class SplusCommentScanner
extends AbstractSplusScanner {
    private static final String COMPILER_TASK_TAGS = "tasks";
    protected static final String TASK_TAG = "splus_comment_task_tag";
    private static final String COMPILER_TASK_CASE_SENSITIVE = "enabled";
    private static final String ENABLED = "enabled";
    private TaskTagMatcher fTaskTagMatcher;
    private String fDefaultTokenProperty;
    private String[] fTokenProperties;

    public SplusCommentScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore, Preferences preferences, SplusEditor splusEditor, String string) {
        this(iColorManager, iPreferenceStore, preferences, splusEditor, string, new String[]{string, TASK_TAG});
    }

    public SplusCommentScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore, Preferences preferences, SplusEditor splusEditor, String string, String[] stringArray) {
        super(iColorManager, iPreferenceStore);
        this.fDefaultTokenProperty = string;
        this.fTokenProperties = stringArray;
        this.initialize();
    }

    public SplusCommentScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore, SplusEditor splusEditor, String string) {
        this(iColorManager, iPreferenceStore, null, splusEditor, string, new String[]{string, TASK_TAG});
    }

    public SplusCommentScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore, SplusEditor splusEditor, String string, String[] stringArray) {
        this(iColorManager, iPreferenceStore, null, splusEditor, string, stringArray);
    }

    protected List createRules() {
        ArrayList<CombinedWordRule> arrayList = new ArrayList<CombinedWordRule>();
        Token token = this.getToken(this.fDefaultTokenProperty);
        List list = this.createMatchers();
        if (list.size() > 0) {
            CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)new SplusWordDetector(), (IToken)token);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                combinedWordRule.addWordMatcher((CombinedWordRule.WordMatcher)list.get(i));
            }
            arrayList.add(combinedWordRule);
        }
        this.setDefaultReturnToken((IToken)token);
        return arrayList;
    }

    protected List createMatchers() {
        ArrayList<TaskTagMatcher> arrayList = new ArrayList<TaskTagMatcher>();
        String[][] stringArray = SplusTaskPreferencePage.getTasks();
        String[] stringArray2 = stringArray[0];
        boolean bl = "enabled".equals(this.getPreferenceStore().getString("enabled"));
        if (stringArray2 != null) {
            Token token = this.getToken(TASK_TAG);
            this.fTaskTagMatcher = new TaskTagMatcher((IToken)token);
            for (int i = 0; i < stringArray2.length; ++i) {
                this.fTaskTagMatcher.addWord(stringArray2[i], (IToken)token);
            }
            this.fTaskTagMatcher.setCaseSensitive(bl);
            arrayList.add(this.fTaskTagMatcher);
        }
        return arrayList;
    }

    public boolean affectsBehavior(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getProperty().equals(COMPILER_TASK_TAGS) || propertyChangeEvent.getProperty().equals("enabled") || super.affectsBehavior(propertyChangeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fTaskTagMatcher != null && propertyChangeEvent.getProperty().equals(COMPILER_TASK_TAGS)) {
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof String) {
                TaskTagMatcher taskTagMatcher = this.fTaskTagMatcher;
                synchronized (taskTagMatcher) {
                    this.fTaskTagMatcher.clearWords();
                    String[] stringArray = SplusTaskPreferencePage.getTasks()[0];
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.fTaskTagMatcher.addWord(stringArray[i], this.fTaskTagMatcher.fToken);
                    }
                }
            }
        } else if (this.fTaskTagMatcher != null && propertyChangeEvent.getProperty().equals("enabled")) {
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof String) {
                this.fTaskTagMatcher.setCaseSensitive("enabled".equals(object));
            }
        } else if (super.affectsBehavior(propertyChangeEvent)) {
            super.adaptToPreferenceChange(propertyChangeEvent);
        }
    }

    protected String[] getTokenProperties() {
        return this.fTokenProperties;
    }

    private class TaskTagMatcher
    extends CombinedWordRule.WordMatcher {
        private IToken fToken;
        private Map fUppercaseWords = new HashMap();
        private boolean fCaseSensitive = true;
        private CombinedWordRule.CharacterBuffer fBuffer = new CombinedWordRule.CharacterBuffer(16);

        public TaskTagMatcher(IToken iToken) {
            this.fToken = iToken;
        }

        public synchronized void clearWords() {
            super.clearWords();
            this.fUppercaseWords.clear();
        }

        public synchronized void addTaskTags(String string) {
            String[] stringArray = this.split(string, ",");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() <= 0) continue;
                this.addWord(stringArray[i], this.fToken);
            }
        }

        private String[] split(String string, String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2++] = stringTokenizer.nextToken();
            }
            return stringArray;
        }

        public synchronized void addWord(String string, IToken iToken) {
            Assert.isNotNull((Object)string);
            Assert.isNotNull((Object)iToken);
            super.addWord(string, iToken);
            this.fUppercaseWords.put(new CombinedWordRule.CharacterBuffer(string.toUpperCase()), iToken);
        }

        public synchronized IToken evaluate(ICharacterScanner iCharacterScanner, CombinedWordRule.CharacterBuffer characterBuffer) {
            IToken iToken = null;
            if (this.fCaseSensitive) {
                iToken = super.evaluate(iCharacterScanner, characterBuffer);
            } else {
                this.fBuffer.clear();
                int n = characterBuffer.length();
                for (int i = 0; i < n; ++i) {
                    this.fBuffer.append(Character.toUpperCase(characterBuffer.charAt(i)));
                }
                iToken = (IToken)this.fUppercaseWords.get(this.fBuffer);
            }
            if (iToken != null) {
                return iToken;
            }
            return Token.UNDEFINED;
        }

        public boolean isCaseSensitive() {
            return this.fCaseSensitive;
        }

        public void setCaseSensitive(boolean bl) {
            this.fCaseSensitive = bl;
        }
    }
}

