/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.cnkjava;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class CNKBlobClassHandler {
    private String m_className = null;
    private static ClassLoader m_classLoader = null;
    private static Hashtable m_classNameToHandler = new Hashtable();
    private static CNKBlobClassHandler m_nullClassHandler = new CNKBlobClassHandler(null);

    public CNKBlobClassHandler(String className) {
        this.m_className = className;
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getDisplayClassName() {
        return this.m_className == null ? "blob" : this.m_className;
    }

    public static void setClassLoader(ClassLoader ldr) {
        m_classLoader = ldr;
    }

    public static ClassLoader getClassLoader() {
        return m_classLoader;
    }

    public static Class getClassForName(String name) throws ClassNotFoundException {
        try {
            if (m_classLoader == null) {
                return Class.forName(name);
            }
            return Class.forName(name, true, m_classLoader);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static CNKBlobClassHandler getClassHandler(String className) {
        if (className == null) {
            return m_nullClassHandler;
        }
        CNKBlobClassHandler handler = (CNKBlobClassHandler)m_classNameToHandler.get(className);
        if (handler == null) {
            try {
                Class cl = CNKBlobClassHandler.getClassForName(className);
                if (cl != null) {
                    Method mt = cl.getMethod("getBlobClassHandler", String.class);
                    if (!Modifier.isStatic(mt.getModifiers())) {
                        throw new Exception(className + ".getBlobClassHandler(String) exists, but is not static");
                    }
                    Object obj = mt.invoke(null, className);
                    if (obj == null || !(obj instanceof CNKBlobClassHandler)) {
                        throw new Exception(className + ".getBlobClassHandler(String) didn't return CNKBlobClassHandler");
                    }
                    handler = (CNKBlobClassHandler)obj;
                }
            }
            catch (NoSuchMethodException ex) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (handler == null) {
                handler = new CNKBlobClassHandler(className);
            }
            m_classNameToHandler.put(className, handler);
        }
        return handler;
    }

    public static String getDisplayClassName(String blobClassName) {
        CNKBlobClassHandler handler = CNKBlobClassHandler.getClassHandler(blobClassName);
        String displayClassName = handler.getDisplayClassName();
        return displayClassName;
    }

    public void writeBlobObject(OutputStream out, Object obj) throws IOException {
        ObjectOutputStream objOut = new ObjectOutputStream(out);
        objOut.writeObject(obj);
        out.close();
    }

    public Object readBlobObject(InputStream in) throws IOException, ClassNotFoundException {
        ClassLoaderObjectInputStream objIn = new ClassLoaderObjectInputStream(in);
        Object obj = objIn.readObject();
        return obj;
    }

    public static void writeBlobObject(String blobClassName, OutputStream out, Object obj) throws IOException {
        CNKBlobClassHandler classHandler = CNKBlobClassHandler.getClassHandler(blobClassName);
        classHandler.writeBlobObject(out, obj);
    }

    public static Object readBlobObject(String blobClassName, InputStream in) throws IOException, ClassNotFoundException {
        CNKBlobClassHandler classHandler = CNKBlobClassHandler.getClassHandler(blobClassName);
        return classHandler.readBlobObject(in);
    }

    public static class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        private ClassLoader m_classLoader = CNKBlobClassHandler.getClassLoader();

        public ClassLoaderObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return Class.forName(desc.getName(), true, this.m_classLoader);
        }
    }
}

