/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Vector;

public class ByColumnStatisticAccumulator {
    private ByColumnStats[] m_byColumnStats = null;
    private int[] m_interestColumns = null;
    private int[] m_byColumnTotals = null;
    private int[] m_byColumns = null;
    private XTMetaData m_metaData;
    private int m_quantileKValue;
    private int m_numQuantiles;
    private int m_numberBins = 10;
    private long m_totalRowCount;
    private boolean m_binDetailDesired = false;
    public static String QUANTILE_COUNT_ATTRIBUTE_TAG = "QuantileCount";
    public static String K_VALUE_ATTRIBUTE_TAG = "KValue";
    public static String MINIMUM_ATTRIBUTE_TAG = "Minimum";
    public static String MAXIMUM_ATTRIBUTE_TAG = "Maximum";
    public static String MEAN_ATTRIBUTE_TAG = "Mean";
    public static String STANDARD_DEVIATION_ATTRIBUTE_TAG = "StandardDeviation";
    public static String QUANTILES_ATTRIBUTE_TAG = "Quantiles";
    public static String BINS_ATTRIBUTE_TAG = "Bins";
    public static String STATS_ATTRIBUTE_TAG = "Stats";
    public static String LOW_VALUE_ATTRIBUTE_TAG = "LowValue";
    public static String HIGH_VALUE_ATTRIBUTE_TAG = "HighValue";
    public static String COUNT_ATTRIBUTE_TAG = "Count";
    public static String NAN_ATTRIBUTE_TAG = "NaN";

    public ByColumnStatisticAccumulator(Vector byVec, Vector displayVec, int numQuantiles, int kValue, XTMetaData metaData) throws Exception {
        int i;
        this.m_metaData = metaData;
        this.m_totalRowCount = metaData.getNumRows();
        int size = byVec.size();
        this.m_byColumns = new int[size];
        for (i = 0; i < size; ++i) {
            this.m_byColumns[i] = this.m_metaData.nameToOrdinal((String)byVec.get(i));
            if (this.m_metaData.getColumnType(this.m_byColumns[i]).equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) continue;
            throw new Exception("Columns selected for By Column calculations must be Categorical.");
        }
        this.m_interestColumns = new int[displayVec.size()];
        for (i = 0; i < displayVec.size(); ++i) {
            this.m_interestColumns[i] = this.m_metaData.nameToOrdinal((String)displayVec.get(i));
        }
        if (this.m_interestColumns.length == 0) {
            throw new Exception("There must be at least one column to calculate statistics for.");
        }
        this.m_numQuantiles = numQuantiles;
        this.m_quantileKValue = kValue;
        int statsCount = 1;
        this.m_byColumnTotals = new int[this.m_byColumns.length];
        for (int i2 = 0; i2 < this.m_byColumns.length; ++i2) {
            this.m_byColumnTotals[i2] = this.m_metaData.getCategoricalDataFieldLevels(this.m_metaData.ordinalToName(this.m_byColumns[i2])).size() + 1;
            statsCount *= this.m_byColumnTotals[i2];
        }
        this.m_byColumnStats = new ByColumnStats[statsCount * this.m_interestColumns.length];
    }

    public void calculateBinDetails() {
        this.m_binDetailDesired = true;
    }

    public void calculateOnlyBinCounts() {
        this.m_binDetailDesired = false;
    }

    public void updateStatistics(double[][] actualByColumns, double[][] actualInterestColumns, int inputRows) {
        int[] byPath = new int[this.m_byColumns.length];
        for (int i = 0; i < inputRows; ++i) {
            for (int j = 0; j < this.m_interestColumns.length; ++j) {
                for (int k = 0; k < byPath.length; ++k) {
                    byPath[k] = Double.isNaN(actualByColumns[k][i]) ? this.m_byColumnTotals[k] - 1 : (int)actualByColumns[k][i];
                }
                int arrayPos = this.findByColumnStatsPosition(byPath, j, this.m_interestColumns.length);
                if (this.m_byColumnStats[arrayPos] == null) {
                    String type = this.m_metaData.getColumnType(this.m_interestColumns[j]);
                    if (type.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                        int numLevels = this.m_metaData.getCategoricalDataFieldLevels(this.m_metaData.ordinalToName(this.m_interestColumns[j])).size();
                        this.m_byColumnStats[arrayPos] = new ByCategoricalColumnStats(numLevels);
                    } else {
                        double max = this.m_metaData.getColumnMax(this.m_interestColumns[j]);
                        double min = this.m_metaData.getColumnMin(this.m_interestColumns[j]);
                        this.m_byColumnStats[arrayPos] = this.m_binDetailDesired ? new ByContinuousColumnStatsPerBin(this.m_numberBins, min, max, this.m_totalRowCount, this.m_numQuantiles, this.m_quantileKValue) : new ByContinuousColumnStats(this.m_numberBins, min, max, this.m_totalRowCount, this.m_numQuantiles, this.m_quantileKValue);
                    }
                }
                this.m_byColumnStats[arrayPos].updateColumnStats(actualInterestColumns[j][i]);
            }
        }
    }

    public void updateStatisticsSecondPass(double[][] actualByColumns, double[][] actualInterestColumns, int inputRows) {
        int[] byPath = new int[this.m_byColumns.length];
        for (int i = 0; i < inputRows; ++i) {
            for (int j = 0; j < this.m_interestColumns.length; ++j) {
                for (int k = 0; k < byPath.length; ++k) {
                    byPath[k] = Double.isNaN(actualByColumns[k][i]) ? this.m_byColumnTotals[k] - 1 : (int)actualByColumns[k][i];
                }
                int arrayPos = this.findByColumnStatsPosition(byPath, j, this.m_interestColumns.length);
                if (!(this.m_byColumnStats[arrayPos] instanceof ByContinuousColumnStats)) continue;
                ((ByContinuousColumnStats)this.m_byColumnStats[arrayPos]).initQuantileStatistics();
                ((ByContinuousColumnStats)this.m_byColumnStats[arrayPos]).updateQuantileSecondPass(actualInterestColumns[j][i]);
                if (!(this.m_byColumnStats[arrayPos] instanceof ByContinuousColumnStatsPerBin)) continue;
                ((ByContinuousColumnStatsPerBin)this.m_byColumnStats[arrayPos]).initQuantileStatisticsPerBin();
                ((ByContinuousColumnStatsPerBin)this.m_byColumnStats[arrayPos]).updateQuantilePerBinSecondPass(actualInterestColumns[j][i]);
            }
        }
    }

    public void setBinCount(int num) {
        this.m_numberBins = num;
    }

    public int getBinCount() {
        return this.m_numberBins;
    }

    public XTProps outputColumnStats() throws Exception {
        XTProps props = new XTProps();
        int numByColumns = this.m_byColumns.length;
        int pathLengthFactor = numByColumns * 2;
        String[] statsPath = new String[3 + pathLengthFactor];
        String[] quantilesPath = new String[4 + pathLengthFactor];
        String[] binsPath = new String[5 + pathLengthFactor];
        for (int i = 0; i < this.m_byColumnStats.length; ++i) {
            String columnName;
            if (this.m_byColumnStats[i] == null) continue;
            ByColumnStats bCS = this.m_byColumnStats[i];
            int pathIndex = 0;
            int columnNum = this.m_interestColumns[i % this.m_interestColumns.length];
            statsPath[pathIndex] = columnName = this.m_metaData.ordinalToName(columnNum);
            quantilesPath[pathIndex] = columnName;
            binsPath[pathIndex++] = columnName;
            String[] path = this.getPathFromAddress(i);
            for (int j = 0; j < path.length; ++j) {
                String byColName;
                statsPath[pathIndex] = byColName = this.m_metaData.ordinalToName(this.m_byColumns[j]);
                quantilesPath[pathIndex] = byColName;
                binsPath[pathIndex++] = byColName;
                if (path[j] == null) {
                    statsPath[pathIndex] = NAN_ATTRIBUTE_TAG;
                    quantilesPath[pathIndex] = NAN_ATTRIBUTE_TAG;
                    binsPath[pathIndex++] = NAN_ATTRIBUTE_TAG;
                    continue;
                }
                statsPath[pathIndex] = path[j];
                quantilesPath[pathIndex] = path[j];
                binsPath[pathIndex++] = path[j];
            }
            statsPath[pathIndex] = STATS_ATTRIBUTE_TAG;
            quantilesPath[pathIndex] = STATS_ATTRIBUTE_TAG;
            binsPath[pathIndex++] = STATS_ATTRIBUTE_TAG;
            quantilesPath[pathIndex] = QUANTILES_ATTRIBUTE_TAG;
            binsPath[pathIndex] = BINS_ATTRIBUTE_TAG;
            statsPath[pathIndex] = MINIMUM_ATTRIBUTE_TAG;
            props.set(statsPath, Double.toString(bCS.getMin()));
            statsPath[pathIndex] = MAXIMUM_ATTRIBUTE_TAG;
            props.set(statsPath, Double.toString(bCS.getMax()));
            statsPath[pathIndex] = MEAN_ATTRIBUTE_TAG;
            props.set(statsPath, Double.toString(bCS.getMean()));
            statsPath[pathIndex] = STANDARD_DEVIATION_ATTRIBUTE_TAG;
            props.set(statsPath, Double.toString(bCS.getStandardDeviation()));
            if (bCS instanceof ByContinuousColumnStats) {
                ByContinuousColumnStats stats = (ByContinuousColumnStats)bCS;
                for (int k = 0; k < stats.getNumQuantileBounds(); ++k) {
                    quantilesPath[pathIndex + 1] = Integer.toString(k);
                    props.set(quantilesPath, Double.toString(stats.getQuantileBound(k)));
                }
            }
            int numBins = bCS.getNumBins() - 1;
            for (int j = 0; j < numBins; ++j) {
                int k;
                String binNum;
                double tempCount = bCS.getBinCount(j);
                if (tempCount == 0.0) continue;
                binsPath[pathIndex + 1] = binNum = Integer.toString(j);
                if (bCS instanceof ByContinuousColumnStats) {
                    ByContinuousColumnStats stats = (ByContinuousColumnStats)bCS;
                    binsPath[pathIndex + 2] = LOW_VALUE_ATTRIBUTE_TAG;
                    if (j == 0) {
                        props.set(binsPath, Double.toString(stats.getColumnMin()));
                    } else {
                        props.set(binsPath, Double.toString(stats.getRangeMax(j - 1)));
                    }
                    binsPath[pathIndex + 2] = HIGH_VALUE_ATTRIBUTE_TAG;
                    props.set(binsPath, Double.toString(stats.getRangeMax(j)));
                }
                binsPath[pathIndex + 2] = COUNT_ATTRIBUTE_TAG;
                props.set(binsPath, Double.toString(tempCount));
                if (!(bCS instanceof ByContinuousColumnStatsPerBin)) continue;
                ByContinuousColumnStatsPerBin statsPerQuantile = (ByContinuousColumnStatsPerBin)bCS;
                binsPath[pathIndex + 2] = MINIMUM_ATTRIBUTE_TAG;
                props.set(binsPath, Double.toString(statsPerQuantile.getMin(j)));
                binsPath[pathIndex + 2] = MAXIMUM_ATTRIBUTE_TAG;
                props.set(binsPath, Double.toString(statsPerQuantile.getMax(j)));
                binsPath[pathIndex + 2] = MEAN_ATTRIBUTE_TAG;
                props.set(binsPath, Double.toString(statsPerQuantile.getMean(j)));
                binsPath[pathIndex + 2] = STANDARD_DEVIATION_ATTRIBUTE_TAG;
                props.set(binsPath, Double.toString(statsPerQuantile.getStandardDeviation(j)));
                String[] binQuantilePath = new String[binsPath.length + 1];
                for (k = 0; k < binsPath.length; ++k) {
                    binQuantilePath[k] = binsPath[k];
                }
                for (k = 0; k < statsPerQuantile.getNumQuantileBounds(); ++k) {
                    binQuantilePath[binQuantilePath.length - 2] = QUANTILES_ATTRIBUTE_TAG;
                    binQuantilePath[binQuantilePath.length - 1] = Integer.toString(k);
                    props.set(binQuantilePath, Double.toString(statsPerQuantile.getQuantileBound(j, k)));
                }
            }
            double tempCount = bCS.getBinCount(numBins);
            if (tempCount == 0.0) continue;
            binsPath[pathIndex + 1] = NAN_ATTRIBUTE_TAG;
            binsPath[pathIndex + 2] = COUNT_ATTRIBUTE_TAG;
            props.set(binsPath, Double.toString(tempCount));
        }
        return props;
    }

    private String[] getPathFromAddress(int arrayIndex) {
        String[] ret = new String[this.m_byColumns.length];
        int divFactor = this.m_interestColumns.length;
        for (int i = this.m_byColumns.length - 1; i >= 0; --i) {
            int levelNum = arrayIndex / divFactor % this.m_byColumnTotals[i];
            ret[i] = this.m_metaData.getCategoricalDataFieldLevel(this.m_byColumns[i], levelNum);
            divFactor *= this.m_byColumnTotals[i];
        }
        return ret;
    }

    private int findByColumnStatsPosition(int[] levels, int column, int totalColumns) {
        int ret = 0;
        int factor = 1;
        for (int i = levels.length - 1; i >= 0; --i) {
            ret += levels[i] * factor;
            factor *= this.m_byColumnTotals[i];
        }
        return ret * totalColumns + column;
    }

    public static class UpperBoundOnePassQuantile
    extends OnePassQuantile {
        public UpperBoundOnePassQuantile(int maxK, long tau) {
            super(maxK, tau);
        }

        protected boolean compare(double a, double b) {
            return a < b;
        }
    }

    public static class LowerBoundOnePassQuantile
    extends OnePassQuantile {
        public LowerBoundOnePassQuantile(int maxK, long tau) {
            super(maxK, tau);
        }

        protected boolean compare(double a, double b) {
            return a > b;
        }
    }

    public static abstract class OnePassQuantile {
        protected double[] m_values = null;
        protected long[] m_counts = null;
        protected long m_tau;
        protected int m_kMax;
        protected int m_k;

        public OnePassQuantile(int maxK, long tau) {
            this.m_values = new double[maxK];
            this.m_counts = new long[maxK];
            this.m_kMax = maxK;
            this.m_tau = tau;
            this.m_k = 0;
        }

        public void updateQuantile(double newNum) {
            int sumPostOne;
            int i;
            if (Double.isNaN(newNum)) {
                return;
            }
            boolean notDone = true;
            for (i = 0; i < this.m_k; ++i) {
                if (newNum != this.m_values[i]) continue;
                int n = i;
                this.m_counts[n] = this.m_counts[n] + 1L;
                notDone = false;
            }
            if (notDone) {
                if (this.m_k < this.m_kMax) {
                    this.m_values[this.m_k] = newNum;
                    this.m_counts[this.m_k] = 1L;
                    for (i = this.m_k; i > 0 && this.compare(this.m_values[i], this.m_values[i - 1]); --i) {
                        double tempValue = this.m_values[i];
                        long tempCount = this.m_counts[i];
                        this.m_values[i] = this.m_values[i - 1];
                        this.m_counts[i] = this.m_counts[i - 1];
                        this.m_values[i - 1] = tempValue;
                        this.m_counts[i - 1] = tempCount;
                    }
                    ++this.m_k;
                } else if (this.compare(newNum, this.m_values[0])) {
                    if ((long)this.sumCounts(0) < this.m_tau) {
                        int n = this.m_k - 2;
                        this.m_counts[n] = this.m_counts[n] + this.m_counts[this.m_k - 1];
                        for (i = this.m_k - 1; i > 0; --i) {
                            this.m_counts[i] = this.m_counts[i - 1];
                            this.m_values[i] = this.m_values[i - 1];
                        }
                        this.m_counts[0] = 1L;
                        this.m_values[0] = newNum;
                    }
                } else if (this.compare(this.m_values[this.m_k - 1], newNum)) {
                    int n = this.m_k - 1;
                    this.m_counts[n] = this.m_counts[n] + 1L;
                } else {
                    i = 0;
                    while (this.compare(this.m_values[i], newNum)) {
                        ++i;
                    }
                    int n = i - 1;
                    this.m_counts[n] = this.m_counts[n] + 1L;
                }
            }
            if ((long)(sumPostOne = this.sumCounts(1)) >= this.m_tau) {
                --this.m_k;
                for (int i2 = 0; i2 < this.m_k; ++i2) {
                    this.m_counts[i2] = this.m_counts[i2 + 1];
                    this.m_values[i2] = this.m_values[i2 + 1];
                }
            }
        }

        protected int sumCounts(int startIndex) {
            int ret = 0;
            for (int i = startIndex; i < this.m_k; ++i) {
                ret = (int)((long)ret + this.m_counts[i]);
            }
            return ret;
        }

        public double getBound() {
            return this.m_values[0];
        }

        protected abstract boolean compare(double var1, double var3);
    }

    public static class ByContinuousColumnStatsPerBin
    extends ByContinuousColumnStats {
        private ByContinuousColumnStats[] m_binColumnStats = null;
        private int m_numQuantiles;
        private int m_maxK;

        public ByContinuousColumnStatsPerBin(int numLevels, double min, double max, long rowCount, int numQuantiles, int maxK) {
            super(numLevels, min, max, rowCount, numQuantiles, maxK);
            this.m_numQuantiles = numQuantiles;
            this.m_maxK = maxK;
        }

        protected void updateBinAndRowCount(double newNum) {
            super.updateBinAndRowCount(newNum);
        }

        public void initQuantileStatisticsPerBin() {
            if (this.m_binColumnStats != null) {
                return;
            }
            int numBins = this.m_binCount.length - 1;
            this.m_binColumnStats = new ByContinuousColumnStats[numBins];
            for (int i = 0; i < numBins; ++i) {
                double binMin = i == 0 ? this.getMin() : this.getRangeMax(i - 1);
                double binMax = this.getRangeMax(i);
                long binCount = (long)this.getBinCount(i);
                this.m_binColumnStats[i] = new ByContinuousColumnStats(0, binMin, binMax, binCount, this.m_numQuantiles, this.m_maxK);
            }
        }

        public void updateQuantilePerBinSecondPass(double newNum) {
            int binNum = this.getBinNumber(newNum);
            this.m_binColumnStats[binNum].updateColumnStats(newNum);
            this.m_binColumnStats[binNum].initQuantileStatistics(this.getBinCount(binNum));
            this.m_binColumnStats[binNum].updateQuantileSecondPass(newNum);
            ++this.m_binColumnStats[binNum].m_rowCount;
        }

        public double getMin(int binNum) {
            if (this.m_binColumnStats == null) {
                return Double.NaN;
            }
            return this.m_binColumnStats[binNum].getMin();
        }

        public double getMax(int binNum) {
            if (this.m_binColumnStats == null) {
                return Double.NaN;
            }
            return this.m_binColumnStats[binNum].getMax();
        }

        public double getMean(int binNum) {
            if (this.m_binColumnStats == null) {
                return Double.NaN;
            }
            return this.m_binColumnStats[binNum].getMean();
        }

        public double getStandardDeviation(int binNum) {
            if (this.m_binColumnStats == null) {
                return Double.NaN;
            }
            return this.m_binColumnStats[binNum].getStandardDeviation();
        }

        public double getQuantileBound(int binNum, int quantile) {
            if (this.m_binColumnStats == null) {
                return Double.NaN;
            }
            return this.m_binColumnStats[binNum].getQuantileBound(quantile);
        }
    }

    public static class ByContinuousColumnStats
    extends ByColumnStats {
        private double m_columnMax;
        private double m_columnMin;
        private double[] m_rangeMax;
        private int m_numQuantiles;
        private int m_maxK;
        private boolean m_init;
        protected LowerBoundOnePassQuantile[] m_lowerBounds;
        protected UpperBoundOnePassQuantile[] m_upperBounds;

        public ByContinuousColumnStats(int numLevels, double min, double max, long rowCount, int numQuantiles, int maxK) {
            super(numLevels);
            this.m_columnMax = max;
            this.m_columnMin = min;
            this.m_numQuantiles = numQuantiles;
            this.m_maxK = maxK;
            this.m_init = false;
            this.m_rangeMax = new double[numLevels];
            double binSize = 0.0;
            if (numLevels != 0) {
                binSize = (max - min) / (double)numLevels;
            }
            for (int i = 0; i < numLevels; ++i) {
                this.m_rangeMax[i] = min + binSize * ((double)i + 1.0);
            }
            int storage = numQuantiles - 1;
            this.m_lowerBounds = new LowerBoundOnePassQuantile[storage];
            this.m_upperBounds = new UpperBoundOnePassQuantile[storage];
            double perQuantile = (double)rowCount / (double)numQuantiles;
            int extra = rowCount % 2L == 0L ? 0 : 1;
            for (int i = 0; i < storage; ++i) {
                long tau = (long)Math.ceil(perQuantile * (double)(i + 1));
                this.m_lowerBounds[i] = new LowerBoundOnePassQuantile(maxK, tau);
                this.m_upperBounds[i] = new UpperBoundOnePassQuantile(maxK, rowCount - tau + (long)extra);
            }
        }

        protected void updateBinAndRowCount(double newNum) {
            int i;
            if (Double.isNaN(newNum)) {
                int n = this.m_binCount.length - 1;
                this.m_binCount[n] = this.m_binCount[n] + 1;
                return;
            }
            for (i = 0; i < this.m_rangeMax.length; ++i) {
                if (!(newNum <= this.m_rangeMax[i]) && i != this.m_rangeMax.length - 1) continue;
                int n = i;
                this.m_binCount[n] = this.m_binCount[n] + 1;
                ++this.m_rowCount;
                break;
            }
            for (i = 0; i < this.m_lowerBounds.length; ++i) {
                this.m_lowerBounds[i].updateQuantile(newNum);
                this.m_upperBounds[i].updateQuantile(newNum);
            }
        }

        public void initQuantileStatistics() {
            if (this.m_init) {
                return;
            }
            this.m_init = true;
            long rowCount = (long)this.getRowCount();
            int storage = this.m_numQuantiles - 1;
            this.m_lowerBounds = new LowerBoundOnePassQuantile[storage];
            this.m_upperBounds = new UpperBoundOnePassQuantile[storage];
            double perQuantile = (double)rowCount / (double)this.m_numQuantiles;
            int extra = rowCount % 2L == 0L ? 0 : 1;
            for (int i = 0; i < storage; ++i) {
                long tau = (long)Math.ceil(perQuantile * (double)(i + 1));
                this.m_lowerBounds[i] = new LowerBoundOnePassQuantile(this.m_maxK, tau);
                this.m_upperBounds[i] = new UpperBoundOnePassQuantile(this.m_maxK, rowCount - tau + (long)extra);
            }
        }

        public void initQuantileStatistics(double iniitialRowCount) {
            if (this.m_init) {
                return;
            }
            this.m_init = true;
            long rowCount = (long)iniitialRowCount;
            int storage = this.m_numQuantiles - 1;
            this.m_lowerBounds = new LowerBoundOnePassQuantile[storage];
            this.m_upperBounds = new UpperBoundOnePassQuantile[storage];
            double perQuantile = (double)rowCount / (double)this.m_numQuantiles;
            int extra = rowCount % 2L == 0L ? 0 : 1;
            for (int i = 0; i < storage; ++i) {
                long tau = (long)Math.ceil(perQuantile * (double)(i + 1));
                this.m_lowerBounds[i] = new LowerBoundOnePassQuantile(this.m_maxK, tau);
                this.m_upperBounds[i] = new UpperBoundOnePassQuantile(this.m_maxK, rowCount - tau + (long)extra);
            }
        }

        public void updateQuantileSecondPass(double newNum) {
            for (int i = 0; i < this.m_lowerBounds.length; ++i) {
                this.m_lowerBounds[i].updateQuantile(newNum);
                this.m_upperBounds[i].updateQuantile(newNum);
            }
        }

        public int getBinNumber(double num) {
            if (Double.isNaN(num)) {
                return this.m_binCount.length - 1;
            }
            for (int i = 0; i < this.m_rangeMax.length; ++i) {
                if (!(num <= this.m_rangeMax[i]) && i != this.m_rangeMax.length - 1) continue;
                return i;
            }
            return this.m_binCount.length - 1;
        }

        public double getColumnMin() {
            return this.m_columnMin;
        }

        public double getColumnMax() {
            return this.m_columnMax;
        }

        public int getNumQuantileBounds() {
            if (this.m_lowerBounds == null) {
                return 0;
            }
            return this.m_lowerBounds.length;
        }

        public double getQuantileBound(int quantile) {
            if (this.m_lowerBounds == null) {
                return Double.NaN;
            }
            double ret = (this.m_lowerBounds[quantile].getBound() + this.m_upperBounds[quantile].getBound()) / 2.0;
            return ret;
        }

        public double getRangeMax(int range) {
            return this.m_rangeMax[range];
        }
    }

    public static class ByCategoricalColumnStats
    extends ByColumnStats {
        public ByCategoricalColumnStats(int numLevels) {
            super(numLevels);
        }

        protected void updateBinAndRowCount(double newNum) {
            if (!Double.isNaN(newNum)) {
                int n = (int)newNum;
                this.m_binCount[n] = this.m_binCount[n] + 1;
                ++this.m_rowCount;
            } else {
                int n = this.m_binCount.length - 1;
                this.m_binCount[n] = this.m_binCount[n] + 1;
            }
        }
    }

    public static abstract class ByColumnStats {
        protected double m_min;
        protected double m_max;
        protected double m_stdDevSum = Double.NaN;
        protected double m_mean = Double.NaN;
        protected long m_rowCount = 0L;
        protected int[] m_binCount;

        public ByColumnStats(int numLevels) {
            this.m_max = Double.NaN;
            this.m_min = Double.NaN;
            this.m_binCount = new int[numLevels + 1];
        }

        public void updateColumnStats(double newNum) {
            if (!Double.isNaN(newNum)) {
                if (this.m_min > newNum || Double.isNaN(this.m_min)) {
                    this.m_min = newNum;
                }
                if (this.m_max < newNum || Double.isNaN(this.m_max)) {
                    this.m_max = newNum;
                }
                if (Double.isNaN(this.m_mean)) {
                    this.m_mean = newNum;
                    this.m_stdDevSum = 0.0;
                } else {
                    double new_mean = this.m_mean + (newNum - this.m_mean) / (double)(this.m_rowCount + 1L);
                    double new_stdDevSum = this.m_stdDevSum + (newNum - this.m_mean) * (newNum - new_mean);
                    this.m_mean = new_mean;
                    this.m_stdDevSum = new_stdDevSum;
                }
            }
            this.updateBinAndRowCount(newNum);
        }

        public int getNumBins() {
            return this.m_binCount.length;
        }

        public double getMin() {
            return this.m_min;
        }

        public double getMax() {
            return this.m_max;
        }

        public double getMean() {
            return this.m_mean;
        }

        public double getRowCount() {
            return this.m_rowCount;
        }

        public double getBinCount(int bin) {
            return this.m_binCount[bin];
        }

        public double getStandardDeviation() {
            double stdDev = Math.sqrt(this.m_stdDevSum / (double)(this.m_rowCount - 1L));
            return stdDev;
        }

        protected abstract void updateBinAndRowCount(double var1);
    }
}

