/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.ClassificationAssessmentEngineNode;
import com.insightful.miner.LiftChartBuilder;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerLiftChartGUI;
import com.insightful.miner.ModelEvaluationDialog;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.Vector;
import org.w3c.dom.Element;

public class ClassificationAssessmentNodeModel
extends ActivityNodeModel {
    public ClassificationAssessmentNodeModel(Element elt) {
        super(elt);
    }

    public ClassificationAssessmentNodeModel(XTNetwork.NodeInfo elt) {
        super(elt);
    }

    public void showPropertiesDialog(boolean modality) {
        ModelEvaluationDialog dialog = ModelEvaluationDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this);
    }

    public void showView(Frame frame) {
        try {
            XTProps props = (XTProps)this.sendMessageToEngine("getNodeCacheXTProps", new Object[]{ClassificationAssessmentEngineNode.ASSESSMENT_NODE_CACHE});
            Vector inputs = props.getFirstLevelProperties();
            inputs.remove(ClassificationAssessmentEngineNode.NUM_BINS_ATTRIBUTE_TAG);
            int numBins = props.getInt(ClassificationAssessmentEngineNode.NUM_BINS_ATTRIBUTE_TAG, 0);
            long totalCount = 0L;
            long totalPositive = 0L;
            long difference = totalCount - totalPositive;
            int numInputs = inputs.size();
            int emptyInputs = 0;
            for (int i = numInputs - 1; i >= 0; --i) {
                String str = (String)inputs.get(i);
                if (props.getSubProperties(str).size() != 0) continue;
                ++emptyInputs;
                inputs.remove(str);
            }
            double[][] xCumGain = new double[numInputs -= emptyInputs][numBins];
            double[][] yCumGain = new double[numInputs][numBins];
            double[][] yLift = new double[numInputs][numBins];
            double[][] xROC = new double[numInputs][numBins];
            double[] cumSumTot = new double[numBins];
            double[] cumSumPos = new double[numBins];
            String[] countsPath = new String[3];
            String[] sumsPath = new String[2];
            for (int i = 0; i < numInputs; ++i) {
                if (numBins == 0) continue;
                sumsPath[0] = countsPath[0] = (String)inputs.get(i);
                sumsPath[1] = ClassificationAssessmentEngineNode.TITLE_ATTRIBUTE_TAG;
                String inputName = props.getValue(sumsPath, "Input #" + Integer.toString(i));
                if (!sumsPath[0].startsWith(ClassificationAssessmentEngineNode.INPUT_PREFIX_TAG)) {
                    BaseNodeArea area = this.getDocument().findFlatNodeByID(Integer.parseInt(sumsPath[0]));
                    if (area == null) continue;
                    inputName = ((ActivityNodeArea)area).getNodeModel().getLabelText();
                }
                inputs.set(i, inputName);
                sumsPath[1] = ClassificationAssessmentEngineNode.TOTAL_COUNT_SUM_ATTRIBUTE_TAG;
                totalCount = (long)props.getDouble(sumsPath, 0.0);
                sumsPath[1] = ClassificationAssessmentEngineNode.POSITIVE_COUNT_SUM_ATTRIBUTE_TAG;
                totalPositive = (long)props.getDouble(sumsPath, 0.0);
                difference = totalCount - totalPositive;
                double prevCumSumTotal = 0.0;
                double prevCumSumPos = 0.0;
                int j = 0;
                int binNum = numBins - 1;
                while (j < numBins) {
                    countsPath[2] = Integer.toString(binNum);
                    countsPath[1] = ClassificationAssessmentEngineNode.TOTAL_COUNT_ATTRIBUTE_TAG;
                    double totCount = props.getDouble(countsPath, 0.0);
                    countsPath[1] = ClassificationAssessmentEngineNode.POSITIVE_COUNT_ATTRIBUTE_TAG;
                    double posCount = props.getDouble(countsPath, 0.0);
                    cumSumPos[j] = prevCumSumPos + posCount;
                    cumSumTot[j] = prevCumSumTotal + totCount;
                    prevCumSumPos = cumSumPos[j];
                    prevCumSumTotal = cumSumTot[j];
                    xCumGain[i][j] = cumSumTot[j] / (double)totalCount * 100.0;
                    yCumGain[i][j] = cumSumPos[j] / (double)totalPositive * 100.0;
                    yLift[i][j] = yCumGain[i][j] / xCumGain[i][j];
                    xROC[i][j] = (cumSumTot[j] - cumSumPos[j]) / (double)difference * 100.0;
                    ++j;
                    --binNum;
                }
            }
            Component comp = MinerApp.getMainFrame().getGlassPane();
            Cursor oldCursor = comp.getCursor();
            comp.setCursor(Cursor.getPredefinedCursor(3));
            comp.setVisible(true);
            LiftChartBuilder liftChartBuilder = new LiftChartBuilder(inputs, xCumGain, yCumGain, yLift, xROC);
            MinerLiftChartGUI lcf = new MinerLiftChartGUI(liftChartBuilder);
            lcf.setLocation(MinerApp.getNextWindowLocation());
            lcf.setTitle(this.getLabelText());
            lcf.show();
            comp.setCursor(oldCursor);
            comp.setVisible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

