/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.DragAndDropTree;
import com.insightful.miner.ExplorerPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;

public class CreateNodeDialog
extends JDialog
implements ActionListener {
    ExplorerPane m_explorer = null;
    boolean m_newExplorer = true;

    public CreateNodeDialog(MinerFrame mf) {
        this(mf, "Create New Node", true);
    }

    public CreateNodeDialog(MinerFrame mf, String title, boolean newExplorer) {
        super(mf, title, true);
        this.setLocationRelativeTo(mf);
        this.m_explorer = new DialogExplorerPane(mf.getExplorerPane());
        this.m_explorer.removeAllTreeListeners();
        this.m_newExplorer = false;
        JButton cancel = new JButton(MinerApp.getText("NodeDialog_cancel"));
        JButton ok = new JButton(MinerApp.getText("NodeDialog_ok"));
        ok.setPreferredSize(cancel.getPreferredSize());
        ok.setMnemonic('O');
        cancel.setMnemonic('C');
        ok.addActionListener(this);
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateNodeDialog.this.dispose();
            }
        };
        cancel.addActionListener(cancelListener);
        cancel.registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        container.add((Component)this.m_explorer, constraints);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints bConstraints = new GridBagConstraints();
        bConstraints.insets = new Insets(10, 10, 10, 10);
        bConstraints.anchor = 17;
        buttonPanel.add((Component)ok, bConstraints);
        bConstraints.anchor = 13;
        buttonPanel.add((Component)cancel, bConstraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.weighty = 0.0;
        container.add((Component)buttonPanel, constraints);
        this.pack();
        Rectangle rect = this.getBounds();
        int newX = rect.x - rect.width / 2;
        int newY = rect.y - rect.height / 2;
        this.setBounds(newX, newY, rect.width, rect.height);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            DragAndDropTree dndTree = (DragAndDropTree)((JScrollPane)this.m_explorer.getSelectedComponent()).getViewport().getComponent(0);
            dndTree.onDoubleClick();
            this.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void dispose() {
        if (!this.m_newExplorer) {
            this.m_explorer.addAllTreeListeners();
        }
        super.dispose();
    }

    public static class DialogExplorerPane
    extends ExplorerPane {
        public DialogExplorerPane() {
            super(MinerApp.getGlobalOptions());
            this.removeAllTreeListeners();
            for (int i = 0; i < this.getTabCount(); ++i) {
                DragAndDropTree tree = (DragAndDropTree)this.m_extensionLibraryTrees.get(i);
                tree.setDropable(false);
            }
            this.expandJTree();
        }

        public DialogExplorerPane(ExplorerPane parent) {
            super(null, false);
            DragAndDropTree tree;
            int i;
            for (i = 0; i < parent.getTabCount(); ++i) {
                tree = new DragAndDropTree(parent.getTreeAtTab(i).getModel(), false);
                this.m_extensionLibraryTrees.add(tree);
                this.addTab(parent.getTitleAt(i), new JScrollPane(tree));
                tree.expandJTree();
            }
            this.m_extensionLibraryNames = parent.m_extensionLibraryNames;
            this.removeAllTreeListeners();
            for (i = 0; i < this.getTabCount(); ++i) {
                tree = (DragAndDropTree)this.m_extensionLibraryTrees.get(i);
                tree.setDropable(false);
            }
        }

        public void stateChanged(ChangeEvent e) {
            this.m_currentTree = null;
            this.m_currentTab = -1;
        }
    }
}

