/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.GridViewerModel;
import com.insightful.miner.GridViewerTable;
import com.insightful.miner.XTMetaData;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ModifiableTypeGridViewerTable
extends GridViewerTable {
    private static String[] m_possibleTypes = new String[]{XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG, XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG, XTMetaData.STRING_TYPE_ATTRIBUTE_TAG, XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG};
    public String[] m_currentTypes = null;

    public ModifiableTypeGridViewerTable(TableModel tm) {
        super(tm);
        this.jSecondaryTableHeader.setDefaultRenderer(new ModifiableTableHeaderRenderer((GridViewerTable)this));
        int numColumns = ((GridViewerModel)tm).getTotalColCount();
        this.m_currentTypes = new String[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            this.m_currentTypes[i] = ((GridViewerModel)tm).getColumnType(i);
        }
    }

    protected JTableHeader createSecondaryHeader() {
        return new MyEditableTableHeader((GridViewerTable)this);
    }

    public static class EditableHeaderUI
    extends BasicTableHeaderUI {
        protected MouseInputListener createMouseInputListener() {
            return new MouseInputHandler((MyEditableTableHeader)this.header);
        }

        public class MouseInputHandler
        extends BasicTableHeaderUI.MouseInputHandler {
            private Component dispatchComponent;
            protected MyEditableTableHeader header;

            public MouseInputHandler(MyEditableTableHeader header) {
                super(EditableHeaderUI.this);
                this.header = header;
            }

            private void setDispatchComponent(MouseEvent e) {
                Component editorComponent = this.header.getEditorComponent();
                Point p = e.getPoint();
                Point p2 = SwingUtilities.convertPoint(this.header, p, editorComponent);
                this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
            }

            private boolean repostEvent(MouseEvent e) {
                if (this.dispatchComponent == null) {
                    return false;
                }
                MouseEvent e2 = SwingUtilities.convertMouseEvent(this.header, e, this.dispatchComponent);
                this.dispatchComponent.dispatchEvent(e2);
                return true;
            }

            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                super.mousePressed(e);
                if (this.header.getResizingColumn() == null) {
                    Point p = e.getPoint();
                    TableColumnModel columnModel = this.header.getColumnModel();
                    int index = columnModel.getColumnIndexAtX(p.x);
                    if (index != -1 && this.header.editCellAt(index, e)) {
                        this.setDispatchComponent(e);
                        this.repostEvent(e);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                this.repostEvent(e);
                this.dispatchComponent = null;
            }
        }
    }

    protected class MyEditableTableHeader
    extends GridViewerTable.MyTableHeader
    implements CellEditorListener {
        private DefaultCellEditor m_editor;

        public MyEditableTableHeader(GridViewerTable table) {
            super(table);
            this.m_editor = new DefaultCellEditor(new JComboBox<String>(m_possibleTypes));
        }

        public void updateUI() {
            this.setUI(new EditableHeaderUI());
            this.resizeAndRepaint();
            this.invalidate();
        }

        public Component getEditorComponent() {
            return this.m_editor.getComponent();
        }

        public Component prepareEditor(TableCellEditor editor, int index) {
            int realIndex;
            String value;
            JTable table = this.getTable();
            Component comp = editor.getTableCellEditorComponent(table, value = ModifiableTypeGridViewerTable.this.m_currentTypes[realIndex = ((GridViewerModel)table.getModel()).getAbsoluteColumnNumber(index)], true, -10, index);
            if (comp instanceof JComponent) {
                ((JComponent)comp).setNextFocusableComponent(this);
            }
            return comp;
        }

        public boolean editCellAt(int index, EventObject e) {
            if (!this.m_editor.stopCellEditing()) {
                return false;
            }
            ModifiableTypeGridViewerTable.this.editorComp = this.prepareEditor(this.m_editor, index);
            ModifiableTypeGridViewerTable.this.editorComp.setBounds(this.getHeaderRect(index));
            this.add(ModifiableTypeGridViewerTable.this.editorComp);
            ModifiableTypeGridViewerTable.this.editorComp.validate();
            ModifiableTypeGridViewerTable.this.setCellEditor(this.m_editor);
            ModifiableTypeGridViewerTable.this.setEditingColumn(index);
            this.m_editor.addCellEditorListener(this);
            return true;
        }

        public void removeEditor() {
            this.m_editor.removeCellEditorListener(this);
            this.requestFocus();
            if (ModifiableTypeGridViewerTable.this.editorComp != null) {
                this.remove(ModifiableTypeGridViewerTable.this.editorComp);
            }
            int index = ModifiableTypeGridViewerTable.this.getEditingColumn();
            Rectangle cellRect = this.getHeaderRect(index);
            ModifiableTypeGridViewerTable.this.setCellEditor(null);
            ModifiableTypeGridViewerTable.this.setEditingColumn(-1);
            ModifiableTypeGridViewerTable.this.editorComp = null;
            this.repaint(cellRect);
        }

        public void editingCanceled(ChangeEvent e) {
            this.removeEditor();
        }

        public void editingStopped(ChangeEvent e) {
            Object value = this.m_editor.getCellEditorValue();
            int index = ModifiableTypeGridViewerTable.this.getEditingColumn();
            index = ((GridViewerModel)this.getTable().getModel()).getAbsoluteColumnNumber(index);
            ModifiableTypeGridViewerTable.this.m_currentTypes[index] = value.toString();
            this.removeEditor();
        }
    }

    protected class ModifiableTableHeaderRenderer
    extends GridViewerTable.SecondaryTableHeaderRenderer {
        private Font m_unmodifiedFont;
        private Font m_modifiedFont;

        public ModifiableTableHeaderRenderer(GridViewerTable t) {
            super(t);
            this.m_unmodifiedFont = null;
            this.m_modifiedFont = null;
        }

        public Component getTableCellRendererComponent(JTable t, Object val, boolean isSel, boolean hasFocus, int row, int col) {
            String type = ((GridViewerModel)t.getModel()).getColumnType(col);
            int actualColumnNumber = ((GridViewerModel)t.getModel()).getAbsoluteColumnNumber(col);
            String newType = ModifiableTypeGridViewerTable.this.m_currentTypes[actualColumnNumber];
            Component comp = this.dtcr.getTableCellRendererComponent(t, newType, isSel, hasFocus, row, col);
            if (this.m_unmodifiedFont == null) {
                Font font;
                this.m_unmodifiedFont = font = ((JLabel)comp).getFont();
                this.m_modifiedFont = new Font(this.m_unmodifiedFont.getName(), 3, this.m_unmodifiedFont.getSize());
            }
            if (!type.equals(newType)) {
                ((JLabel)comp).setFont(this.m_modifiedFont);
            } else {
                ((JLabel)comp).setFont(this.m_unmodifiedFont);
            }
            return comp;
        }
    }
}

