/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg;

import com.insightful.miner.ChartBuilder;
import com.insightful.miner.graphdlg.controls.MinerButton;
import com.insightful.miner.graphdlg.controls.MinerControlMetrics;
import com.insightful.miner.graphdlg.controls.MinerFunctionInfo;
import com.insightful.miner.graphdlg.controls.MinerGroupPanel;
import com.insightful.miner.graphdlg.controls.MinerInvisibleControl;
import com.insightful.miner.graphdlg.controls.MinerWideBoxFiller;
import com.insightful.miner.graphdlg.controls.MinerWideComboBox;
import com.insightful.miner.graphdlg.controls.MinerWideTextField;
import com.insightful.splus.SplusSystem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class FilePage
extends JPanel {
    MinerWideTextField fileName;
    ExportFileTypeControl fileTypeControl;
    MinerInvisibleControl fileTypeCode;
    MinerButton fileButton;
    JFileChooser fileChooser = null;
    private static String[] typeCodeList = new String[]{"", "PDF", "WMF", "EPS", "PS", "SVG", "SPJ", "JPG", "TIF", "PNG", "PNM", "BMP"};
    private static final String[] typeDescriptionList = new String[]{"Unspecified file format", "Adobe Portable Document Format (*.pdf)", "Windows Metafile (*.wmf)", "Encapsulated Postscript (*.eps)", "Postscript (*.ps)", "Scalable Vector Graphics (*.svg)", "S-PLUS Graphlet (*.spj)", "JPEG (*.jpg)", "TIFF (*.tif)", "Portable Network Graphics (*.png)", "Portable Any Map (*.pnm)", "Bitmap (*.bmp)"};
    private static final String[][] extensionList = new String[][]{{""}, {".pdf"}, {".wmf"}, {".eps"}, {".ps"}, {".svg"}, {".spj"}, {".jpg"}, {".tif"}, {".png"}, {".pnm"}, {".bmp"}};

    public FilePage(MinerFunctionInfo funcInfo) {
        this.setName(ChartBuilder.getText("graph_dialog_file_text"));
        this.setLayout(new BoxLayout(this, 1));
        MinerGroupPanel fileGroup = new MinerGroupPanel(ChartBuilder.getText("graph_dialog_saveto_file"));
        this.add(fileGroup);
        this.fileName = new MinerWideTextField(ChartBuilder.getText("graph_dialog_file_name"), 'N');
        fileGroup.add(this.fileName);
        funcInfo.add(this.fileName, "fileName", true);
        this.fileButton = new MinerButton(ChartBuilder.getText("graph_dialog_browse_text"), 'B');
        this.fileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                int exitStatus;
                if (FilePage.this.fileChooser == null) {
                    FilePage.this.fileChooser = new JFileChooser(SplusSystem.getCwd());
                    FilePage.this.fileChooser.setDialogTitle(ChartBuilder.getText("graph_dialog_select_file"));
                    for (int i = 1; i < extensionList.length; ++i) {
                        FilePage.this.fileChooser.addChoosableFileFilter(new LocalExtensionFileFilter(extensionList[i], typeDescriptionList[i]));
                    }
                    FilePage.this.fileChooser.setFileFilter(FilePage.this.fileChooser.getAcceptAllFileFilter());
                }
                if ((exitStatus = FilePage.this.fileChooser.showDialog(null, "OK")) == 0) {
                    FilePage.this.fileName.setValue(FilePage.this.fileChooser.getSelectedFile().getAbsolutePath());
                    String filterDesc = FilePage.this.fileChooser.getFileFilter().getDescription();
                    if (!filterDesc.startsWith("All")) {
                        FilePage.this.fileTypeControl.setValue(filterDesc);
                    }
                    SplusSystem.setCwd((File)FilePage.this.fileChooser.getCurrentDirectory());
                }
            }
        });
        Box fileButtonBox = new Box(0);
        fileButtonBox.add(Box.createHorizontalGlue());
        fileButtonBox.add(this.fileButton);
        fileButtonBox.add(Box.createHorizontalStrut(10));
        fileGroup.add(Box.createVerticalStrut(5));
        fileGroup.add(fileButtonBox);
        fileGroup.add(Box.createVerticalStrut(5));
        fileGroup.add(Box.createVerticalStrut(MinerControlMetrics.getFullDimension().height));
        this.fileTypeControl = new ExportFileTypeControl();
        fileGroup.add(this.fileTypeControl);
        funcInfo.add(this.fileTypeControl, "");
        this.fileTypeCode = new MinerInvisibleControl("");
        fileGroup.add(this.fileTypeCode);
        funcInfo.add(this.fileTypeCode, "fileType", true);
        this.add(new MinerWideBoxFiller());
    }

    private class LocalExtensionFileFilter
    extends FileFilter {
        String[] extList;
        String description;

        public LocalExtensionFileFilter(String ext, String descr) {
            this.extList = new String[]{ext};
            this.description = descr;
        }

        public LocalExtensionFileFilter(String[] ext, String descr) {
            this.extList = ext;
            this.description = descr;
        }

        public boolean accept(File file) {
            boolean status = true;
            boolean bl = status = file.isDirectory() || this.extList[0].equals("");
            if (!status) {
                String fileName = file.getName().toLowerCase();
                for (int i = 0; i < this.extList.length; ++i) {
                    status = status || fileName.endsWith(this.extList[i]);
                }
            }
            return status;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private class ExportFileTypeListener
    implements ActionListener {
        int indexValue;
        String codeValue;
        String delimiterValue;

        ExportFileTypeListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            this.indexValue = FilePage.this.fileTypeControl.getSelectedIndex();
            this.codeValue = typeCodeList[this.indexValue];
            FilePage.this.fileTypeCode.setValue(this.codeValue);
        }
    }

    private class ExportFileTypeControl
    extends MinerWideComboBox {
        ExportFileTypeControl() {
            super(ChartBuilder.getText("graph_dialog_file_type"), 'T', typeDescriptionList);
            this.setEditable(false);
            this.addActionListener(new ExportFileTypeListener());
        }
    }
}

