/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg.controls;

import com.insightful.miner.graphdlg.controls.MinerControlMethods;
import com.insightful.miner.graphdlg.controls.MinerControlMetrics;
import com.insightful.miner.graphdlg.controls.MinerDataSetComboBox;
import com.insightful.miner.graphdlg.controls.MinerFunctionInfo;
import com.insightful.splus.SplusSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class MinerDialog
extends JDialog {
    JPanel buttonPanel;
    ButtonListener buttonListener;
    LocalButton okButton;
    LocalButton cancelButton;
    LocalButton applyButton;
    LocalButton helpButton;
    MinerFunctionInfo funcInfo = new MinerFunctionInfo();
    private static final Dimension labelDimension = MinerControlMetrics.getLabelDimension();
    private static final Dimension fullDimension = MinerControlMetrics.getFullDimension();
    private static final int buttonHeight = MinerDialog.labelDimension.height;
    private static final int buttonWidth = (int)((double)MinerDialog.labelDimension.width * 0.75);
    private static final Dimension buttonDimension = new Dimension(buttonWidth, buttonHeight);
    private static final int buttonPanelHeight = buttonHeight + 15;
    private static final int buttonPanelWidth = MinerDialog.fullDimension.width * 2 + 15;
    private static final Dimension buttonPanelDimension = new Dimension(buttonPanelWidth, buttonPanelHeight);

    public MinerDialog() {
        this(SplusSystem.getDefaultFrame(), "");
    }

    public MinerDialog(String text) {
        this(SplusSystem.getDefaultFrame(), text);
    }

    public MinerDialog(Frame frame, String title) {
        super(frame, title);
        if (SplusSystem.getEngineQueryHandler() != null) {
            MinerDataSetComboBox.updateDataSetList();
        }
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setPreferredSize(buttonPanelDimension);
        this.buttonPanel.setMinimumSize(buttonPanelDimension);
        this.buttonListener = new ButtonListener();
        this.okButton = new LocalButton("OK");
        this.okButton.setPreferredSize(buttonDimension);
        this.okButton.addActionListener(this.buttonListener);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new LocalButton("Cancel");
        this.cancelButton.setPreferredSize(buttonDimension);
        this.cancelButton.addActionListener(this.buttonListener);
        this.cancelButton.registerKeyboardAction(this.buttonListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
        this.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
                if (e.isAltDown() && e.isMetaDown()) {
                    e.setModifiers(8);
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.isAltDown() && e.isMetaDown()) {
                    e.setModifiers(8);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.isAltDown() && e.isMetaDown()) {
                    e.setModifiers(8);
                }
            }
        });
        this.applyButton = new LocalButton("Apply");
        this.applyButton.setPreferredSize(buttonDimension);
        this.applyButton.addActionListener(this.buttonListener);
        this.helpButton = new LocalButton("Help");
        this.helpButton.setPreferredSize(buttonDimension);
        this.helpButton.addActionListener(this.buttonListener);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.applyButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.helpButton);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
    }

    public MinerFunctionInfo getFunctionInfo() {
        return this.funcInfo;
    }

    public void setFunctionInfo(MinerFunctionInfo info) {
        this.funcInfo = info;
    }

    public void setCenterPanel(JComponent centerPanel) {
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)centerPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0)), "North");
        this.getContentPane().add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0)), "East");
        this.getContentPane().add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0)), "West");
        Dimension rootSize = this.getRootPane().getMinimumSize();
        int paddedHeight = rootSize.height + MinerDialog.labelDimension.height * 2;
        int paddedWidth = rootSize.width + 30;
        Dimension paddedSize = new Dimension(paddedWidth, paddedHeight);
        this.setSize(paddedSize);
        if (this.getOwner() != null) {
            MinerDialog.centerComponent(this, this.getOwner());
        }
    }

    public void show() {
        super.show();
        Component firstComponent = this.getContentPane().getComponent(0);
        FocusManager.getCurrentManager().focusNextComponent(firstComponent);
    }

    public void performOk() {
        if (this.isComplete()) {
            this.sendCommand();
            this.dispose();
        }
    }

    public void performApply() {
        if (this.isComplete()) {
            this.sendCommand();
        }
    }

    public void performCancel() {
        this.dispose();
    }

    public boolean isComplete() {
        return true;
    }

    public boolean warnIfEmpty(MinerControlMethods field) {
        if (field.getValue().equals("")) {
            JOptionPane.showMessageDialog(this, field.getText() + " field requires a value.", "Required Field Empty", 2);
            return false;
        }
        return true;
    }

    public void performHelp() {
        String keyword = this.getTitle();
        keyword = keyword.replace(' ', '_');
        keyword = keyword.replace('\'', '_');
        keyword = keyword.replace('&', '_');
        keyword = keyword.replace('-', '_');
        keyword = keyword.replace('(', '_');
        keyword = keyword.replace(')', '_');
        if (SplusSystem.getHelpQueryHandler() != null) {
            SplusSystem.getHelpQueryHandler().displayHelpOnTopic(keyword);
        }
    }

    public void sendCommand() {
        if (SplusSystem.getEngineQueryHandler() != null) {
            SplusSystem.getEngineQueryHandler().processDialogCommand(this.funcInfo.getFunctionCall());
        }
    }

    public void setApplyVisible(boolean isVisible) {
        this.applyButton.setVisible(isVisible);
    }

    public static JMenuBar getMainMenuBar() {
        return SplusSystem.getMainMenuBar();
    }

    public static ActionListener getMainActionListener() {
        return SplusSystem.getMainActionListener();
    }

    public static void showNewDialog(String className) throws ClassNotFoundException {
        className = className.replace('/', '.');
        final Class<?> cls = ClassLoader.getSystemClassLoader().loadClass(className);
        Thread dlgThread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.yield();
                    MinerDialog dlg = (MinerDialog)cls.newInstance();
                    dlg.show();
                    dlg.repaint();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), e.toString(), "Dialog Display Error", 0);
                }
            }
        });
        dlgThread.start();
    }

    public static final void centerComponent(Component child, Component parent) {
        Dimension childDim = child.getSize();
        Dimension parentDim = parent.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point location = parent.getLocation();
        location.translate((parentDim.width - childDim.width) / 2, (parentDim.height - childDim.height) / 2);
        location.x = Math.max(0, Math.min(location.x, screenSize.width - childDim.width));
        location.y = Math.max(0, Math.min(location.y, screenSize.height - parentDim.height));
        child.setLocation(location.x, location.y);
    }

    private class LocalButton
    extends JButton {
        LocalButton(String text) {
            super(text);
        }

        protected void processKeyEvent(KeyEvent evt) {
            if (evt.getKeyCode() == 10) {
                if (evt.getID() == 401) {
                    evt.consume();
                }
                this.doClick();
            } else {
                super.processKeyEvent(evt);
            }
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            LocalButton buttonPressed = (LocalButton)ae.getSource();
            if (buttonPressed == MinerDialog.this.okButton) {
                MinerDialog.this.performOk();
            } else if (buttonPressed == MinerDialog.this.cancelButton) {
                MinerDialog.this.performCancel();
            } else if (buttonPressed == MinerDialog.this.applyButton) {
                MinerDialog.this.performApply();
            } else if (buttonPressed == MinerDialog.this.helpButton) {
                MinerDialog.this.performHelp();
            }
        }
    }
}

