/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.tree.gui;

import com.insightful.miner.tree.gui.ColorBroker;
import com.insightful.miner.tree.model.TreeCollection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class ClassificationRegressionTreeIcon
implements Icon {
    private int radius = 10;
    private double scoreRatio = 0.0;
    private int width;
    private int height = 2 * this.radius;
    private double[] prob;
    private boolean isRegression;
    private boolean contains_size_image = false;
    private boolean contains_score_image = false;
    private double diversityRatio = -1.0;
    private boolean for_legend = false;
    private double size_ratio = -1.0;
    private String imageText = "";
    private TreeCollection treeColl = null;

    public ClassificationRegressionTreeIcon(TreeCollection tc, double[] nodeprob, double score_ratio, double record_ratio, double diversity_ratio, boolean containsSizeImage, boolean containsScoreImage, boolean containsDiversityImage, boolean forLegend, boolean is_regression) {
        this.treeColl = tc;
        if (nodeprob != null) {
            this.prob = new double[nodeprob.length];
            for (int i = 0; i < nodeprob.length; ++i) {
                this.prob[i] = nodeprob[i];
            }
        }
        this.isRegression = is_regression;
        this.width = is_regression ? 2 * this.radius : 20;
        this.diversityRatio = diversity_ratio;
        this.scoreRatio = score_ratio;
        this.size_ratio = record_ratio;
        this.contains_size_image = containsSizeImage;
        this.contains_score_image = containsScoreImage;
        this.for_legend = forLegend;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void setIconHeight(int newHeight) {
        this.height = newHeight;
    }

    public int getIconWidth() {
        int w = 0;
        if (this.contains_size_image) {
            ++w;
        }
        if (this.contains_score_image) {
            ++w;
        }
        return this.width * w + 2 * w;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int add_y = 10;
        if (this.for_legend) {
            if (this.contains_size_image) {
                this.drawSizeImage(g, x, y, add_y, 0);
            }
            if (this.contains_score_image) {
                this.drawScoreImage(g, x, y, add_y);
            }
            return;
        }
        if (this.contains_score_image) {
            this.drawScoreImage(g, x, y, add_y);
            if (this.contains_size_image) {
                this.drawSizeImage(g, x, y, add_y, this.width + 3);
            }
        } else if (this.contains_size_image) {
            this.drawSizeImage(g, x, y, add_y, 0);
        }
    }

    private void drawScoreImage(Graphics g, int x, int y, int add_y) {
        if (this.isRegression) {
            g.setColor(ColorBroker.getColor("regressionScoreColor"));
            g.drawRect(x, y + 2, this.width, this.height - 4);
            g.fillRect(x, y + 2, (int)(this.prob[0] * (double)this.width), this.height - 4);
        } else {
            double xstart = x;
            int distance = 0;
            int i = 0;
            if (!this.treeColl.getShowProportions()) {
                double max = 0.0;
                int max_index = 0;
                for (i = 0; i < this.prob.length; ++i) {
                    if (!(max < this.prob[i])) continue;
                    max = this.prob[i];
                    max_index = i;
                }
                g.setColor(ColorBroker.getScoreColor(max_index));
                distance = (int)(max * (double)this.width);
                g.fillRect((int)xstart + 1, y + 3, distance, this.height - 5);
            } else {
                for (i = 0; i < this.prob.length; ++i) {
                    g.setColor(ColorBroker.getScoreColor(i));
                    distance = (int)(this.prob[i] * (double)this.width);
                    if (distance == 0) {
                        distance = 1;
                    }
                    if (i == this.prob.length - 1) {
                        distance = this.width - (int)xstart;
                    }
                    if (!(xstart < (double)(x + this.width))) continue;
                    g.fillRect((int)xstart + 1, y + 3, distance, this.height - 5);
                    xstart += this.prob[i] * (double)this.width;
                }
            }
            g.setColor(Color.black);
            g.drawRect(x, y + 2, this.width, this.height - 4);
        }
    }

    private void drawSizeImage(Graphics g, int x, int y, int add_y, int offset) {
        g.setColor(ColorBroker.getColor("sizeImageColor"));
        g.drawRect(offset + x, y + 4, this.width, this.height - 8);
        int distance = (int)(this.size_ratio * (double)this.width);
        if (distance < 2) {
            distance = 2;
        }
        g.fillRect(offset + x, y + 4, distance, this.height - 8);
    }

    public String getDescription() {
        return this.imageText;
    }

    public void setDescription(String text) {
        this.imageText = text;
    }
}

