/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.Area;
import org.apache.fop.area.BlockParent;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockContainerLayoutManager;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;

public class FlowLayoutManager
extends BlockStackingLayoutManager
implements BlockLevelLayoutManager {
    private Flow fobj;
    private BlockParent[] currentAreas = new BlockParent[6];
    private int currentSpan = 95;

    public FlowLayoutManager(PageSequenceLayoutManager pslm, Flow node) {
        super(node);
        this.fobj = node;
        this.setParent(pslm);
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        BlockLevelLayoutManager curLM;
        int flowIPD = this.getCurrentPV().getCurrentSpan().getColumnWidth();
        int flowBPD = this.getCurrentPV().getBodyRegion().getBPD();
        this.fobj.setLayoutDimension(PercentBase.REFERENCE_AREA_IPD, flowIPD);
        this.fobj.setLayoutDimension(PercentBase.REFERENCE_AREA_BPD, flowBPD);
        this.fobj.setLayoutDimension(PercentBase.BLOCK_IPD, context.getRefIPD());
        this.fobj.setLayoutDimension(PercentBase.BLOCK_BPD, context.getStackLimit().opt);
        LinkedList returnList = new LinkedList();
        while ((curLM = (BlockLevelLayoutManager)this.getChildLM()) != null) {
            if (curLM instanceof InlineLevelLayoutManager) {
                log.error("inline area not allowed under flow - ignoring");
                curLM.setFinished(true);
                continue;
            }
            int span = 95;
            if (curLM instanceof BlockLayoutManager) {
                span = ((BlockLayoutManager)curLM).getBlockFO().getSpan();
            } else if (curLM instanceof BlockContainerLayoutManager) {
                span = ((BlockContainerLayoutManager)curLM).getBlockContainerFO().getSpan();
            }
            if (this.currentSpan != span) {
                log.debug("span change from " + this.currentSpan + " to " + span);
                context.signalSpanChange(span);
                this.currentSpan = span;
                return returnList;
            }
            LayoutContext childLC = new LayoutContext(0);
            childLC.setStackLimit(context.getStackLimit());
            childLC.setRefIPD(context.getRefIPD());
            LinkedList returnedList = curLM.getNextKnuthElements(childLC, alignment);
            if (returnList.size() == 0 && childLC.isKeepWithPreviousPending()) {
                context.setFlags(1024);
                childLC.setFlags(1024, false);
            }
            LinkedList tempList = returnedList;
            returnedList = new LinkedList();
            this.wrapPositionElements(tempList, returnedList);
            if (returnedList.size() == 1 && ((KnuthElement)returnedList.getFirst()).isPenalty() && ((KnuthPenalty)returnedList.getFirst()).getP() == -1000) {
                returnList.addAll(returnedList);
                return returnList;
            }
            if (returnList.size() > 0) {
                if (context.isKeepWithNextPending() || childLC.isKeepWithPreviousPending()) {
                    context.setFlags(512, false);
                    childLC.setFlags(1024, false);
                    returnList.add(new KnuthPenalty(0, 1000, false, new Position(this), false));
                } else if (!((KnuthElement)returnList.getLast()).isGlue()) {
                    returnList.add(new KnuthPenalty(0, 0, false, new Position(this), false));
                }
            }
            if (returnedList.size() > 0) {
                returnList.addAll(returnedList);
                if (((KnuthElement)returnedList.getLast()).isPenalty() && ((KnuthPenalty)returnedList.getLast()).getP() == -1000) {
                    return returnList;
                }
            }
            if (!childLC.isKeepWithNextPending()) continue;
            childLC.setFlags(512, false);
            context.setFlags(512);
        }
        this.setFinished(true);
        if (returnList.size() > 0) {
            return returnList;
        }
        return null;
    }

    public int negotiateBPDAdjustment(int adj, KnuthElement lastElement) {
        log.debug(" FLM.negotiateBPDAdjustment> " + adj);
        if (lastElement.getPosition() instanceof NonLeafPosition) {
            NonLeafPosition savedPos = (NonLeafPosition)lastElement.getPosition();
            lastElement.setPosition(savedPos.getPosition());
            int returnValue = ((BlockLevelLayoutManager)lastElement.getLayoutManager()).negotiateBPDAdjustment(adj, lastElement);
            lastElement.setPosition(savedPos);
            log.debug(" FLM.negotiateBPDAdjustment> result " + returnValue);
            return returnValue;
        }
        return 0;
    }

    public void discardSpace(KnuthGlue spaceGlue) {
        log.debug(" FLM.discardSpace> ");
        if (spaceGlue.getPosition() instanceof NonLeafPosition) {
            NonLeafPosition savedPos = (NonLeafPosition)spaceGlue.getPosition();
            spaceGlue.setPosition(savedPos.getPosition());
            ((BlockLevelLayoutManager)spaceGlue.getLayoutManager()).discardSpace(spaceGlue);
            spaceGlue.setPosition(savedPos);
        }
    }

    public boolean mustKeepTogether() {
        return false;
    }

    public boolean mustKeepWithPrevious() {
        return false;
    }

    public boolean mustKeepWithNext() {
        return false;
    }

    public LinkedList getChangedKnuthElements(List oldList, int alignment) {
        ListIterator oldListIterator = oldList.listIterator();
        LinkedList<KnuthPenalty> returnedList = new LinkedList<KnuthPenalty>();
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        KnuthElement prevElement = null;
        KnuthElement currElement = null;
        int fromIndex = 0;
        while (oldListIterator.hasNext()) {
            KnuthElement oldElement = (KnuthElement)oldListIterator.next();
            if (oldElement.getPosition() instanceof NonLeafPosition) {
                oldElement.setPosition(((NonLeafPosition)oldElement.getPosition()).getPosition());
                continue;
            }
            oldListIterator.remove();
        }
        oldListIterator = oldList.listIterator();
        while (oldListIterator.hasNext()) {
            currElement = (KnuthElement)oldListIterator.next();
            if (prevElement != null && prevElement.getLayoutManager() != currElement.getLayoutManager()) {
                BlockLevelLayoutManager prevLM = (BlockLevelLayoutManager)prevElement.getLayoutManager();
                BlockLevelLayoutManager currLM = (BlockLevelLayoutManager)currElement.getLayoutManager();
                returnedList.addAll(prevLM.getChangedKnuthElements(oldList.subList(fromIndex, oldListIterator.previousIndex()), alignment));
                fromIndex = oldListIterator.previousIndex();
                if (prevLM.mustKeepWithNext() || currLM.mustKeepWithPrevious()) {
                    returnedList.add(new KnuthPenalty(0, 1000, false, new Position(this), false));
                } else if (!((KnuthElement)returnedList.getLast()).isGlue()) {
                    returnedList.add(new KnuthPenalty(0, 0, false, new Position(this), false));
                }
            }
            prevElement = currElement;
        }
        if (currElement != null) {
            BlockLevelLayoutManager currLM = (BlockLevelLayoutManager)currElement.getLayoutManager();
            returnedList.addAll(currLM.getChangedKnuthElements(oldList.subList(fromIndex, oldList.size()), alignment));
        }
        ListIterator listIter = returnedList.listIterator();
        while (listIter.hasNext()) {
            KnuthElement returnedElement = (KnuthElement)listIter.next();
            if (returnedElement.getLayoutManager() != this) {
                returnedElement.setPosition(new NonLeafPosition(this, returnedElement.getPosition()));
            }
            returnList.add(returnedElement);
        }
        return returnList;
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        AreaAdditionUtil.addAreas(this, parentIter, layoutContext);
        this.flush();
    }

    public void addChildArea(Area childArea) {
        this.getParentArea(childArea);
        this.addChildToArea(childArea, this.currentAreas[childArea.getAreaClass()]);
    }

    public Area getParentArea(Area childArea) {
        BlockParent parentArea = null;
        int aclass = childArea.getAreaClass();
        if (aclass == 0) {
            parentArea = this.getCurrentPV().getCurrentFlow();
        } else if (aclass == 3) {
            parentArea = this.getCurrentPV().getBodyRegion().getBeforeFloat();
        } else if (aclass == 4) {
            parentArea = this.getCurrentPV().getBodyRegion().getFootnote();
        } else {
            throw new IllegalStateException("(internal error) Invalid area class (" + aclass + ") requested.");
        }
        this.currentAreas[aclass] = parentArea;
        this.setCurrentArea(parentArea);
        return parentArea;
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        }
    }
}

