#ifndef SPOST_H
#define SPOST_H

#include "device.h"

#define STRlen(p) ((p) ? strlen(p) : 0)


  /* the reasons and effects of the
     variables warned, pipe error and pipe handler in the structure
     defined below are described in the next paragraph
   */

/*
 * popen will still return a FILE pointer even if the program *where
 * cannot be executed by /bin/sh.  The user will see sh print
 * (to stderr) something like "sh: foobar: not found", but popen
 * does not report that failure.  In any case, the command may
 * die after getting some input from postscript (e.g., head dies
 * after getting the first 10 lines).  Thus we should constantly
 * check for pipe errors.  Report the first one to the user and
 * ignore the rest.  Pclose will report the error as well,
 * and we will tell the user then that he isn't going to get
 * much output.
 */


typedef struct {

 FILE *File;                /* Pipe or File* stream along which the text will travel */
 float current_am[NPARAMS]; /* Parameters */
 int is_command;            /* are we going to a file or along a pipe to a command?  */
 int page;                  /* Page counter */
 int newpage;               /* Whether we need to spit out a new page. Seems to be 0 if true */
 
 int warned;                /* Have we issued a warning about the pipe/FILE */
 int pipe_error;            /* Do we have a pipe error */
/*
//YB:  Explicit declear as __cdecl
*/
#ifdef WIN32
 void (__cdecl *orig_pipe_error_handler)();  /* The original handler for the signal that we remove 
                                         occasionally while we do something */
#else
 S_sig (*orig_pipe_error_handler)();  /* The original handler for the signal that we remove 
                                         occasionally while we do something */
#endif

 device *dev;
} SPost_Attrs;


#define POST_LOCAL_PARAMETERS_SIZE sizeof(SPost_Attrs)
#define POST_DFLT_NAME "Postscript Graphics Device"


#endif
