/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: classes.h,v $: $Revision: #8 $, $Date: 2006/06/26 $  */
#ifndef S_CLASS_H
#define S_CLASS_H 1

#include "S_classes.h"

#ifdef __cplusplus
extern "C" {
#endif
extern int path_table_multiplier;
extern int nClassesDefined;

/* s_methods_table is a structure to keep the processed */
/* information enabling a method definition to be located quickly */
/* It has an index lookup table for signature selection, plus the */
/* triples of methods for tests, if any, plus default */
/* the default method if any is stored directly in the structure */
struct s_methods_table{
  s_index_table *table;
  s_object **methods; /* by signature, including the default */
  s_name_table **m_names; /* the local variables if != arg_names_table */
  s_index *databases;
  int *positions;
  s_object **sigs;
  s_index *keys;
  int nSigMethods;
  int maxSigMethods;
  int *args;
  s_name **argNames;
  s_boolean *usedArgs; /* which arguments actually used in signatures */
  int nargs;
  int nclasses; /* no. of classes used to multiply indices for sig's*/
  char *mname;
  s_name *generic_name;
  s_object *dot_generic;
  s_name *group_name;
  s_object *generic_def;
  s_name_table *args_table; /* the names table for the formal args*/
  int n_variables; /* the (max) no. of variable in any method */
  int has_group_methods; /* set when methods are inferred from a group*/
			    /* generic.  See db_adjust_methods */
  s_boolean standard_body; /* uses the .Call to S_c_use_method */
  s_object *generic_body;
  int frame; /* the primary storage frame for this generic */
  s_object *old_methods; /* the UseMethod command, if using OldSD methods*/
};


extern s_object *find_default_method(mtable *methods, s_name_table **m_names_p);
/* a structure to hold distance, method flags for is, as */
struct s_class_path_struct {
  s_class *to;
  double dist;
/* WHEN THIS WORKS:  make a union of (test, coerce) with between */
  s_object *test;
  s_object *coerce;
  s_object *replace;
  s_class *by1; /* first between class */
  s_class *byn; /* last between class */
  int offset;
  long next; /* pos of next `to' path for this `from' class */
};

/* standard distance larger than 1*test!=0 + 2 * coerce!=0 */
#define STANDARD_PATH_DIST 4.
#define NEXT_PATH(p) (((p)->next < 0) ? NULL : (path_data + (p)->next))
#define INDIRECT_PATH -1 /* a value for the offset */
#define CONTAINS_PATH(cl) ((cl)->contains > 0 ? (path_data + \
			   (cl)->contains - 1) : NULL)
extern s_class_path *path_data;
#define PATH_INDEX(f, t) ((f) + ((t)-1)*path_table_multiplier)
extern boolean inherits_directly(s_class *from, s_class *to, 
  s_evaluator *S_evaluator);

extern s_object *standardIsTest_dummy;
extern s_class **get_old_inheritance(int i);
extern s_object *all_is_classes(s_class *cl);
extern s_object *method_sig_signature(s_class **argClass, int nargs, s_object
                        **argValues, mtable *table);
extern s_boolean needs_coerce_for_dispatch(s_class *from, s_class *to, int level);


/* structure to keep old-style inheritance patterns */
extern s_class ***oldInheritance;
extern s_object **oldAsChar;  extern int nOldClasses;
#define OLD_INHERITANCE(cl) get_old_inheritance(cl->index)
#define VIRTUAL_CLASS_INDEX(i) Classes_structs[(i)-1]->Virtual

extern s_class **Classes_structs;
extern s_name_table *All_classes;
extern s_class *s_CLASS_class;

extern int meta0_db_pos; /* used in class structures for token classes */

extern s_name_table Undef_name_table; /* point to here if name_table needs computing*/
#define UNDEF_NAME_TABLE &Undef_name_table



/* pointer to coerce as a generic. It behaves specially in methods
   search */
extern mtable *coerce_gen;
extern s_index self_coerce_key;

/* the values for the complete slot in the class structure */
enum s_class_complete {REP_NOT_FOUND, REP_FOUND, REP_UNSET};

extern s_boolean Classes_unset;
extern s_object *s_unset_class(s_object *x);
#ifdef __cplusplus
}
#endif
#endif

