/**************************************************************************/
#if !defined(_IM_TREE_H_)
#define _IM_TREE_H_

#include "IMObjects.h"

#define IMinerTreeModel IMinerObject

#define IMINER_TREE_META_DATA_NUM			0
#define IMINER_TREE_CLASSIFICATION_NUM		1
#define IMINER_TREE_LEVELS_NUM				2
#define IMINER_TREE_MAX_COMPARISON_NUM		3
#define IMINER_TREE_DEP_LEVELS_NUM			4
#define IMINER_TREE_DESCRIPTION_NUM			5

#define TREE_NODE_NUM						0
#define TREE_COLUMN							1
#define TREE_OPERAT							2
#define TREE_OPVALU							3

#define TREE_NA								-1
#define TREE_E								0
#define TREE_LT								1
#define TREE_LTE							2
#define TREE_GT								3
#define TREE_GTE							4

/* macro to access a matrix element from IMinerMatrix object*/
#define IMINER_TREE_GET_COUNT(model)					(model)->m_nLen-IMINER_TREE_DESCRIPTION_NUM
#define IMINER_TREE_PTR(pObj, i)						(pObj)->m_uData.m_ppList[i]
#define IMINER_TREE_META_DATA(model)					IMINER_TREE_PTR(model, IMINER_TREE_META_DATA_NUM)
#define IMINER_TREE_CLASSIFICATION(model)				IMINER_TREE_PTR(model, IMINER_TREE_CLASSIFICATION_NUM)
#define IMINER_TREE_LEVELS(model)						IMINER_TREE_PTR(model, IMINER_TREE_LEVELS_NUM)
#define IMINER_TREE_MAX_COMPARISONS(model)				IMINER_TREE_PTR(model, IMINER_TREE_MAX_COMPARISON_NUM)
#define IMINER_TREE_DEP_LEVELS(model)					IMINER_TREE_PTR(model, IMINER_TREE_DEP_LEVELS_NUM)
#define IMINER_TREE_DESCRIPTION(model, i)				IMINER_TREE_PTR(model, i+IMINER_TREE_DESCRIPTION_NUM)

#define IMINER_TREE_NODE_NUM(pObj, node)				IMINER_Aij(pObj, node, TREE_NODE_NUM)
#define IMINER_TREE_NODE_COLUMN(pObj, node)				IMINER_Aij(pObj, node, TREE_COLUMN)
#define IMINER_TREE_NODE_OPERATOR(pObj, node)			IMINER_Aij(pObj, node, TREE_OPERAT)
#define IMINER_TREE_NODE_OPVALUE(pObj, node, i)			IMINER_Aij(pObj, node, TREE_OPVALU+i)
#define IMINER_TREE_NODE_SCORE(pObj, node, nOpVals)		IMINER_Aij(pObj, node, TREE_OPVALU+nOpVals)
#define IMINER_TREE_NODE_PROB(pObj, node, nOpVals, p)	IMINER_Aij(pObj, node, p+TREE_OPVALU+nOpVals+1)


#ifdef __cplusplus
extern "C" {
#endif

/* alloc memory and set content for class KMeans Cluster */
IMCSRC_DLLAPI(long) IMinerTreeModel_create(
 IMinerObject* pModel,		    /* out: data object */
 IMinerObject* md,			    /* in:  meta data object */
 long nTrees,					/* in:  number of trees */
 long nLevels,					/* in:  number of levels output */
 long nMaxComps,				/* in:  max number of comparison values for a split */
 long *nNodes,					/* in:  number of nodes in tree of length (nTrees) */
 const double *pdNodeNums,		/* in:  node numbers of length (nTrees*nNodes[tree]) */
 const double *pdColumns,		/* in:  column to make comparison with of length (nTrees*nNodes[tree]) */
 const double *pdOpTypes,		/* in:  type of operation for split of length (nTrees*nNodes[tree]) */
 const double *pdOpValues,		/* in:  value to compare for split of length (nTrees*nNodes[tree]*nMaxComps) */
 const double *pdProbs,			/* in:  output probabilities for node of length (nTrees*nNodes[tree]*nLevels) */
 const double *pdScores,		/* in:  node score of length (nTrees*nNodes[tree]) */
 const char **pcDepLevels		/* in:  dependent levels if categorical (nLevels) */
);

/* validate the object */
IMCSRC_DLLAPI(long) IMinerTreeModel_isValid(const IMinerObject* pModel);

/* free memory */
IMCSRC_DLLAPI(long) IMinerTreeModel_destroy(IMinerObject* pModel );

/* write to stdout */
IMCSRC_DLLAPI(long) IMinerTreeModel_print(const IMinerObject* pModel);

/* predict cluster memberships */
IMCSRC_DLLAPI(long) IMinerTreeModel_predict(
 IMinerObject* pOutput,      /* out: output rectangular data */
 const IMinerObject* pInput, /* in: input rectangular data */
 IMinerObject* pDescr,		 /* in: input description (if NULL, description will be 
                                    created from input data) */
 const IMinerObject* pModel  /* in: the model */
);

#ifdef __cplusplus
}
#endif

#endif /*_IM_TREE_H_ */

