/* prediction for principal components */
#include "IMObjects.h"
#include "IMPrincipalComponents.h"
/* 
 An example of a program that calls IMinerPrincipalComponentsModel_predict() for prediction.
 This program reads data represented the model from a file generated by IMiner.

 Compiling and running:
	1. Change the current directory to the one containing this file. 
		cd <directory containing this file> 

	2. Edit main.c to create input data.

	3. Compile and link these files : 
		main.c, IMObjects.c, IMPrincipalComponents.c

	4. Run the program:
*/

int IMiner_get_input_data(IMinerObject *rectDataInput, int args, char *argv[]);

int main(int argc, char *argv[])
{
	IMinerObject rectDataInput, generatedModel, dataOutput;
	long nStatus;

	/*****************************************************************************/
	/* ARGS SHOULD CONTAIN THE LOCATION OF THE MODEL CREATED BY INSIGHTFUL MINER */
	/*****************************************************************************/
	if(argc < 2)
	{
		printf("This program requires at least one argument:\n");
		printf("model.txt location anything else is passed on\n");
		printf("to create the input.  Please see readme.txt");
		exit(1);
	}
	if(access(argv[1], 04) !=0)
	{
		printf("Cannot open file %s for read\n", argv[1]);
		exit(1);
	}


	/******************/
	/* GET INPUT DATA */
	/******************/
	nStatus = IMiner_get_input_data(&rectDataInput, argc-2, (argc-2>0) ? &argv[2] : 0);
	if(nStatus !=IMINER_SUCCESS)
	{
		printf("Failure to create input data, nStatus=%d\n", nStatus);
		exit(1);
	}


	/**************************************************************************/
	/* GET MODEL CREATED BY INSIGHTFUL MINER FROM FILE DESCRIBED IN PARAMETER */
	/**************************************************************************/
	nStatus = IMinerObject_createFromFile(&generatedModel, argv[1]);
	if(nStatus !=IMINER_SUCCESS)
	{
		printf("Failure in IMinerObject_createFromFile(), nStatus=%d\n", nStatus);
		exit(1);
	}


	/**************/
	/* PREDICTION */
	/**************/
	nStatus = IMinerPrincipalComponentsModel_predict(&dataOutput, &rectDataInput, 0, &generatedModel);


	/**********************************/
	/* OUTPUT RESULTS TO STANDARD OUT.*/
	/**********************************/
	if(nStatus !=IMINER_SUCCESS)
	{
		printf("Failure in IMinerPrincipalComponentsModel_predict(), nStatus=%d\n", nStatus);
		exit(1);
	}
	printf("-------------- model ----------------:\n");
	IMinerPrincipalComponentsModel_print(&generatedModel);
	printf("------------ input object ----------------:\n");
	IMinerDataSet_print(&rectDataInput);
	printf("------------ output object ----------------:\n");
	IMinerDataSet_print(&dataOutput);

	/*************************************/
	/* DESTROY OBJECTS TO RELEASE MEMORY */
	/*************************************/
	IMinerObject_destroy(&generatedModel);
	IMinerObject_destroy(&rectDataInput);
	IMinerObject_destroy(&dataOutput);

}

int IMiner_get_input_data(IMinerObject *rectDataInput, int args, char *argv[]) 
{
	/********************/
	/* DEFINE DATA HERE */
	/********************/	
	long numberOfColumns=0;	/* NUMBER OF COLUMNS IN DATASET */
	long numberOfRows=0		/* NUMBER OF ROWS IN DATASET */;  
	long *columnTypes=0;	/* COLUMN TYPE OF EACH COLUMN: IMINER_MODE_STRING or IMINER_MODE_DOUBLE (size: [numberOfColumns]) */
	char **columnNames=0;	/* NAMES OF EACH COLUMN IN DATASET (size: [numberOfColumns]) */
	void **data=0;			/* ACTUAL DATA IN DATASET (size: [numberOfColumns][numberOfRows])
							   COLUMNS MUST EITHER BE (double*) or (char**) */

	
	/******************************************/
	/* CREATE IMINER_DATASET OBJECT FROM DATA */
	/******************************************/
	return IMinerDataSet_createFromInput(rectDataInput, numberOfRows, 
										 numberOfColumns, columnTypes, 
										 columnNames, data);
}
