<?xml version='1.0' encoding='UTF-8' ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- XSL style sheet for PrincipalComponents element -->

	<xsl:template match="XML">
		<xsl:apply-templates select="IMML"/>
	</xsl:template>

	<xsl:template match="IMML">
		<html>
			<title>
				<xsl:value-of select="DisplayOptions/@title"/>
			</title>
			<style type="text/css">
				<xsl:value-of select="CSSText/text()"/>
			</style>
			<body>
				<div><h1>
					<xsl:value-of select="DisplayOptions/@title"/>
				</h1></div>
				<xsl:apply-templates select="PrincipalComponentsModel"/>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="PrincipalComponentsModel">
		<xsl:apply-templates select="PrinComp"/>
		<xsl:apply-templates select="Parameters"/>
	</xsl:template>

	<xsl:template match="PrinComp">
		<xsl:variable name="decimalPattern" select="../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../DisplayOptions/@scientificPattern"/>

		<br></br>
		<div>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<H3 class="tableHead">Loadings</H3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
								<th class="blueBG"><xsl:text>  </xsl:text></th>
								<th class="blueBG"><xsl:text> Variance </xsl:text></th>
								<th class="blueBG"><xsl:text> Cumulative % </xsl:text></th>

								<xsl:for-each select="Component">
									<xsl:if test="position()=1">
										<xsl:for-each select="Loading">
											<th class="blueBG"><xsl:value-of select="@variable" /></th>
										</xsl:for-each>
									</xsl:if>
									<xsl:element name="tr">
										<xsl:attribute name="class">
											<xsl:choose>
												<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
												<xsl:otherwise>greyBG</xsl:otherwise>
											</xsl:choose>
										</xsl:attribute>

										<th style="text-align:right font-weight:bolder">
											<xsl:value-of select="@name"/>
										</th>
										<th style="text-align:right font-weight:bolder">
											<xsl:value-of select="format-number(@variance, $decimalPattern)"/>
										</th>
										<th style="text-align:right font-weight:bolder">
											<xsl:value-of select="format-number(@cumPercent, $decimalPattern)"/>
										</th>
										<!-- cell -->
										<xsl:for-each select="Loading">
											<td style="text-align:right" nowrap="true">
												<xsl:call-template name="roundNumber">
														<xsl:with-param name="string" select="@value" />
														<xsl:with-param name="decimalPattern" select="$decimalPattern" />
														<xsl:with-param name="scientificPattern" select="$scientificPattern" />
												</xsl:call-template>
											</td>
										</xsl:for-each>
									</xsl:element>
								</xsl:for-each>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</xsl:template>

	<xsl:template match="Parameters">
		<br></br>
		<DIV>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<H3 class="tableHead">Variable Parameters</H3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
								<th class="blueBG"><xsl:text> Variable </xsl:text></th>
								<th class="blueBG"><xsl:text> Center </xsl:text></th>
								<th class="blueBG"><xsl:text> Scale </xsl:text></th>

								<xsl:apply-templates select="Param"/>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</DIV>
	</xsl:template>

	<xsl:template match="Param">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="tr">
			<xsl:attribute name="class">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
					<xsl:otherwise>greyBG</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<th align="left"> <xsl:value-of select="@variable"/></th>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@center" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@scale" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
		</xsl:element>
	</xsl:template>

	<xsl:template name="roundNumber">
		<xsl:param name="string" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />

	   	<xsl:variable name="lowerCasePattern" select="'e'" />
	   	<xsl:variable name="upperCasePattern" select="'E'" />

		<xsl:choose>
		      <xsl:when test="contains($string, $lowerCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $lowerCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $lowerCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:when test="contains($string, $upperCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $upperCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $upperCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:otherwise>
		      	 <xsl:choose>
				<xsl:when test="format-number($string, $decimalPattern) != format-number(0, $decimalPattern)">
					<xsl:value-of select="format-number($string, $decimalPattern)"/>
				</xsl:when>
				<xsl:when test="$string = 0">
					<xsl:value-of select="format-number($string, $decimalPattern)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="format-number($string, $scientificPattern)"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>  </xsl:text>
		      </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="outputRoundedScientific">
		<xsl:param name="valueString" select="''" />
		<xsl:param name="exponentString" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:value-of select="format-number($valueString, $decimalPattern)" />E<xsl:value-of select="format-number($exponentString, '#0')"/>
	</xsl:template>

</xsl:stylesheet>
