florida.votes.scatter <- function(county="jackson"){

###########################################################################
###
### florida.votes.scatter: Produce a scatterplot, with regression line
###                        for the 2000 Presidential Election votes
###                        for the counties in Florida.              
###             
### Arguments:
###
### county:    The selected county. 
###
###########################################################################

## Strip out any "%20" characters passed in the county name.
county <- token(source=county)

				       
## Get the data for this county
idx <- row.names(florida) == county

##Set a special java color scheme
java.set.colorscheme(jc.votes)

## Produce an empty plot
plot(florida$BUSH, florida$BUCHANAN, xlab="Bush votes",
     ylab="Buchanan votes", type="n")

  ## add regression line and scatter plot
  fit.bush <- lmRobMM(BUCHANAN ~ BUSH -1,data=florida)
  extra.bush <- buch.votes - predict(fit.bush)["PALM BEACH"]
  abline(c(0,coef(fit.bush)),col=12)
  points(florida$BUSH, florida$BUCHANAN)

## Highlight current County
  points(florida$BUSH[idx],florida$BUCHANAN[idx],pch=16,col=7,cex=1.5)

## Add titles to the plot
title("Bush/Buchanan votes in Florida counties")
title(sub=paste(county," county highlighted: Click on any point for county results"),col=5)

## Set up action locations and action strings
  java.identify(florida$BUSH, florida$BUCHANAN,
		labels=paste("County:",row.names(florida)),
		action=paste(
		  '<menu title="', 'States of the USA', '">',
		  '<menuitem label="Barplot of Votes">',
		  MakeAction(florida.barplot,county=row.names(florida)),
		  '</menuitem>',
		  '<menuitem label="Back to County Map">',
		  MakeAction(map.counties,state="Florida"),
		  '</menuitem>',
		  '</menu>'))

  
## Annotate the plot highlighting Palm Beach Outlier
lines(c(115485,145364),c(2870,3249),col=2)
text(115485,2870,"\nBuchanan votes in Palm Beach
(Click on point to see votes)",col=2)

}

florida.barplot <- function(county="jackson"){

###########################################################################
###
### florida.barplot: Produce a barplot of the 2000 Presidential Election 
###                  votes for the setected county in Florida.              
###             
### Arguments:
###
### county:    The selected county. 
###
###########################################################################


  ## Strip out any "%20" characters
  county <- token(source=county)

  ## Set a special colorscheme
  java.set.colorscheme(jc.votes)

  ## Define the possible candidates
  candidate <- rev(c("BUSH","GORE","NADER","BUCHANAN"))
  n <- length(candidate)

  ##  Set plotting parameters (see help for par())
  oldpar <- par(oma=c(4,7,3,5))
  
  ## Set up the results data frame
  county.results <- data.frame(vote=c(t(florida[county,candidate[1:4]])),
      candidate=candidate[1:4])

  ## print(barchart(candidate ~ vote, data=county.results))
  yvals <- barplot(height=county.results$vote,names=as.character(county.results$candidate), 
      horiz=T, col=rev(c(7,3,8,9)),xaxs="e")

  ## Add a title
  title(paste("Votes in",county,"county"))
  
  ## Define active areas
  x1 <- rep(par()$usr[1],4)
  x2 <- rep(par()$usr[3],4)
  y1 <- yvals
  y2 <- yvals

  ## Set up action strings
  java.identify(x1=x1, x2=x2, y1=y1, y2=y2,	 labels=candidate,
	       actions = paste(
			'<menu title="', 'States of the USA', '">',
			'<menuitem label="Bush-Buchanan Regression">',
				MakeAction(florida.votes.scatter,county=county),
			'</menuitem>',
			'<menuitem label="Back to County Map">',
				MakeAction(map.counties,state="Florida"),
			'</menuitem>',
			'</menu>'))

  ##  reset plotting parameters
  par(usr=c(0,1,0,1))
}
