import com.insightful.splus.*;

public class CorrelationExample {

  // static fields to pass values to S-PLUS 
  public static double [] xValue;
  public static double [] yValue;

  // Java function calling S-PLUS to compute correlation
  // of two double arrays.  This can be called from other
  // classes.
  //
  // Throw an IllegalArgumentException if x or y
  // inappropriate.
  // Pass on other exceptions if they are thrown.

  public static double getCorrelation(double [] x, 
    double [] y) throws IllegalArgumentException,
      SplusBadDataException, java.rmi.RemoteException {

	 if (x == null || x.length == 0 || 
	     y == null || y.length == 0)
	   throw (new IllegalArgumentException(
	       "Argument is null or length zero."));

	 xValue = x;
	 yValue = y;

	 // Define the S-PLUS expression to use.  
	 // Note we use \" for quotes within the expression.
	
	 String expression = "cor(" +
		".JavaField(\"CorrelationExample\", " +
		"\"xValue\", \"[D\", client = T)," +
		".JavaField(\"CorrelationExample\", " +
		"\"yValue\", \"[D\", client = T))";

	 SplusDataResult result = 
	   SplusUserApp.eval(expression + "\n");

	 return result.getDoubleData()[0];
  }

  public static void main(String [] args){

    // Create some double arrays and get their correlations.

    double [] a = {2.1, 3.5, 8.4, 5.3, 6.8};
    double [] b = {9.8, 3.7, 2.1, 8.3, 6.5};

    System.out.println(
      "Getting correlation of two double arrays.");
    
    try {
      double d = CorrelationExample.getCorrelation(a, b);
      System.out.println("Correlation is: " + d);
    }
    catch (Exception e){
      System.out.println(e);
    }
    System.exit(0);
  }

}

