# y'=f(t,y): a spiral
f<-function(t, y)
{
	r<-sqrt(sum(y^2))+t/1000
	r*c(cos(t), -sin(t))
}

"euler" <-
## First order method for solving an ODE
# REQUIRED ARGUMENTS: 
#  fun    function name or the function
#  tStart inital value for t
#  tStop  end value for t
#  yStart inital value for y
#  nSteps numeber of steps
# 
# VALUE: 
#  a vector y, solution of y'=f(y,t) 
# Usage:
# sys.time({y1<-euler(f, c(0,1), 0.0, 30*pi, 3000)})
# plot(y1[1,],y1[2,])
function(fun, yStart, tStart, tStop, nSteps)
{
	# Validate input argments
	if(is.character(f))
		f = getFunction(f)
	y = as.numeric(yStart)
	t = as.numeric(tStart)
	tStop = as.numeric(tStop)
	nSteps= as.integer(nSteps)

	# Create the return object
	ans = matrix(0.0, length(y), nSteps)
	ans[,1] = y;

	# Step size
	h = (tStop - t)/as.numeric(nSteps);

	# Euler iterations
	for( j in 2:nSteps)
	{
		y = y + h * f(t, y)
		t = t + h
		ans[,j] = y
	}
	return(ans)
}

## Test

# sys.time({y<-euler(f, c(0,1), 0.0, 30*pi, 3000)})
# sys.time({z<-.Call("euler", f, c(0,1), 0.0, 30*pi, 3000)})
# all.equal(y, z)
