/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

	spcall.h: interface for the CSPcall class.
*/

#if !defined(__SCONNECT_SPCALL_H_INCLUDED__)
#define __SCONNECT_SPCALL_H_INCLUDED__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "spfunc.h"
#include "spchar.h"
#include "splist.h"

class CSPnamed; //Forward

class SCONNECT_LIB_EXTERN CSPcall : public CSPlanguage  
{
//////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////
public:
	//Default constructor
	CSPcall();
	//Copy constructor: copy appropriate data members
	CSPcall(const CSPcall& sObject);
	//Construct from object of a base class
	CSPcall(const CSPobject& sObject);
	//Special! Construct from a valid S-expression is not useful for a call class
		//explicit CSPcall(const char* pszExpression);
	//Construct frmo an S object pointer  
	explicit CSPcall(s_object* ps_object, BOOL bTryToFreeOnDetach=FALSE);
	//Assign from the same class
	CSPcall& operator=(const CSPcall& sObject);
	//Assign from the base class
	CSPcall& operator=(const CSPobject& sObject);
	//Assign from an S object
	CSPcall& operator=(s_object* ps_object);
	//The destructor
	virtual ~CSPcall();

	//Construct a function call for the function name given by pszSFunctionName
	explicit CSPcall(const char* pszSFunctionName);
	//Use the first elem of char. vector as function name.
	explicit CSPcall(const CSPcharacter& scharFunctionNane);
	//Construct a call with a whole funtion definition.
	explicit CSPcall(const CSPfunction& sFunction);
	//Construct a call with one argument.
	CSPcall(const char* pszSFunctionName, s_object* ps_arg);
	CSPcall(const char* pszSFunctionName, const CSPobject& sArg);
	CSPcall(const CSPfunction& sFunction, s_object* ps_arg);
	CSPcall(const CSPfunction& sFunction, const CSPobject& sArg);
	//Construct a call with a list of arguments.
	CSPcall(const char* pszSFunctionName, const CSPlist& slistArgs);
	CSPcall(const char* pszSFunctionName, const CSPlistNamed& slistNamedArgs);
	CSPcall(const CSPfunction& sFunction, const CSPlist& slistArgs);
	CSPcall(const CSPfunction& sFunction, const CSPlistNamed& slistNamedArgs);
	//Create an S object and attach via the virtual member function Attach() which expect to coerce to required class
	virtual BOOL Create(const char* pszExpression,	const char* pszName,	long lDataBase)
	{
		return CSPobject::Create(pszExpression, pszName, lDataBase);
	}
	//Create a function call for the object of class char, function or call
	BOOL Create(const s_object* ps_object);
	//Create a function call for the function name given by pszSFunctionName
	BOOL Create(const char* pszSFunctionName);
	//Create a call with a whole funtion definition.
	BOOL Create(const CSPfunction& sFunction);
	//Create a call with one argument.
	BOOL Create(const char* pszSFunctionName,  s_object* ps_arg);
	BOOL Create(const char* pszSFunctionName,  const CSPobject& sArg);
	BOOL Create(const CSPfunction& sFunction, s_object* ps_arg);
	BOOL Create(const CSPfunction& sFunction, const CSPobject& sArg);
	//Create a call with a whole funtion definition and a list of arguments.
	BOOL Create(const char* pszSFunctionName, const CSPlist& slistArgs);
	BOOL Create(const CSPfunction& sFunction, const CSPlist& slistArgs);
//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
public:
	//Attach an S object and coerce to appropriate class that override this method
	virtual void Attach(s_object *ps_object, BOOL bTryToFreeOnDetach=FALSE);
 	void SetArg(s_object* ps_Argument, long lPosition=1, const char* pszName=NULL);
	void SetArgName(long lPosition, const char* pszName);
	void SetArg(const char* pszArgument, long lPosition=1, const char* pszName=NULL);
	void SetArg(double dArgument, long lPosition=1, const char* pszName=NULL);
	void SetArg(long lArgument, long lPosition=1, const char* pszName=NULL);
	void SetArgs(const CSPlist& slistArgs);
	void SetArgs(const CSPlistNamed& snamedArgs);

	void SetArgDirect(s_object* ps_Argument, long lPosition=1);
  CSPobject GetArg(long lPosition=1L, BOOL bValidate=TRUE) const;

	void AddArgs(const CSPlist& slistArgs);
	void AddArgs(const CSPlistNamed& snamedArgs);
	virtual CSPobject Eval(long lFrame) const     //Eval in lFrame 
	{
		return CSPlanguage::Eval(lFrame);
	}
	virtual CSPobject Eval(const CSPnamed& sArgs) const              //Eval in current eval frame
	{
		return CSPlanguage::Eval(sArgs);
	}
	virtual CSPobject Eval(const CSPnamed& sArgs, long lFrame) const//Eval in current eval frame
	{
		return CSPlanguage::Eval(sArgs, lFrame);
	}

	//Evaluate S-function call with current arguments stored in the call object
	virtual CSPobject Eval(void) const;
	//Evalute the S-function with a CSPlist or CSPlistNamed, 'named' of mode S_MODE_LIST, argument
	virtual CSPobject Eval(const CSPlist& slistArgs) const;
	CSPobject Eval(const CSPlistNamed& slistNamedArgs) const
	{
		return Eval(CSPlist(slistNamedArgs));
	}
	//Evaluate the S-funciton call with its 1st, 2nd, ... arguments specified by the input parameter, sArg1, sArg2, ...
	CSPobject Eval(s_object*       ps_1, s_object*  ps_2=NULL, s_object*   ps_3=NULL, s_object*  ps_4=NULL, s_object* ps_5=NULL,
                 s_object*  ps_6=NULL, s_object*  ps_7=NULL, s_object*   ps_8=NULL, s_object*  ps_9=NULL, s_object* ps_10=NULL,
                 s_object* ps_11=NULL, s_object* ps_12=NULL, s_object*  ps_13=NULL, s_object* ps_14=NULL, s_object* ps_15=NULL,
                 s_object* ps_16=NULL, s_object* ps_17=NULL, s_object*  ps_18=NULL, s_object* ps_19=NULL, s_object* ps_20=NULL,
                 s_object* ps_21=NULL, s_object* ps_22=NULL, s_object*  ps_23=NULL, s_object* ps_24=NULL, s_object* ps_25=NULL,
                 s_object* ps_26=NULL, s_object* ps_27=NULL, s_object*  ps_28=NULL, s_object* ps_29=NULL, s_object* ps_30=NULL,
								 s_object* ps_31=NULL) const;
	inline CSPobject operator()(void) const
	{ 
		return Eval();
	}
	inline CSPobject operator()(const CSPlist& slistArgs) const
	{ 
		return Eval(slistArgs);
	}
	inline CSPobject operator()(const CSPlistNamed& slistNamedArgs) const
	{ 
		return Eval(slistNamedArgs);
	}
	inline CSPobject operator()
								(s_object*       ps_1, s_object*  ps_2=NULL, s_object*   ps_3=NULL, s_object*  ps_4=NULL, s_object* ps_5=NULL,
                 s_object*  ps_6=NULL, s_object*  ps_7=NULL, s_object*   ps_8=NULL, s_object*  ps_9=NULL, s_object* ps_10=NULL,
                 s_object* ps_11=NULL, s_object* ps_12=NULL, s_object*  ps_13=NULL, s_object* ps_14=NULL, s_object* ps_15=NULL,
                 s_object* ps_16=NULL, s_object* ps_17=NULL, s_object*  ps_18=NULL, s_object* ps_19=NULL, s_object* ps_20=NULL,
                 s_object* ps_21=NULL, s_object* ps_22=NULL, s_object*  ps_23=NULL, s_object* ps_24=NULL, s_object* ps_25=NULL,
                 s_object* ps_26=NULL, s_object* ps_27=NULL, s_object*  ps_28=NULL, s_object* ps_29=NULL, s_object* ps_30=NULL,
								 s_object* ps_31=NULL) const
	{
		return Eval(ps_1,   ps_2,   ps_3,   ps_4,   ps_5,
                ps_6,   ps_7,   ps_8,   ps_9,  ps_10,
                ps_11, ps_12,  ps_13,  ps_14,  ps_15,
                ps_16, ps_17,  ps_18,  ps_19,  ps_20,
                ps_21, ps_22,  ps_23,  ps_24,  ps_25,
                ps_26, ps_27,  ps_28,  ps_29,  ps_30,
								ps_31);	
	}
	inline CSPobject Eval(const CSPobject& sArg1) const
	{ return Eval(&sArg1); }
	inline CSPobject operator()(const CSPobject& sArg1) const
	{ return Eval(&sArg1); }
	inline CSPobject Eval(const CSPobject& sArg1, const CSPobject& sArg2) const
	{ return Eval(&sArg1, &sArg2); }
	inline CSPobject operator()(const CSPobject& sArg1, const CSPobject& sArg2) const
	{ return Eval(&sArg1, &sArg2); }
	inline CSPobject Eval(const CSPobject& sArg1, const CSPobject& sArg2, const CSPobject& sArg3) const
	{ return Eval(&sArg1, &sArg2, &sArg3); }
	inline CSPobject operator()(const CSPobject& sArg1, const CSPobject& sArg2, const CSPobject& sArg3) const
	{ return Eval(&sArg1, &sArg2, &sArg3); }
	inline CSPobject Eval(const CSPobject& sArg1, const CSPobject& sArg2, const CSPobject& sArg3, const CSPobject& sArg4) const
	{ return Eval(&sArg1, &sArg2, &sArg3, &sArg4); }
	inline CSPobject operator()(const CSPobject& sArg1, const CSPobject& sArg2, const CSPobject& sArg3, const CSPobject& sArg4) const
	{ return Eval(&sArg1, &sArg2, &sArg3, &sArg4); }

};

#endif // !defined(__SCONNECT_SPCALL_H_INCLUDED__)
