/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

	spchar.h: interface for the CSPcharacter class.
*/

#if !defined(__SCONNECT_SPCHAR_H_INCLUDED__)
#define __SCONNECT_SPCHAR_H_INCLUDED__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "spvector.h"
class SCONNECT_LIB_EXTERN CSPcharacter : public TSPvector<char*, S_MODE_CHAR>  
{
//////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////
public:
	//Default constructor
	CSPcharacter();
	//Copy constructor: copy appropriate data members
	CSPcharacter(const CSPcharacter& sObject);
	//Construct from object of a base class
	CSPcharacter(const CSPobject& sObject);
	//Construct from a valid S-expression
	explicit CSPcharacter(const char* pszExpression);
	//Construct frmo an S object pointer  
	explicit CSPcharacter(s_object* ps_object, BOOL bTryToFreeOnDetach=FALSE);
	//Assign from the same class
	CSPcharacter& operator=(const CSPcharacter& sObject);
	//Assign from the base class
	CSPcharacter& operator=(const CSPobject& sObject);
	//Assign from an S object
	CSPcharacter& operator=(s_object* ps_object);
	//The destructor
	virtual ~CSPcharacter();

	//Construct with a specified length 
	explicit CSPcharacter(long lLength); 
	explicit CSPcharacter(int nLength);  
	//Construct from an arrary of char string
	explicit CSPcharacter(char** ppszValues, long lLength=1);

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
public:
	//Proxy to assist indexing operator for lvalue/rvalue, type conversions and ref count.
	class SCONNECT_LIB_EXTERN CProxy : public TSPvector<char*, S_MODE_CHAR>::CSPvectorProxy
	{
	public:
		CProxy(CSPcharacter& sVector, long lZeroBasedIndex);
		CProxy( const CProxy& proxyRhs );
		CProxy& operator=(const CProxy& proxyRhs);
		CProxy& operator=(const char* pszRhs);		
		BOOL operator!=(const char* pszRhs) const;
		BOOL operator==(const char* pszRhs) const;
		friend class CSPcharacter;
	};
	//CSPcharacter continue ... 
	CSPcharacter& operator=(const CProxy& proxyRhs);
	//Subscripting, C style zero-based and Fortran one-based-indexing: must over-load all required [] and ().
	const char* operator[](int nZeroBasedIndex) const //rvalue only
	{ return MyTypeValue(GetPtr(), nZeroBasedIndex);}
	CProxy operator[](int nZeroBasedIndex)//both lvalue and rvalue     
	{ return CProxy(*this, nZeroBasedIndex);}
	//Subscripting, Fortran style and one-based-indexing
	const char* operator()(int nOneBasedIndex) const 
	{ return MyTypeValue(GetPtr(), nOneBasedIndex-1L);}
	CProxy operator()(int nOneBasedIndex)            
	{ return CProxy(*this, nOneBasedIndex-1);}
	//long arguments are needed to avoid ambiguity between int and operator s_object*()
	const char* operator[](long lZeroBasedIndex) const 
	{	return MyTypeValue(GetPtr(), lZeroBasedIndex);}
	CProxy operator[](long lZeroBasedIndex)            
	{	return CProxy(*this, lZeroBasedIndex);}
	const char* operator()(long lOneBasedIndex) const 
	{ return MyTypeValue(GetPtr(), lOneBasedIndex-1L);}
	CProxy operator()(long lOneBasedIndex)            
	{ return CProxy(*this, lOneBasedIndex-1);}

	//set elements of a character vector
	void SetAt(long lIndex, const char* pszValue, BOOL bValidate=TRUE);
	void SetAt(char** ppszValues, long lStartIndex, long lEndIndex, BOOL bValidate);
	//Direct access to elements of character vector (ZERO-BASED INDEX). Use it carefully!
	void SetAtDirect(long lIndex, const char* pszValue, BOOL bValidate=TRUE, BOOL bRemovableStrings=TRUE);
	void SetAtDirect(char** ppszValues, long lStartIndex, long lEndIndex, BOOL bValidate=TRUE, BOOL bRemovableStrings=TRUE);
	long Add( const char *pszElement, BOOL bValidate=TRUE );
	long Append(char **ppszElements, long lElements, BOOL bValidate=TRUE);
//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
public:
	//Make the strings be removable
	void MakeStringsRemovable( BOOL bValidate=TRUE );
	//Return index (ZERO-BASED) for a given char string, return -1 if not found.
	long Find(const char* pszText, BOOL bValidate=TRUE) const;
	//Evaluate the text data stored in the "chararcter" object
	CSPobject Eval(void);
	//Parse the text and eval it as expression
	CSPobject ParseEval(void);

#ifdef WIN32
	#include "spchar_com.h"
#endif
};

#endif // !defined(__SCONNECT_SPCHAR_H_INCLUDED__)
