/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

	spengcon.h: interface for the CSPengineConnect class.
*/

#if !defined(__SCONNECT_SPENGCON_H_INCLUDED__)
#define __SCONNECT_SPENGCON_H_INCLUDED__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "spobject.h"
#include "engconstr.h"

class SCONNECT_LIB_EXTERN CSPengineConnect : public CSPobject  
{
//////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////
public:
	//Default constructor: does not thing, you have to call Create to realy make connection to the S+engine.
	CSPengineConnect(); 
	//Construct and create to realy make connection to the S+engine.
	CSPengineConnect(int argc, char* argv[], char *dlllist[]=NULL); 
	//Create a connection
	virtual int Create(
		int argc=0,             //array size of the next argument, argv
		char *argv[]=NULL,      //parameters such as S_HOME=e:/splus6
		char *dlllist[] = NULL, //list of dlls to be automatically loaded for .C, .Call, .Fotran, .Internal.
		unsigned int uSConnectFlags=S_CONNECT_DEFAULTAUTO, //set to auto-detect GUI/console use
		BOOL bUseNewIo = TRUE); //set to FALSE to connect to stdio with console application
	//destructor
	virtual ~CSPengineConnect();
private:
	//Supress this virtual method because it is not useful for this class
	virtual BOOL Create(const char* pszExpression,	const char* pszName,	long lDataBase)
	{
		return FALSE;
	}

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
public:
	virtual BOOL IsValid(void) const;
	CSPengineConnect* operator &() const { return (CSPengineConnect *)this;};
//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
public:
	// Parse and Evaluate an expression
	virtual int SyncParseEval(const char* pszExpression, s_object **warningList = NULL);
	virtual s_object * SyncParseEvalResult(const char *pszExpression, s_object **warningList = NULL);
	//Assign an S object to a perm. frame assoc. with a name.
	virtual void Assign(const char* pszName, const CSPobject& spObject, long lDataBase=1);
	//Suppress this virtual method to avoid bad usage.
private:
		virtual void Assign(const char* pszName, long lDataBase)
		{
			SCONNECT_ThrowException("No s object to assign for %s in database=%d", pszName, lDataBase);
		}
public:
	//Create an S object in a perm. frame and return an CSPobject*
	virtual s_object* CreateObject(
	  const char* pszClass,      //class name 
		const char* pszName,       //object name
		const char* pszExpression=NULL, //==NULL, uses the default constructor, else use the expression to instantiate it.
		long lDataBase=1);				//database
	//Find S object in the permanant frames: the first one in the search list will be returned.
	virtual s_object* Find(const char* pszName, BOOL bLocal=S_FALSE, BOOL bGetData=S_TRUE);

	virtual s_object* get(const char* pszName, BOOL bLocal=S_FALSE, BOOL bGetData=S_TRUE)
	{ return Find(pszName,  bLocal, bGetData); }
	//Accessing operation system file-handles for S+ standard in/out IO: stdout and stderr
	virtual long GetOSHdStdout(void) const {return m_lOsHdStdout;}
	virtual long GetOSHdStderr(void) const {return m_lOsHdStderr;}
  //Read text sent from the engine via stdout.
	virtual BOOL ReadStdout(
		char* pszBuffer,          // output data buffer 
		long  nBufferSize         // size of data buffer 
  ); 
  //Read text sent from the engine via stderr.
	virtual BOOL ReadStderr(
		char* pszBuffer,          // output data buffer 
		long  nBufferSize         // size of data buffer 
  );
	//Get the current active evaluator object.
	s_evaluator* GetCurrentEvaluator(void) const;
/********************************************************************
	OpenTopLevelEval
	Returns 0 :
		if your call has opened the evaluator and creates frame 1.  
		In his case you will want to close the evaluator via
		CloseTopLevelEval() when done with it or risk the chance that
		the evaluator will remain open indefinitely
	Returns the current frame number > 0 :
		if the evaluator is already open.  Generally you will not 
		want to call CloseTopLevelEval() since there may be other 
		objects relying on it being open.
	Returns -1
		if there was a failure to open the evaluator and frame 1 does
		not exist.

	Warning: explicit all to open the top-level-eval and close it via these methods
	are risky since pairs of OpenTopLevelEval/CloseTopLevelEval can easily be mismatch().
	See also: CSPevaluator.
********************************************************************/
	int OpenTopLevelEval(void) const
	{
		if ( GetCurrentEvaluator()->_eval_open )
			return GetCurrentEvaluator()->_Nframe;			
		long lError = 0;
		//Signal handling for serious errors
		if((lError=setjmp(GetCurrentEvaluator()->_S_error_jmp))!=0)
		{
			//invalidate member m_ps_object for all unnamed local objects
			//because their frames will be closed by eval_close below.
			CSPobject::UnnamedObjectMap_InvalidateLocalObjects((BOOL)lError);
			::eval_close(lError, GetCurrentEvaluator());
				throw CSPengineException();
		}
		::eval_init(GetCurrentEvaluator());

		return (GetCurrentEvaluator()->_eval_open?0:-1);
	}

	BOOL CloseTopLevelEval(void) const;

	//DLL search list functionality
	void DllSearchList_Set( char *dlllist[] );
	void DllSearchList_Add( char *pszDllName );
	void DllSearchList_Remove( char *pszDllName );
	void DllSearchList_RemoveAll();

	//Notification handlers 
	virtual int OnAttach( s_object* ps_attached );
	virtual int OnDetach( s_object* ps_attached );
	virtual int OnOutput( long iOutputFlags = 0 );
	virtual long OnNotifyOrQuery(
		long lMsg,        /* message Id */
		long lArgs,       /* number of args */
		void** ppArgs    /* content depends on lMsg with length lArgs */
	);
	virtual long OnAppNotify(long lMsg, long lArgs, void **ppArgs);
	virtual long OnAppQuery(long lMsg, long lArgs, void **ppArgs);
	virtual long OnEvalInput(long lMsg, long lArgs, void **ppArgs);
	virtual long OnCommandsHistory(long lMsg, long lArgs, void **ppArgs);
	virtual long OnPseudoProcess(long lMsg, long lArgs, void **ppArgs);
	virtual long OnAppHelp(long lMsg, long lArgs, void **ppArgs);
	virtual long OnSGraphics(long lMsg, long lArgs, void **ppArgs);
	virtual long OnAppSpecial(long lMsg, long lArgs, void **ppArgs);
	//ParseTest() parses to test the string. It returns status result.
	//The arg. pnCharParsed is length of char. sucessfully parsed.
	virtual int ParseTest(const char* pszExpression, long* plCharParsed);
private:
	//Data Members
	int m_uiRefTopLevelEval;
	long m_lOsHdStdout;	//standard output from the engine
	long m_lOsHdStderr;	//standard error from the engine
};

#endif // !defined(__SCONNECT_SPENGCON_H_INCLUDED__)
