/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
	
	spexpect.h: exception handlings
*/

#ifndef __SCONNECT_SPEXCEPT_H_INCLUDED__
#define __SCONNECT_SPEXCEPT_H_INCLUDED__

#include "spdefs.h"
#include <stddef.h>

struct s_object_struct;

#define SCONNECT_INVALID_SOBJECT "Invalid S-PLUS object"
#define SCONNECT_INVALID_ENGINE_CONNECTION "Invalid S-PLUS engine connection"
#define SCONNECT_ENGINE_EXCEPTION "Engine Exception"
#define SCONNECT_EVALUATOR_CLOSED "Evaluator is closed, no memory frame is available"
#define SCONNECT_EVALUATION_FAILURE "Expression evaluation failure"
#define SCONNECT_OBJECT_CREATION_FAILURE "Object creation failure"
#define SCONNECT_INVALID_DATABASE "Invalid S-PLUS database"
#define SCONNECT_COERCION_FAILURE "Object coercion failure"
#define SCONNECT_MEM_ALLOCATION_FALURE "Memory allocation failure"
#define SCONNECT_INVALID_CLASS "Invalid S-PLUS class"

SCONNECT_C_DLLAPI(void) SCONNECT_ThrowException(const char* lpszFormat, ...);
SCONNECT_C_DLLAPI(void) SCONNECT_Warning(const char* lpszFormat, ...);
SCONNECT_C_DLLAPI(void) SCONNECT_Print(const char* lpszFormat, ...);

SCONNECT_DLLAPI(void) SCONNECT_DoWarning(const char* pszMessage);
SCONNECT_DLLAPI(void) SCONNECT_DoPrint(const char* pszBuf);


/********************************************************************
	CSPexception
********************************************************************/
class SCONNECT_LIB_EXTERN CSPexception
{
public:
	typedef enum 
	{
		None = 0,
		Note,		//
		Warning,	//
		Error	//
	} TSeverity;

typedef enum {
	Unknown = 0,
	InvalidObject,
	InvalidEngineConnection,
	EngineLongJump,
	ClosedEvaluator,
	EvaluationFailure,
	SObjectCreationFailure,
	InvalidDatabase,
	CoersionFailure,
	MemoryAllocationFailure,
	InvalidClass,
	ExceptionLastID
} TSPExceptionID;

public:
	CSPexception();
	CSPexception(CSPexception& except);
	CSPexception(TSeverity severity);
	CSPexception(const char* pszMessage, TSeverity severity=Error);
	CSPexception(const char* pszMessage, long lAuxValue, TSeverity severity=Error);
	CSPexception(const char* pszMessage, const char* pszAuxMsg, TSeverity severity=Error);
	CSPexception(const char* pszMessage, struct s_object_struct* ps_object, TSeverity severity=Error);
	CSPexception(TSPExceptionID uiMessage, TSeverity severity=Error);
	CSPexception(TSPExceptionID uiMessage, const char* pszAuxMsg, TSeverity severity=Error);
	virtual ~CSPexception();

	const CSPexception& operator = (const CSPexception& except)
	{
		m_severity = except.m_severity;
		m_uiMessage = except.m_uiMessage;
		SetMessage(except.m_pszMessage);
		return *this;
	}

public:
	size_t GetMsgLen();
	size_t GetMsg(char* pszMessage, size_t nMaxCh);
	size_t SetMessageDirect(char* pszMessage);
	virtual void Print(void);

protected:
	size_t SetMessage(const char* pszMessage);
	size_t SetMessage(const char* pszMessage, s_object_struct* ps_object);
	size_t SetMessage(size_t uiMessage, const char* pszAuxMes);
	size_t SetMessage(const char* pszMessage, const char* pszAuxMes);
	size_t SetMessage(const char* pszMessage, long lAuxValue);
	inline wchar_t ValidMessageId();

protected:
	TSeverity m_severity;
	size_t m_uiMessage;

private:
	char* m_pszMessage;
};


/********************************************************************
	CSPengineException
********************************************************************/

class SCONNECT_LIB_EXTERN CSPengineException : public CSPexception
{
public:
	CSPengineException();
	CSPengineException(const CSPengineException& except);
	virtual ~CSPengineException(){};

	// Engine stop() issued. Do not print.
	virtual void Print(void){};
};

#endif // __SCONNECT_SPEXCEPT_H_INCLUDED__

