/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
*/

// spstruct.cpp: implementation of the CSPstructure class.
//
//////////////////////////////////////////////////////////////////////
#include <string.h>
#include "spstruct.h"
#include "spexcept.h"
#include "S_y_tab.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSPstructure::CSPstructure()
: CSPobject()
{

}

CSPstructure::~CSPstructure()
{

}

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
BOOL CSPstructure::IsValid(void) const
{
	if( CSPobject::IsValid() )
	{
		if ( !SPL_NotThere(GetData(FALSE)) )
			return TRUE;
	}
	return FALSE;
}


// Return pointer to the data part which is a list object.
// The list object contains a list of column objects.
s_object* CSPstructure::GetData(BOOL bValidate) const
{
	if(bValidate && !IsValid())
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);
	if((GET_LENGTH(GetPtr()) > 0) && (GetMode(FALSE) == S_MODE_STRUCTURE ))
		return LIST_POINTER(GetPtr())[0]; //return the list object
	else
		return NULL;
}

// Return pointer to the data part which is a list object.
// The list object contains a list of column objects.
BOOL CSPstructure::SetData(s_object* ps_data, BOOL bValidate) 
{
	if ( bValidate && !IsValid() )
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);

	if ( !ps_data )
		return FALSE;

	CSPevaluator sEvaluator;

	s_object* ps_struct = sEvaluator.CopyForWrite(GetPtr());
	ps_data = sEvaluator.CreateNewHeader(ps_data);

	if ( VERSION3_CLASS((s_class*)GetClass(bValidate)) )
		ps_data->name = (char *)(Data_name->text);

	SET_ELEMENT(ps_struct, 0, ps_data);

	ReAttachAndAssign(ps_struct);

	return TRUE;
}

s_object* CSPstructure::GetAttribute(const char* pszAttr, BOOL bValidate)
{
	if ( bValidate && !IsValid() )
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);

	if ( !pszAttr || !*pszAttr )
		return FALSE;

	if ( !VERSION3_CLASS((s_class*)GetClass(bValidate)) )
		return FALSE;

	if ( strcmp(pszAttr, (char *)(Names_name->text)) == 0 )
		return ::get_names(GetPtr());

	return GET_ATTR(GetPtr(), (char*)pszAttr);
}

BOOL CSPstructure::SetAttribute(const char* pszAttr, s_object* ps_object, BOOL bValidate)
{
	if ( bValidate && !IsValid() )
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);

	if ( ps_object == NULL )
		return FALSE;
	if ( !pszAttr || !*pszAttr )
		return FALSE;

	if ( !VERSION3_CLASS((s_class*)GetClass(bValidate)) )
		return FALSE;

	CSPevaluator sEvaluator;

	s_object* ps_struct = sEvaluator.CopyForWrite(GetPtr());
	ps_object = sEvaluator.CreateNewHeader(ps_object);
	ps_object->name = (char*)make_name(pszAttr, sEvaluator.GetPtr())->text;

	long n = x_which_comp((char*)pszAttr, ps_struct, S_evaluator)-1;
	if ( n > 0 )
		LIST_POINTER(ps_struct)[n] = ps_object;
	else
		append_el(ps_struct, ps_struct->length,  ps_object, S_evaluator);

	ReAttachAndAssign(ps_struct);

	return TRUE;
}

BOOL CSPstructure::RemoveAttribute(const char* pszAttr, BOOL bValidate)
{
	if ( bValidate && !IsValid() )
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);

	if ( !pszAttr || !*pszAttr )
		return FALSE;

	if ( !VERSION3_CLASS((s_class*)GetClass(bValidate)) )
		return FALSE;

	CSPevaluator sEvaluator;

	// one base index
	long n = x_which_comp((char*)pszAttr, GetPtr(), sEvaluator.GetPtr());
	if ( n <= 0 )
		return FALSE;

	s_object* ps_struct = sEvaluator.CopyForWrite(GetPtr());
	del_comp(ps_struct, n, sEvaluator.GetPtr());

	ReAttachAndAssign(ps_struct);

	return TRUE;
}

s_object* CSPstructure::GetElementAt(const char* pszElement, BOOL bValidate)
{
	if ( bValidate && !IsValid() )
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);

	if ( !pszElement || !*pszElement )
		return FALSE;

	if ( bValidate && !IsValid() )
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);

	s_object* ps_names = GET_NAMES(GetPtr());
	if ( SPL_NotThere(ps_names) || IS_CHARACTER(ps_names) )
		return FALSE;

	long len = GET_LENGTH(GetPtr());
	if ( len != GET_LENGTH(ps_names) )
		SCONNECT_ThrowException("Length of names %d does not match number of elements %s", GET_LENGTH(ps_names), len);
	
	for ( long index=0; index<len; index++ )
	{
		if ( strcmp(CHARACTER_POINTER(ps_names)[index],pszElement) == 0 )
			return LIST_POINTER(GetPtr())[index];
	}
	return FALSE;
}

BOOL CSPstructure::SetElementAt(const char* pszElement, s_object* ps_object, BOOL bValidate)
{
	if ( bValidate && !IsValid() )
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);

	if ( ps_object == NULL )
		return FALSE;

	if ( !pszElement || !*pszElement )
		return FALSE;

	if ( HAS_SLOTS(GetClass(bValidate)) )
		return FALSE;
	
	s_object* ps_names = GET_NAMES(GetPtr());
	if ( SPL_NotThere(ps_names) || !IS_CHARACTER(ps_names) )
		return FALSE;

	long len = GET_LENGTH(GetPtr());
	if ( len != GET_LENGTH(ps_names) )
		SCONNECT_ThrowException("Length of names does not match number of elements %s", len);
	
	for ( long index=0; index<len; index++ )
	{
		if ( strcmp(CHARACTER_POINTER(ps_names)[index],pszElement) == 0 )
			return SetElementAt(index, ps_object, FALSE);
	}
	return FALSE;
}


s_object* CSPstructure::GetElementAt(long index, BOOL bValidate)
{
	if ( bValidate && !IsValid() )
		SCONNECT_ThrowException("Invalid S-PLUS object %s", GetObjectName());

	long len = GET_LENGTH(GetPtr());

	if ( index < 0 || index >= len )
		return FALSE;

	return LIST_POINTER(GetPtr())[index];
}

BOOL CSPstructure::SetElementAt(long index, s_object* ps_object, BOOL bValidate)
{
	if ( ps_object == NULL )
		return FALSE;

	if ( HAS_SLOTS(GetClass(bValidate)) )
		return FALSE;

	long len = GET_LENGTH(GetPtr());
	if ( index < 0 || index >= len )
		return FALSE;

	BOOL bSuccess = FALSE;
	try
	{
		CSPevaluator sEvaluator;

		s_object* ps_struct = sEvaluator.CopyForWrite(GetPtr());
		ps_object = sEvaluator.CopyForWrite(ps_object);

		LIST_POINTER(ps_struct)[index] = ps_object;

		ReAttachAndAssign(ps_struct);

		bSuccess = TRUE;
	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	catch(...)
	{
	}
	return bSuccess;
}

