/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile$: $Revision: #13 $, $Date: 2006/06/26 $  */
/***
   NAME S_ansi
   PURPOSE
     Define some macros to give ANSI features when using an ANSI C &
     disable them otherwise.
   NOTES

   Nov 2002: We are all ANSI now, so we define this ANSI stuff unconditionally.  WWD.
     After including this, some macros to use:

     S_UsePrototypes - defined if we are allowed to specify ANSI C
         prototypes for function declarations.
     S_ANSI_LibC - defined if we have an ANSI-standard libc & support .h
         files (e.g. stdlib.h).     
     S_ANSI_Syntax - defined if we are allowed to use ANSI C syntactic
         items (e.g. the cpp # string-izing and ## token-pasting
         operators).
     S_begin_extern_c - to conditionally add 'extern "C" {' to the
         beginning of a block of extern declarations to tell C++ compilers
         that the externs are straight "C".
     S_end_extern_c - end the S_begin_extern_c block.

     PARAMS() - macro to conditionally include prototype args in a
         function declaration (e.g.
             extern int open PARAMS((char *filename, int mode));
         NOTE the double parens).
	 UseVar(var) - defines a static ptr variable that contains a reference to
		 itself as well as the mentioned variable...the purpose being to get
		 rid of "unused variable" warnings for things like the SCCS ID
		 strings.

     LibImport - used to qualify declarations where the symbol is to be
         imported from a different DLL/library.
     LibExport - used to qualify declarations and definitions where the
         symbol is to be exported from the DLL/library containing the
         symbol.
     FunType - used to declare the type and calling conventions used by a
         function....for example:
           extern FunType(__stdcall, void *) S_get_pointer PARAMS((int arg));
             
***/
#ifndef ansi_thingsINCLUDED
#define ansi_thingsINCLUDED 1

#undef S_NoPrototypes

#ifndef S_UsePrototypes
#define S_UsePrototypes
#endif

#ifndef S_ANSI_LibC       /*(*/
#define S_ANSI_LibC
#endif /* ) S_ANSI_LibC */

#ifndef S_ANSI_Syntax    /*(*/
#define S_ANSI_Syntax
#endif /* ) S_ANSI_Syntax */

/* NOTE: MS VC++ 4.0 (at least) gives you EITHER __STDC__ or the MS
   "extensions" like __cdecl, __declspec, et al.  We want BOTH. */
#include <stddef.h>
#include <stdlib.h>

#if defined(__cplusplus) || defined(c_plusplus)
#define S_begin_extern_c extern "C" {
#define S_end_extern_c }
#else
#define S_begin_extern_c
#define S_end_extern_c
#endif

/* Include a prototype in a function declaration:
 *    extern int foobar PARAMS((int, char *));
 *    extern int bloop  PARAMS((void));
 */
#define PARAMS(p) p

#define PARAM_DECL1(t1, p1) (t1 p1)
#define PARAM_DECL2(t1, p1, t2, p2) (t1 p1, t2 p2)
#define PARAM_DECL3(t1, p1, t2, p2, t3, p3) (t1 p1, t2 p2, t3 p3)
#define PARAM_DECL4(t1, p1, t2, p2, t3, p3, t4, p4) (t1 p1, t2 p2, t3 p3, t4 p4)

#define PARAM_DECL1_DOTS(t1, p1) (t1 p1, ...)
#define PARAM_DECL2_DOTS(t1, p1, t2, p2) (t1 p1, t2 p2, ...)
#define PARAM_DECL3_DOTS(t1, p1, t2, p2, t3, p3) (t1 p1, t2 p2, t3 p3, ...)
#define PARAM_DECL4_DOTS(t1, p1, t2, p2, t3, p3, t4, p4) (t1 p1, t2 p2, t3 p3, t4 p4, ...)

#define CONST const

/* Defines for "..." arguments */
#define VA_START(va_arg, arg)	va_start(va_arg, arg)
#define VA_END(va_arg)			va_end(va_arg)

/* The general idea here is to be able to use this macro to get rid of "unused
   variable" warnings about the specified variable. */
#define UseVar(v) static const void *use_##v[] = {&use_##v, &v}

/* Some Windows-y things. NOTE: This used to use WIN386 define, but
   cdefs.h (where that is defined) isn't necessarily included before this
   file. */
#if defined(__WINDOWS_386__) || defined(__NT__) || defined(_WIN32) /*(*/

#if defined(_MSC_VER) /*(*/
/* Microsoft Visual C++ */
#define S_CDECL __cdecl
#define S_STDCALL __stdcall

#define LibImport __declspec(dllimport)
#define LibExport __declspec(dllexport)
#elif defined(__GNUC__) /*(*/
/* Gnu C: MingW32 */
#define S_CDECL __cdecl
#define S_STDCALL 
#define LibImport __declspec(dllimport)
#define LibExport __declspec(dllexport)
#elif defined(__WATCOMC__) /*)(*/
/* Watcom C */
#define S_CDECL
#define S_STDCALL __stdcall

/*
	Nearly every routine that makes it into the map file (see
	$QPE/makefile.cpp) is exported via the S_Exports file.  Exports
	from sqpe.dll use the standard Watcom calling convention-not
	stdcall like Microsoft and most DLLs.

	In order to reference a routine from Visual C++ DLL's, we need to
	use STDCALL.  This is currently only used by a handful of routines
	(see S_externs.h) for use by the API.
*/
#define LibImport __declspec(dllimport)
#define LibExport __declspec(dllexport)
#else
#define LibImport
#define LibExport
#endif /*) _MSC_VER / __WATCOMC__ */
#define CALL_CONV __stdcall
#endif /* Windows */

/* Macros for the calling conventions */
#ifndef S_CDECL    /*(*/
#define S_CDECL
#endif /* ) S_CDECL */
#ifndef S_STDCALL    /*(*/
#define S_STDCALL
#endif /* ) S_STDCALL */

/* Define a macro that lets us put gcc attribute qualifiers on function
 * declarations and such.  One use of this could be to declare that a
 * function has printf or scanf like format/argument lists to let the
 * compiler do some type checking between the format string and the
 * corresponding arguments.  For example:
 *
 *    extern void S_apiFTrace PARAMS((
 *        int level, const char *source, const char *format, ...))
 *        GCC_ATTR((cdecl, format (printf,3,4)));
 */
#ifdef __GNUC__  /*(*/
#define GCC_ATTR(x) __attribute__(x)
#else   /*)(*/
#define GCC_ATTR(x)
#endif /* ) __GNUC__ */

#ifndef FunType    /*(*/
/* The compilers we've checked (MSVC, Watcom, Borland) allow (or require)
   the calling convention keyword between the function type and function
   name.  For example:
       extern FunType(__stdcall, char *) S_apiGetHostname PARAMS((void));
   produces
       extern char * __stdcall S_apiGetHostname (void);
   which is acceptible to the checked compilers. */
#define FunType(conv,type) type conv
#endif /* ) FunType */

#ifndef LibImport /*(*/
#define LibImport
#define LibExport
#endif /*)*/

/* Concatenate strings macro */
#define CPP_CAT(a,b) a##b
/* (mildly) funny rules in ANSI C might force us to do:
 *    #define CPP_CAT XCPP_CAT
 */

#endif /* ansi_thingsINCLUDED */
