#ifndef LIST_DEV_DEFS_H
#define LIST_DEV_DEFS_H



/* display list data structures */

typedef struct displayItem {
        struct displayItem      *nextItem;
        int                     itemType;
} 
DisplayListItem;

typedef struct {
        DisplayListItem *nextItem;
        int             itemType;
        long            length;
        float           adj;
        float           xy[2];
        char            str[1];  /* This has to be the last element of the struct !! */
} 
TextItem;


typedef struct {
        DisplayListItem *nextItem;
        int             itemType;
        long            nxy;
        float           xy[1];
} 
PlotItem;

typedef struct {
        DisplayListItem *nextItem;
        int             itemType;
        int             n;
        float           par[1];
} 
AmodItem;

typedef struct {
        DisplayListItem *nextItem;
        int             itemType;
        float           xy[4];
        char            file[1];
} 
ImageItem;





#endif
