#ifndef _S_NEWIO_H_ /*(*/
#define _S_NEWIO_H_

/* We used to use S.h, but the following 2 give us what we need
 * I think and some routines (e.g., in $SL/inspect/) cannot deal with S.h
 * but need the new I/O functions.
 */
#include <stdio.h>
#if defined(WIN32) && !defined(__GNUC__) && !defined(S_DONT_TYPEDEF_SIZE_T) /* ( */
/* On Windows with Microsoft compilers, size_t is
 * typedefed in vc98/include/stddef.h, but it defines
 * other things we may not like (e.g., NULL could be (void*)0).  It protects
 * the typedef of size_t with _SIZE_T_DEFINED so I did too.  I don't see
 * ssize_t defined anywhere -- it probably is not in standard C, just needed
 * for Unix write() and the like, which use -1 as an error return.
 */
#ifndef _SSIZE_T_DEFINED
#define _SSIZE_T_DEFINED
typedef int ssize_t ;
#endif
#ifndef _SIZE_T_DEFINED
#define _SIZE_T_DEFINED
typedef unsigned int size_t ;
#endif
#else /* WIN32 ) ( UNIX */
/* The following is not needed on SunOS 5.8, but SunOS 5.6
 * doesn't define size_t and ssize_t in stdio.h
 */
#include <sys/types.h>
#endif /* ) UNIX */
/* This file used to be ifdef'ed for S_ANSI_Syntax, but I took
 * out the non-ANSI stuff.  Nov 2002, WWD.
 */

#include <stdarg.h>

#include "libext.h"

S_begin_extern_c
LibExtern void S_STDCALL S_newio_initialize(void) ;

/* following give length of formatted output */
LibExtern int S_STDCALL S_vprintflen(const char *fmt0, va_list ap) ;
/*PRINTFLIKE1*/
LibExtern int S_CDECL S_printflen(const char *fmt0, ...) ;
S_end_extern_c

struct S_newio_FILE_s ; /* forward declaration */

typedef ssize_t (*S_newio_write_t)(struct S_newio_FILE_s *stream, const char *buf, size_t nbytes) ;
typedef int (*S_newio_should_write_t)(struct S_newio_FILE_s *stream, const char *buf, size_t nbytes) ;
typedef ssize_t (*S_newio_read_t)(struct S_newio_FILE_s *stream, char *buf, size_t nbytes) ;
typedef int (*S_newio_close_t)(struct S_newio_FILE_s *stream) ;
typedef int (*S_newio_open_t)(struct S_newio_FILE_s *stream, const char *file, const char *type) ;
typedef int (*S_newio_seek_t)(struct S_newio_FILE_s *stream, long offset, int ptrname) ;

typedef struct S_newio_FILE_s {
	int Type ; /* a constant, for debugging */
#define S_newio_FILE_TYPE 0xf11ef11e
	char *buf ; /* made with malloc or calloc */
	char *bufp ; /* current end of buffer */
	size_t nalloc ; /* allocated end of buffer */
/* S_newio_BUFSIZ will be default initial size of buffer */
#define S_newio_BUFSIZ  512L
	S_newio_write_t write ;
	S_newio_should_write_t should_write ;
	S_newio_read_t read ;
	S_newio_open_t open ;
	S_newio_close_t close ;
	S_newio_seek_t seek ;
	void *user_data ;
	int flags ;
#define S_newio_IS_STDIO_FILE     (1<<0)
#define S_newio_EOF               (1<<1)
#define S_newio_ERR               (1<<2)
#define S_newio_IS_MALLOCED       (1<<3)
#define S_newio_OPEN_FOR_READING  (1<<4)
#define S_newio_USE_NATIVE_STDIO  (1<<5)
#define S_newio_ENABLE_CR_FLUSH   (1<<6)
	struct S_newio_FILE_s *next ; /* so we can close all of them down */
	ssize_t count ; /* how far into buffer we have currently read from */
#define S_newio_STATIC_BUF_LEN 1024
	char static_buf[S_newio_STATIC_BUF_LEN] ;
	size_t n_bytes ; /* number of bytes read/written */
	size_t n_eols ;  /* number of \n's read/written  */
	size_t n_bytes_since_eol ; /* by of bytes since last \n read/written */
#define S_newio_n_bytes(stream)           ((stream)->n_bytes)
#define S_newio_n_eols(stream)            ((stream)->n_eols)
#define S_newio_n_bytes_since_eol(stream) ((stream)->n_bytes_since_eol)
	long not_counted ; /* set to 1 if we decide not to count bytes/eols for efficiency reasons (not implemented yet) */
} S_newio_FILE ;

#define S_newio_feof(p)         (((p)->flags&S_newio_EOF)!=0)
#define S_newio_ferror(p)       (((p)->flags&S_newio_ERR)!=0)
#define S_newio_setbuf(f,b)
#define S_newio_setvbuf(f,b,m,s)

S_begin_extern_c
LibExtern S_newio_FILE * S_STDCALL S_newio_assoc_with_stdfile(FILE *f);
LibExtern S_newio_FILE * S_STDCALL S_newio_open_from_stdio(FILE *f, S_newio_write_t write, S_newio_should_write_t should_write, S_newio_read_t read) ;
LibExtern void S_STDCALL S_newio_set_funs(S_newio_FILE *f, S_newio_write_t write, S_newio_should_write_t should_write, S_newio_read_t read) ;
LibExtern S_newio_FILE * S_STDCALL S_newio_map_from_possible_stdio(FILE *f) ;

LibExtern S_newio_FILE *S_newio_stdout ;
LibExtern S_newio_FILE *S_newio_stderr ;
LibExtern S_newio_FILE *S_newio_stdin ;
extern S_newio_FILE *S_newio_yyin ;
extern S_newio_FILE *S_newio_yyout ;
extern S_newio_FILE *S_newio_audit_file ;
extern S_newio_FILE *S_newio_MemCheckFile ;
S_end_extern_c

/* other stdio-like functions */
S_begin_extern_c
LibExtern int S_STDCALL S_newio_fflush(S_newio_FILE *stream);
/*PRINTFLIKE2*/
LibExtern int S_CDECL S_newio_fprintf(S_newio_FILE *stream, const char *format, ...);
/*PRINTFLIKE1*/
LibExtern int S_CDECL S_newio_printf(const char *format, ...);
/*PRINTFLIKE1*/
LibExtern int S_CDECL S_newio_eprintf(const char *format, ...); /* fprintf(stderr,format,...) */
LibExtern int S_STDCALL S_newio_fputs(const char *s, S_newio_FILE *stream);
LibExtern int S_STDCALL S_newio_puts(const char *s);
LibExtern int S_STDCALL S_newio_fputc(int c, S_newio_FILE *stream);
LibExtern S_newio_FILE * S_STDCALL S_newio_fopen(const char *file, const char *type);
LibExtern S_newio_FILE * S_STDCALL S_newio_Binopen(const char *file, const char *type);
LibExtern S_newio_FILE * S_STDCALL S_newio_tmpfile(void);
LibExtern S_newio_FILE * S_STDCALL S_newio_popen(const char *command, const char *type);
LibExtern S_newio_FILE * S_STDCALL S_newio_fdopen(int handle, const char *type);
LibExtern int S_STDCALL S_newio_fclose(S_newio_FILE *stream);
LibExtern int S_STDCALL S_newio_getc(S_newio_FILE *stream);
LibExtern int S_STDCALL S_newio_ungetc(int c, S_newio_FILE *stream);
LibExtern char * S_STDCALL S_newio_fgets(char *s, int n, S_newio_FILE *stream);
LibExtern size_t S_STDCALL S_newio_fread(void *ptr, size_t size, size_t nitems, S_newio_FILE *stream);
LibExtern size_t S_STDCALL S_newio_fwrite(const void *ptr, size_t size, size_t nitems, S_newio_FILE *stream);
LibExtern int S_STDCALL S_newio_fseek(S_newio_FILE *, long offset, int ptrname);
LibExtern long S_STDCALL S_newio_ftell(S_newio_FILE *);
LibExtern int S_STDCALL S_newio_fgetpos(S_newio_FILE *, fpos_t *pos);
LibExtern int S_STDCALL S_newio_fsetpos(S_newio_FILE *, const fpos_t *pos);
LibExtern int S_STDCALL S_newio_fileno(S_newio_FILE *stream);
LibExtern void S_STDCALL S_newio_clearerr(S_newio_FILE *stream);
LibExtern void S_STDCALL S_newio_perror(const char *prefix);
/* and some stray unix i/o functions */
LibExtern ssize_t S_STDCALL S_newio_write(int fd, const void *buf, size_t len);
S_end_extern_c

#define S_newio_putchar(c) S_newio_fputc(c, S_newio_stdout)

#include "unlibext.h"
#endif /* ) _S_NEWIO_H_ */
