/**************************************************************************/
#if !defined(_IM_NAIVE_BAYES_H_)
#define _IM_NAIVE_BAYES_H_

#include "IMObjects.h"

#define IMinerNaiveBayesModel IMinerObject

#define IMINER_NAIVE_BAYES_META_DATA_NUM	0
#define IMINER_NAIVE_BAYES_DEP_NUM			1
#define IMINER_NAIVE_BAYES_INDEP_NUM		2
#define IMINER_NAIVE_BAYES_INIT_PROB_NUM	3
#define IMINER_NAIVE_BAYES_PROB_NUM			4
#define IMINER_NAIVE_BAYES_DEP_LEVS_NUM		5

/* macro to access a matrix element from IMinerMatrix object*/
#define IMINER_NAIVE_BAYES_PTR(pObj, i)					(pObj)->m_uData.m_ppList[i]
#define IMINER_NAIVE_BAYES_META_DATA(model)				IMINER_NAIVE_BAYES_PTR(model, IMINER_NAIVE_BAYES_META_DATA_NUM)
#define IMINER_NAIVE_BAYES_DEPENDENT(model)				IMINER_NAIVE_BAYES_PTR(model, IMINER_NAIVE_BAYES_DEP_NUM)
#define IMINER_NAIVE_BAYES_INDEPENDENT(model)			IMINER_NAIVE_BAYES_PTR(model, IMINER_NAIVE_BAYES_INDEP_NUM)
#define IMINER_NAIVE_BAYES_INIT_PROBS(model)			IMINER_NAIVE_BAYES_PTR(model, IMINER_NAIVE_BAYES_INIT_PROB_NUM)
#define IMINER_NAIVE_BAYES_PROBABILITY(model)			IMINER_NAIVE_BAYES_PTR(model, IMINER_NAIVE_BAYES_PROB_NUM)
#define IMINER_NAIVE_BAYES_DEP_LEVELS(model)			IMINER_NAIVE_BAYES_PTR(model, IMINER_NAIVE_BAYES_DEP_LEVS_NUM)


#ifdef __cplusplus
extern "C" {
#endif

/* alloc memory and set content for class KMeans Cluster */
IMCSRC_DLLAPI(long) IMinerNaiveBayesModel_create(
 IMinerObject* pModel,		    /* out: data object */
 IMinerObject* md,			    /* in:  meta data object */
 long nIndepCols,				/* in:  number of indep columns */
 long nDepLevels,				/* in:  number of levels output */
 const long *nIndepLevels,		/* in:  number of independent levels of length (nIndepCols) */
 const double *pInitialProb,	/* in:  initial probability of length (nDepLevels) */
 const double *pMatrix,			/* in:  probability of each indep&dep level combination of length (nIndepCols*max(nIndepLevels)*nDepLevels) */
 const char **pcDepLevels		/* in:  dependent levels if categorical (nDepLevels) */
);

/* validate the object */
IMCSRC_DLLAPI(long) IMinerNaiveBayesModel_isValid(const IMinerObject* pModel);

/* free memory */
IMCSRC_DLLAPI(long) IMinerNaiveBayesModel_destroy(IMinerObject* pModel );

/* write to stdout */
IMCSRC_DLLAPI(long) IMinerNaiveBayesModel_print(const IMinerObject* pModel);

/* predict cluster memberships */
IMCSRC_DLLAPI(long) IMinerNaiveBayesModel_predict(
 IMinerObject* pOutput,      /* out: output rectangular data */
 const IMinerObject* pInput, /* in: input rectangular data */
 IMinerObject* pDescr,		 /* in: input description (if NULL, description will be 
                                    created from input data) */
 const IMinerObject* pModel  /* in: the model */
);

#ifdef __cplusplus
}
#endif

#endif /*_IM_TREE_H_ */

