<?xml version='1.0' encoding='utf-8' ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- XSL style sheet for creating an HTML chart of the mining schema from pmml -->


	<xsl:template match="PMML">
		<html>
			<title>PMML Description of Model Variables</title>
			<style type="text/css"><xsl:value-of select="CSSText/text()"/></style>
			<body>
				<h2 class="title">PMML Description of Model Variables</h2>
				<xsl:apply-templates select="DataDictionary"/>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="DataDictionary">
		<table border="0" cellspacing="0" cellpadding="3" >
			<tr>
    				<td class="tableBG" height="2" >
    					<table cellspacing="1" cellpadding="5" border="0" class="content" bordercolor="#999999" bgcolor="#82C0FF">
	       					<tr>
	        					<td class="blueBG"><b>Columns:</b></td>
					 			<td class="blueBG"><b>Role:</b></td>
								<td class="blueBG"><b>Type:</b></td>
					 			<td class="blueBG"><b>Levels:</b></td>
             				</tr>
	       					<xsl:apply-templates select="DataField"/>
	       				</table>
	       			</td>
	       	</tr>
	    </table>
	    <br></br>
	</xsl:template>

	<xsl:template match="DataField">
		<xsl:variable name="name" select="@name" />
		<xsl:variable name="type" select="../../TreeModel/MiningSchema/MiningField[@name=$name]/@usageType" />

		<tr>
			<xsl:choose>
				<xsl:when test="position() mod 2 = 0">
					<td class="whiteBG"><xsl:value-of select="@name"/></td>
					<xsl:choose>
						<xsl:when test="$type=''" >
							<td class="whiteBG">independent</td>
						</xsl:when>
						<xsl:otherwise>
							<td class="whiteBG"><xsl:value-of select="$type"/></td>
						</xsl:otherwise>
					</xsl:choose>
					<td class="whiteBG"><xsl:value-of select="@optype"/></td>
					<td class="whiteBG"><xsl:apply-templates select="Value"/></td>
				</xsl:when>
				<xsl:otherwise>
					<td class="greyBG"><xsl:value-of select="@name"/></td>
					<xsl:choose>
						<xsl:when test="$type=''" >
							<td class="greyBG">independent</td>
						</xsl:when>
						<xsl:otherwise>
							<td class="greyBG"><xsl:value-of select="$type"/></td>
						</xsl:otherwise>
					</xsl:choose>
					<td class="greyBG"><xsl:value-of select="@optype"/></td>
					<td class="greyBG"><xsl:apply-templates select="Value"/></td>
				</xsl:otherwise>
			</xsl:choose>
    	</tr>
	</xsl:template>

	<xsl:template match="Value">
		<xsl:value-of select="@value"/><br></br>
	</xsl:template>
</xsl:stylesheet>
