/* %Z%%Q% */
static char whatssi[] = "%Z%$RCSfile$ version $Revision: #15 $ created $Date: 2007/08/02 $ ";

#include <stdlib.h>

static int my_round(int n, int d)
{
	double x = (double)n/d;
	return((int)(x+0.5));
}

void quantum(long *N, long *mm, long *DD, long *kk, long *dd)
{
	int k = *kk, D = *DD, m = *mm, d, i, nout;

	for(i = 0; i <= k; i++)
		dd[i] = 0;
	for(d = 1; d <= D; d++) { /* count the outliers */
		nout = 0;
		for(i = 0; i < m; i++) {
			int n = my_round((int)N[i]*d, D);
			nout += 2*abs(n*D - (int)N[i]*d) > d;
			if(nout > k) break;
		}
		if(nout > k || dd[nout] > 0) continue;
		k = nout;
		dd[k] = d;
		if(k == 0) break;
	}
}
