/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

	spconnec.h: interface for the CSPconnection class.
*/

#if !defined(__SCONNECT_SPCONNEC_H_INCLUDED__)
#define __SCONNECT_SPCONNEC_H_INCLUDED__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "spobject.h"

struct S_newio_FILE_s;

#define PARSE_FAIL			(-1)
#define PARSE_NOTHING		0
#define PARSE_ERROR			1001
#define PARSE_COMPLETE		1002
#define PARSE_INCOMPLETE	1003
#define PARSE_CONTINSTR		1004

class SCONNECT_LIB_EXTERN CSPconnection : public CSPobject  
{
public:
	typedef enum 
	{
		connection = 0,
		read = 1,
		write = 2
	} Which;

	typedef enum
	{
		beginning = SEEK_SET,
		current = SEEK_CUR,
		end = SEEK_END
	} From;

public:
	CSPconnection();
	virtual ~CSPconnection();

	BOOL Open();
	void Close(Which which=connection);

	/* careful: FILE may be S_newio_FILE*/
	S_newio_FILE_s* GetReadFile();
	S_newio_FILE_s* GetWriteFile();
	long GetReadfd();
	long GetWritefd();
	size_t GetReadPos();
	size_t GetWritePos();
	size_t GetSize();
	const char* GetDescription();
	void SeekWrite(long pos, From from=beginning);
	void SeekRead(long pos, From from=beginning);

	// Write symbolic dump of object to connection
	size_t DataPut(s_object* ps_object);
	// Read a symbolic dump of an object from the connection
	s_object* DataGet();
};

class SCONNECT_LIB_EXTERN CSPtextConnection : public CSPconnection  
{
public:
//////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////
public:

	//Default constructor
	CSPtextConnection();

	//Construct from a valid S-expression
	explicit CSPtextConnection(const char* pszExpression);

	//Copy constructors 
	explicit CSPtextConnection(s_object* ps_object);
	CSPtextConnection(const CSPtextConnection& sobject);

	//Assignment operators
	CSPtextConnection& operator = (s_object* ps_object);
	CSPtextConnection& operator = (const CSPtextConnection& sobject);

	//Create a persistent object when pszName != NULL
	virtual BOOL Create(
		const char* pszExpression=NULL, //==NULL, uses the default constructor, else use the expression to instantiate it.
		const char* pszName=NULL,  //object name
		long lDataBase=1 );        //database, only used if name given

	s_object* ParseEval();

	//The destructor
	virtual ~CSPtextConnection();

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
public:

  //Return TRUE if the object is a valid 'array' class
	virtual BOOL IsValid(void) const;

	//Coerce the data to "character" class	
	virtual BOOL Coerce(void);

	//Coerce() coerces to "character" class and attatch
	virtual BOOL CoerceAttach(s_object* ps_object);

//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
public:
	//ParseTest() parses to test the string. It returns status result.
	//The arg. pnCharParsed is length of char. sucessfully parsed.
	virtual int ParseTest(long* plCharParsed);

	s_object* Parse();

	// open a text connection
	BOOL TextConnection(const char* pszText);
	
};


class SCONNECT_LIB_EXTERN CSPfile : public CSPconnection  
{
public:
//////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////
public:

	//Default constructor
	CSPfile();

	//Construct from a valid S-expression
	explicit CSPfile(const char* pszExpression);

	//Copy constructors 
	explicit CSPfile(s_object* ps_object);
	CSPfile(const CSPfile& sobject);

	//Assignment operators
	CSPfile& operator = (s_object* ps_object);
	CSPfile& operator = (const CSPfile& sobject);

	//Create a persistent object when pszName != NULL
	virtual BOOL Create(
		const char* pszExpression=NULL, //==NULL, uses the default constructor, else use the expression to instantiate it.
		const char* pszName=NULL,  //object name
		long lDataBase=1 );        //database, only used if name given

	//The destructor
	virtual ~CSPfile();

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
public:

  //Return TRUE if the object is a valid 'array' class
	virtual BOOL IsValid(void) const;

	virtual BOOL Coerce(void);

	//Coerce() coerces to "character" class and attatch
	virtual BOOL CoerceAttach(s_object* ps_object);

//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
	// Open a file connection
	BOOL File(const char* pszPath=NULL, const char* pszOpen="*");
	
};


class SCONNECT_LIB_EXTERN CSPpipe : public CSPconnection  
{
public:
//////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////
public:

	//Default constructor
	CSPpipe();

	//Construct from a valid S-expression
	explicit CSPpipe(const char* pszExpression);

	//Copy constructors 
	explicit CSPpipe(s_object* ps_object);
	CSPpipe(const CSPpipe& sobject);

	//Assignment operators
	CSPpipe& operator = (s_object* ps_object);
	CSPpipe& operator = (const CSPpipe& sobject);

	//Create a persistent object when pszName != NULL
	virtual BOOL Create(
		const char* pszExpression=NULL, //==NULL, uses the default constructor, else use the expression to instantiate it.
		const char* pszName=NULL,  //object name
		long lDataBase=1 );        //database, only used if name given

	//The destructor
	virtual ~CSPpipe();

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
public:

  //Return TRUE if the object is a valid 'array' class
	virtual BOOL IsValid(void) const;

	virtual BOOL Coerce(void);

	//Coerce() coerces to "character" class and attatch
	virtual BOOL CoerceAttach(s_object* ps_object);

//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
	// Create a pipe connection
	BOOL Pipe(const char* pszCommand=NULL, const char* pszOpen="");
	const char* GetText();
	
};

#endif // !defined(__SCONNECT_SPCONNEC_H_INCLUDED__)
