#include <cdefs.h>
  
POUND This is a bourne shell script.
POUND %Z%SUN_LIB_DEF version $Revision: #24 $ created $Date: 2001/08/30 $
POUND %Z%%Q%
  
POUND This script produces (on standard output) a suggested library
POUND specification for linking S-PLUS using ld(1) on the Sun (Sun puts
POUND the libraries in different places for different versions).  The ouput
POUND excludes the C library.
POUND Exit status is 0 for ok, non-zero for can't come up with specification.
  
POUND It finds the specification by checking what directories exist.
POUND (This could also use f77(1) -v, but it may not be so good to make this
POUND automatic.  If things aren't as we expect, we might tell how to use
POUND f77 -v, but probably good to make users aware that things are not
POUND what we expected at the time of S-PLUS release.)
  
POUND Fortran versions currently supported: 1.4, 1.3, 1.2 (and older).
POUND If you have later versions, this script likely won't not know about them.

POUND The RUNPATH variable is currently only used on the Solaris and is used
POUND to set up the run-time location for picking up the required libraries
POUND when LD_LIBRARY_PATH is not set.

#if (defined(SUNOS5) && defined(SPARC)) /*(*/
#if defined(USE_F2C)
SUN_LANG="/usr/ccs/bin"
SUN_LIB="/usr/lib"
#else
SUN_LANG="/opt/SUNWspro"
SUN_LIB="$SUN_LANG/lib"
#endif
#else
SUN_LANG="/usr/lang"
SUN_LIB="/usr/lib"
#endif
  
POUND Figure out what library specification to go with.
  
RUNPATH=""

#if (defined(SUNOS5) && defined(SPARC)) /*(*/
   if   [ -d "$SUN_LANG/SC3.0.1/lib" ]; then
      RUNPATH="-R/opt/SUNWspro/SC3.0.1/lib"
   fi
#endif

#if (defined(SUNOS4) && defined(SPARC)) /*(*/
POUND Fortran 3.0.1 POUND cg89 floating point processor support only.
if   [ -d "$SUN_LANG/SC3.0.1/lib" -a -d "$SUN_LANG/SC3.0.1/lib/cg89" ]; then
   LIB_RESULT="-L$SUN_LANG/SC3.0.1/lib -L$SUN_LANG/SC3.0.1/lib/cg89 -lF77 -lM77"
POUND Fortran 1.4 POUND cg87 floating point processor support only.
elif [ -d "$SUN_LANG/SC1.0" -a -d "$SUN_LANG/SC1.0/cg87" ]; then
   LIB_RESULT="-L$SUN_LANG/SC1.0 -L$SUN_LANG/SC1.0/cg87 -lF77"
POUND Fortran 1.3 POUND cg87 floating point processor support only.
elif [ -d "$SUN_LANG/SC0.0" -a -d "$SUN_LANG/SC0.0/cg87" ]; then
   LIB_RESULT="-L$SUN_LANG/SC0.0 -L$SUN_LANG/SC0.0/cg87 -lF77"
#endif /*)SUNOS4_SPARC*/

#if defined(SUN3) /*(*/
POUND 68881 math co-processor support only.
if   [ -d "$SUN_LANG/SC1.0" -a -d "$SUN_LANG/SC1.0/f68881" ]; then
	LIB_RESULT="-L$SUN_LANG/SC1.0 -L$SUN_LANG/SC1.0/f68881 -lF77"
  
POUND Fortran 1.3
POUND 68881 math co-processor support only.
elif [ -d "$SUN_LANG/SC0.0" -a -d "$SUN_LANG/SC0.0/f68881" ]; then
	LIB_RESULT="-L$SUN_LANG/SC0.0 -L$SUN_LANG/SC0.0/f68881 -lF77"
#endif /*)SUN3*/
  
#if (SUNOS_REV < 500)
POUND Fortran 1.2 or older
elif [ -d "$SUN_LIB" -a -f "$SUN_LIB/libF77.a" ]; then
	LIB_RESULT="-lF77"
  
else
	POUND Can't find any versions of the libraries that we know about
	POUND as of the time of this release.
	exit 1
fi
#else
#if defined(USE_F2C)
LIB_RESULT="$RUNPATH -Bdynamic -lf2c -lelf -ldl"
#else
LIB_RESULT="$RUNPATH -Bdynamic -lF77 -lM77 -lsunmath -lelf -ldl"
#endif
#endif /*)SUNOS_REV < 500*/
  
POUND Other library specifications used for S-PLUS.
  
LIB_OTHER="-lm"
  
POUND Produce output.
  
	LIB_RESULT="$LIB_RESULT $LIB_OTHER"
	echo $LIB_RESULT
  
POUND Done.
exit 0
