;; -*- mOde: Emacs-Lisp -*-

;;; This is a sample .emacs file.
;;;
;;; The .emacs file, which should reside in your home directory, allows you to
;;; customize the behavior of Emacs.  In general, changes to your .emacs file
;;; will not take effect until the next time you start up Emacs.  You can load
;;; it explicitly with `M-x load-file RET ~/.emacs RET'.
;;;
;;; There is a great deal of documentation on customization in the Emacs
;;; manual.  You can read this manual with the online Info browser: type
;;; `C-h i' or select "Emacs Info" from the "Help" menu.


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;			Basic Customization			    ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; Make the sequence "C-x w" execute the `what-line' command, 
;; which prints the current line number in the echo area.
(global-set-key "\C-xw" 'what-line)

;; set up the function keys to do common tasks to reduce Emacs pinky
;; and such.

;; Make F1 invoke help
(global-set-key [f1] 'help-command)
;; Make F2 be `undo'
(global-set-key [f2] 'undo)
;; Make F3 be `find-file'
;; Note: it does not currently work to say
;;   (global-set-key 'f3 "\C-x\C-f")
;; The reason is that macros can't do interactive things properly.
;; This is an extremely longstanding bug in Emacs.  Eventually,
;; it will be fixed. (Hopefully ..)
(global-set-key [f3] 'find-file)

;; Make F4 be "mark", F5 be "copy", F6 be "paste"
;; Note that you can set a key sequence either to a command or to another
;; key sequence.
(global-set-key [f4] 'set-mark-command)
(global-set-key [f5] "\M-w")
(global-set-key [f6] "\C-y")

;; Shift-F4 is "pop mark off of stack"
(global-set-key [(shift f4)] (lambda () (interactive) (set-mark-command t)))

;; Make F7 be `save-buffer'
(global-set-key [f7] 'save-buffer)

;; Make F8 be "start macro", F9 be "end macro", F10 be "execute macro"
(global-set-key [f8] 'start-kbd-macro)
(global-set-key [f9] 'end-kbd-macro)
(global-set-key [f10] 'call-last-kbd-macro)

;; Here's an alternative binding if you don't use keyboard macros:
;; Make F8 be `save-buffer' followed by `delete-window'.
;;(global-set-key 'f8 "\C-x\C-s\C-x0")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;		Customization of Specific Packages		    ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; This adds additional extensions which indicate files normally
;; handled by cc-mode.
(setq auto-mode-alist
      (append '(("\\.C$"  . c++-mode)
		("\\.cc$" . c++-mode)
		("\\.hh$" . c++-mode)
		("\\.c$"  . c-mode)
		("\\.h$"  . c-mode))
	      auto-mode-alist))


;;; ********************
;;; cc-mode (the mode you're in when editing C, C++, and Objective C files)

;; Tell cc-mode not to check for old-style (K&R) function declarations.
;; This speeds up indenting a lot.
(setq c-recognize-knr-p nil)

;; Change the indentation amount to 4 spaces instead of 2.
;; You have to do it in this complicated way because of the
;; strange way the cc-mode initializes the value of `c-basic-offset'.
(add-hook 'c-mode-hook (lambda () (setq c-basic-offset 4)))



;; --------- local customizations ---------

;; agebhard
(setq mouse-yank-at-point t)

; --- set  fill column
(setq-default fill-column 78)

; --- Line-Number Mode
(setq line-number-mode t)
(setq column-number-mode t)

; --- 
(setq display-time-24hr-format t)
(display-time)
;(display-time-scan-mail-file "~/Mailbox" t)

(setq scroll-step 1)
(setq delete-key-deletes-forward t)

; better faces for latex

;(custom-set-faces
; '(font-lock-keyword-face ((((class color) (background light)) (:foreground "darkorange3"))))
; '(font-lock-function-name-face ((((class color) (background light)) (:foreground "blue3")))))

; font-lock stuff:
;(custom-set-variables
; '(font-lock-use-colors t)
; '(font-lock-use-fonts nil))

;; switch to XML mode for XHTML files
(defun psgml-find-file-hook ()
  (condition-case nil
      (save-excursion
        (let (mdo)
          (goto-char (point-min))
          (setq mdo
                (sgml-with-parser-syntax
                 (let (start)
                   (sgml-skip-upto "MDO")
                   (setq start (point))
                   (sgml-skip-upto-mdc)
                   (forward-char 1)
                   (buffer-substring start (point)))))
          (string-match "\\bDTD\\s-+\\(\\w+\\)\\b" mdo)
          (cond
           ((string= (match-string 1 mdo) "XHTML")
            (xml-mode))
           ((string= (match-string 1 mdo) "XML")
            (xml-mode))
           ((string= (match-string 1 mdo) "HTML")
            (html-mode))
           (t
            nil))))
    (t nil)))



;; indent with space not tabs:
(setq-default indent-tabs-mode nil)
(setq indent-tabs-mode nil)

;; misc stuff:
(custom-set-variables
  '(visible-bell t)
  '(delete-selection-mode t)
  '(flyspell-default-dictionary "english")

;  '(paren-mode (quote blink-paren) nil (paren))
)



;; Change the cursor used when the mouse is over a mode line
(setq x-mode-pointer-shape "leftbutton")

;; Buffer-Menue mit Untermenues
(setq complex-buffers-menu-p 't)

;; Ctrl-Tab for dynamic cempletion:
(global-set-key  [(control tab)] 'dabbrev-completion)



;(modify-all-frames-parameters '((font . "Courier-14")))
;(set-face-attribute 'default (selected-frame) :height 100 :width 'normal) 
;(set-default-font "monaco") 

   (setq initial-frame-alist '(
        (tool-bar-lines         . 1)
        (menu-bar-lines         . 2)
;        (border-color           . "gold1")
;        (cursor-color           . "turquoise1")
;        (mouse-color            . "purple3")
;        (foreground-color       . "DarkCyan")
;        (background-color       . "antiquewhite1")
        (vertical-scroll-bars   . right)
        (internal-border-width  . 5)
;        (top  . 10) (left . 525) (width . 80) (height . 35)
;    (font . "fontset-global")
        )) 
;
;
;

