;NSIS Modern User Interface
;Basic Example Script
;Written by Joost Verburg
;Modified by Julien Narboux

!define MY_PRODUCT "GeoProof" ;Define your own software name here
!define MY_VERSION "0.5beta23102012" ;Define your own software version here

!include "MUI.nsh"

;--------------------------------
;Configuration

  Name "GeoProof"

   ;General
  OutFile "GeoProof_0.5beta23102012_win32_installer.exe"

  ;Folder selection page
  InstallDir "$PROGRAMFILES\${MY_PRODUCT}"
  
  ;Remember install folder
  InstallDirRegKey HKCU "Software\${MY_PRODUCT}" ""

;Interface Configuration

  !define MUI_HEADERIMAGE
  !define MUI_HEADERIMAGE_BITMAP "geoproof_logo.bmp" ; optional
  !define MUI_ABORTWARNING


;--------------------------------
;Modern UI Configuration

  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_LICENSE "..\..\COPYING"
  !insertmacro MUI_PAGE_COMPONENTS
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
  !define MUI_FINISHPAGE_RUN "$INSTDIR\geoproof.exe"
  !insertmacro MUI_PAGE_FINISH
  
  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH  

;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"
  
;--------------------------------
;Language Strings

  ;Description
  LangString DESC_1 ${LANG_ENGLISH} "This is the windows version of GeoProof"
  LangString DESC_2 ${LANG_ENGLISH} "This will copy the GTK dlls in the installation directory (These files are needed by GeoProof)."

;--------------------------------
;Data
  
Function .onInit
  SetOutPath $TEMP
  File /oname=geoproof_splash.bmp "geoproof_splash.bmp"
	InitPluginsDir

  advsplash::show 1000 600 400 -1 $TEMP\geoproof_splash

  Pop $0 ; $0 has '1' if the user closed the splash screen early,
         ; '0' if everything closed normal, and '-1' if some error occured.

  Delete $TEMP\geoproof_splash.bmp
FunctionEnd


;--------------------------------
;Installer Sections

Section "GeoProof" Sec1

  ;ADD YOUR OWN STUFF HERE!

  SetOutPath "$INSTDIR"
  File "..\..\geoproof.exe"
  File "geoproof.ico"

  
  
  ;Store install folder
  WriteRegStr HKCU "Software\${MY_PRODUCT}" "" $INSTDIR
  
  ;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"
  WriteRegStr HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\GeoProof" \
	  "DisplayName" "GeoProof Version 0.5beta23102012"
  WriteRegStr HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\GeoProof" \
	  "UninstallString" '"$INSTDIR\Uninstall.exe"'

  WriteRegStr HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\GeoProof" \
          "DisplayVersion" "0.5beta23102012"

  WriteRegDWORD HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\GeoProof" \
          "NoModify" "1"
  WriteRegDWORD HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\GeoProof" \
          "NoRepair" "1"

  WriteRegStr HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\GeoProof" \
          "URLInfoAbout" "http://home.gna.org/geoproof/"

; Start Menu Entries
  CreateDirectory "$SMPROGRAMS\GeoProof"
  CreateShortCut "$SMPROGRAMS\GeoProof\GeoProof.lnk" "$INSTDIR\geoproof.exe" "" "$INSTDIR\geoproof.ico" 0 
  WriteINIStr "$SMPROGRAMS\GeoProof\GeoProof-HomePage.url" "InternetShortcut" "URL" "http://home.gna.org/geoproof/"
  CreateShortCut "$SMPROGRAMS\GeoProof\Uninstall.lnk" "$INSTDIR\Uninstall.exe" "" "$INSTDIR\Uninstall.exe" 0

SectionEnd

Section  "The GTK DLLs (needed by GeoProof)" Sec2
  
  SetOutPath "$INSTDIR"
  File /r /x CVS  dlls\*.*

SectionEnd

;--------------------------------
;Descriptions

!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${Sec1} $(DESC_1)
  !insertmacro MUI_DESCRIPTION_TEXT ${Sec2} $(DESC_2)
!insertmacro MUI_FUNCTION_DESCRIPTION_END
 
;--------------------------------
;Uninstaller Section

Section "Uninstall"

;; Binaries
  Delete "$INSTDIR\geoproof.exe"

;; Configuration files
  Delete "$INSTDIR\.geoproof\config.ini.old"
  Delete "$INSTDIR\.geoproof\config.ini"
  RMDir "$INSTDIR\.geoproof"

;; Icon
  Delete "$INSTDIR\geoproof.ico"

;; DLLs

  Delete "$INSTDIR\iconv.dll" 
  Delete "$INSTDIR\libgdk-win32-2.0-0.dll"
  Delete "$INSTDIR\libgdk_pixbuf-2.0-0.dll"
  Delete "$INSTDIR\libglib-2.0-0.dll"
  Delete "$INSTDIR\libgobject-2.0-0.dll"
  Delete "$INSTDIR\libgtk-win32-2.0-0.dll"
  Delete "$INSTDIR\libpango-1.0-0.dll"
  Delete "$INSTDIR\librsvg-2-2.dll"
  Delete "$INSTDIR\freetype6.dll"
  Delete "$INSTDIR\iconv.dll"
  Delete "$INSTDIR\intl.dll"
  Delete "$INSTDIR\libart_lgpl_2-2.dll"
  Delete "$INSTDIR\libatk-1.0-0.dll"
  Delete "$INSTDIR\libfontconfig-1.dll"
  Delete "$INSTDIR\libgdk_pixbuf-2.0-0.dll"
  Delete "$INSTDIR\libgmodule-2.0-0.dll"
  Delete "$INSTDIR\libgsf-1-1.dll"
  Delete "$INSTDIR\libpangoft2-1.0-0.dll"
  Delete "$INSTDIR\libpangowin32-1.0-0.dll"
  Delete "$INSTDIR\libxml2.dll"
  Delete "$INSTDIR\xmlparse.dll"
  Delete "$INSTDIR\xmltok.dll"
  Delete "$INSTDIR\zlib1.dll"
  RMDir /r "$INSTDIR\etc"
  RMDir /r "$INSTDIR\lib"
    
;; Start Menu
  Delete "$SMPROGRAMS\GeoProof\GeoProof.lnk"
  Delete "$SMPROGRAMS\GeoProof\Uninstall.lnk"
  Delete "$SMPROGRAMS\GeoProof\GeoProof-HomePage.url"
  Delete "$INSTDIR\Uninstall.exe"
  
  DeleteRegKey /ifempty HKCU "Software\${MY_PRODUCT}"

  DeleteRegKey HKEY_LOCAL_MACHINE "SOFTWARE\GeoProof"
  DeleteRegKey HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\GeoProof"
  RMDir "$INSTDIR"
  RMDir "$SMPROGRAMS\GeoProof"

SectionEnd