(*

 GeoProof, an interactive geometry tool writen in OCaml.                   
 Copyright (C) 2008 Julien Narboux                      
                                                                            
 This program is free software; you can redistribute it and/or              
 modify it under the terms of the GNU General Public License                
 as published by the Free Software Foundation; either version 2             
 of the License, or (at your option) any later version.                     
                                                                            
 This program is distributed in the hope that it will be useful,            
 but WITHOUT ANY WARRANTY; without even the implied warranty of             
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              
 GNU General Public License for more details.                               
                                                                            
 You should have received a copy of the GNU General Public License          
 along with this program; if not, write to the Free Software                
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*)  

(* $Id: objets_point.ml,v 1.25 2005/11/26 17:37:55 jnarboux Exp $ *)

open Geometric_functions.GeometryFunctions
open Types_de_base
open Objets_graphiques
open Options
open Optionsdeconfiguration

open Repere 
  
class type virtual t_objet_point =
object 
  inherit Objets_graphiques.t_objet_graphique
  method est_proche : Repere.t -> t_coords -> bool
  method paint : Cairo.t -> Repere.t -> unit
  method objet_type : t_type_objet  
  method movable : unit -> bool
  method defining_points : unit -> (string * string) option
end
	  
class virtual objet_point =
object (self)
  inherit objet_graphique
    
  method movable () = false (* most points are not free *)
    
  method est_proche rep c =
    if self#objet_calculable then
      let u = papier_vers_ecran_t rep self#coordonnees_point in
      let deltax = abs (u.x -! c.x)
      and deltay = abs (u.y -! c.y) 
      in
      (deltax +! deltay) <! (of_int !!pixels_proche)
    else false
	
  method paint cr rep = 
    if self#objet_calculable then
      begin
	let dessine_point c = 
     match self#objet_style with
	| STYLE_POINT (CROIX) ->
	    let hs = 4. in
	    Cairo.move_to cr (c.xfloat +. hs) (c.yfloat +. hs);
	    Cairo.line_to cr (c.xfloat -. hs) (c.yfloat -. hs);
	    Cairo.move_to cr (c.xfloat -. hs) (c.yfloat +. hs);
	    Cairo.line_to cr (c.xfloat +. hs) (c.yfloat -. hs);
	    Cairo.stroke cr;
	| STYLE_POINT (ROND) -> 
	    Cairo.arc cr ~xc:c.xfloat ~yc:c.yfloat ~radius:3.  ~angle1: 0. ~angle2: two_pi;
	    Cairo.stroke cr
	| STYLE_POINT (CARRE) ->
	    let s = 6. in
	    let hs = s /. 2. in
	      Cairo.rectangle cr (c.xfloat -. hs) (c.yfloat -. hs) s s;
	      Cairo.stroke cr
	| STYLE_POINT (RONDPLEIN) ->
	    Cairo.arc cr ~xc:c.xfloat ~yc:c.yfloat ~radius:3.  ~angle1: 0. ~angle2: two_pi;
	    Cairo.stroke_preserve cr;
	    Cairo.fill cr
	| STYLE_POINT (CARREPLEIN) ->
	    let s = 6. in
	    let hs = s /. 2. in
	      Cairo.rectangle cr (c.xfloat -. hs) (c.yfloat -. hs) s s;  
	      Cairo.stroke_preserve cr;
	      Cairo.fill cr
	| _ -> Debug.pdb "le point n'a pas le bon style";()

	in
	  dessine_point (papier_vers_ecran_f rep self#coordonnees_point)	  
      end 
		      
  method objet_type = TYPE_POINT

  method defining_points () = None
end
  
    

