(*******************************************************************************)
(* GeoProof, an interactive geometry tool writen in OCaml.                    *)
(* Copyright (C) 2005 Julien Narboux                                           *)
(*                                                                             *)
(* This program is free software; you can redistribute it and/or               *)
(* modify it under the terms of the GNU General Public License                 *)
(* as published by the Free Software Foundation; either version 2              *)
(* of the License, or (at your option) any later version.                      *)
(*                                                                             *)
(* This program is distributed in the hope that it will be useful,             *)
(* but WITHOUT ANY WARRANTY; without even the implied warranty of              *)
(* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *)
(* GNU General Public License for more details.                                *)
(*                                                                             *)
(* You should have received a copy of the GNU General Public License           *)
(* along with this program; if not, write to the Free Software                 *)
(* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *)
(*******************************************************************************)

open Printf
open Output_fonctions
open Geometric_functions.GeometryFunctions

let header = 
"
% This file was generated by GeoProof.
% It should be preprocessed using eukleides.
% See http://www.eukleides.org/ for more information.
% Compile using :
% eukleides -f this_file.pre.tex > this_file.tex 
% latex this_file.tex

\\documentclass{article}
\\usepackage{pstricks}

\\begin{document}

\\scalebox{1.0}{
\\input pstricks
%--eukleides
"

let footer = 
"
%--end
}

\\end{document}
"

let to_string include_context () = 
  let to_string x = to_string x 5 in 
  let body = if include_context then ref [header] else ref [] in
  let footer = if include_context then footer else "" in
  let x_min = to_string (Repere.x_min ()) in
  let x_max = to_string (Repere.x_max ()) in 
  let y_min = to_string (neg (Repere.y_min ())) in (* the coordinate systems are different *) 
  let y_max = to_string (neg (Repere.y_max ())) in
  let x_delta =  (Repere.x_max ()) -! (Repere.x_min ()) in
  let paper_size = of_int 21 in
  let zoom = to_string (paper_size /! x_delta) in
  
  (*
  let y_delta =  (Repere.y_max ()) -! (Repere.y_min ()) in
    (* 2/3 is for A4 printing *)
  let max = max (2 /! 3 *! x_delta) y_delta in
  *)
   
  let frame = sprintf "frame(%s,%s,%s,%s,%s)" x_min y_min x_max y_max zoom in
    body := frame :: !body;
    let update_body o =  
      body := (o#output_eukleides()) :: !body  
    in
      Construction.iter update_body;
      (String.concat "\n" (List.rev !body))^footer

let to_file include_context file = 
  let aux c =   Printf.fprintf c "%s\n" (to_string include_context ()) in
  write_file file aux
