eliminate (List, Ideal) := (v,I) -> (     
     if #v === 0 then return I;
     R := ring I;
     varlist := sort unique(v/index);
     others := toList(set(0..numgens R-1) - set varlist);
     perm := join(varlist,others);
     invperm := inversePermutation perm;
     degs := (monoid R).Options.Degrees;
     degs = apply(perm, i -> degs_i);
     M := monoid [Variables=>numgens R,MonomialOrder=>Eliminate(#varlist), Degrees=>degs, MonomialSize=>16];
     k := coefficientRing R;
     R1 := k M;
     toR1 := map(R1,R,apply(invperm,i->R1_i));
     toR := map(R,R1,apply(perm,i->R_i));
     J := toR1 I;
     if isHomogeneous I then
         (cokernel generators J).cache.poincare = poincare cokernel generators I;
     ideal mingens ideal toR selectInSubring(1,generators gb(J))
     )

end
restart
load "~/src/M2/Macaulay2/bugs/mike/0-adam-boocher.m2"

R=QQ[x,y,a,b,c,d,e,f,g,h,i,j,k,l,MonomialOrder=>Eliminate 2]
R=QQ[x,y,a,b,c,d,e,f,g,h,i,j,k,l,MonomialOrder=>{2,12}]
p=a*x^2+b*x*y+c*y^2+d*x+e*y+f
q=g*x^2+h*x*y+i*y^2+j*x+k*y+l
M=matrix{{diff(x,p),diff(y,p)},{diff(x,q),diff(y,q)}}
D=determinant M
I=ideal(p,q,D)
--it will compute the Grobner basis in a few seconds
time S=gens gb I;
--but the eliminate command hangs
time eliminate({x,y},I);


R=QQ[x,y,a,b,c,d,e,f,g,h,i,j,k,l,z,MonomialOrder=>Eliminate 2]
p=a*x^2+b*x*y+c*y^2+d*x+e*y+f
q=g*x^2+h*x*y+i*y^2+j*x+k*y+l
M=matrix{{diff(x,p),diff(y,p)},{diff(x,q),diff(y,q)}}
D=determinant M
I=ideal(p,q,D)
I = homogenize(trim I, z)
time eliminate({x,y},I);

-- The bug is that eliminate is using a product order!


R=QQ[x_1..x_7,h]
I = ideal( 
-148*x_1*x_5*x_6+148*x_1*x_4*x_7-18748*x_1*x_4-2*x_3*x_4-1980*x_1*x_5+2*x_2*x_5+92520*x_1*x_6+30*x_3*x_6-240*x_5*x_6+7352*x_1*x_7-30*x_2*x_7+240*x_4*x_7+306448*x_1+2550*x_2+302*x_3-36240*x_4-3600*x_5+237600*x_6+17760*x_7+882240,
64337/3888*x_1*x_5*x_6-64337/3888*x_1*x_4*x_7+89904269/139968*x_1*x_4+91/108*x_3*x_4+26117/216*x_1*x_5-91/108*x_2*x_5-12757199/7776*x_1*x_6-182/27*x_3*x_6+22295/1944*x_5*x_6-32644339/139968*x_1*x_7+182/27*x_2*x_7-22295/1944*x_4*x_7-14786877833/5038848*x_1-346255/1944*x_2-145327/3888*x_3+35605115/69984*x_4+22295/243*x_5-6398665/3888*x_6-15762565/69984*x_7-7997863055/2519424,
572/33075*x_1*x_5*x_6-572/33075*x_1*x_4*x_7+2972068/72930375*x_1*x_4+22/1575*x_3*x_4+21692/694575*x_1*x_5-22/1575*x_2*x_5-47435432/1823259375*x_1*x_6-4598/165375*x_3*x_6+176/55125*x_5*x_6-261448/17364375*x_1*x_7+4598/165375*x_2*x_7-176/55125*x_4*x_7-4194608/364651875*x_1-81141038/1823259375*x_2-660682/17364375*x_3+5285456/607753125*x_4+36784/5788125*x_5-173536/24310125*x_6-4576/1157625*x_7-2091584/607753125,
-119/216000*x_1*x_5*x_6+119/216000*x_1*x_4*x_7-462791/12441600000*x_1*x_4+119/14400*x_3*x_4-5831/103680000*x_1*x_5-119/14400*x_2*x_5-372827/99532800000*x_1*x_6-119/1728000*x_3*x_6+119/2304000*x_5*x_6-30107/829440000*x_1*x_7+119/1728000*x_2*x_7-119/2304000*x_4*x_7+20587/9953280000*x_1-1513799/24883200000*x_2-114359/207360000*x_3+114359/33177600000*x_4+119/276480000*x_5+5831/16588800000*x_6+119/34560000*x_7-30107/132710400000,
-185725/42674688*x_1*x_5*x_6+185725/42674688*x_1*x_4*x_7-59109185725/10840053547008*x_1*x_4-1615/254016*x_3*x_4+123684775/21508042752*x_1*x_5+1615/254016*x_2*x_5-11987781625/4645737234432*x_1*x_6-1193485/128024064*x_3*x_6+40375/64012032*x_5*x_6+2705125/1316818944*x_1*x_7+1193485/128024064*x_2*x_7-40375/64012032*x_4*x_7+9059140625/10840053547008*x_1-257252670085/32520160641024*x_2+601169215/64524128256*x_3+15029230375/16260080320512*x_4-29837125/32262064128*x_5+3092119375/5420026773504*x_6-4643125/10754021376*x_7-67628125/331838373888,
84799/2370816*x_1*x_5*x_6-84799/2370816*x_1*x_4*x_7+3607227481/16728477696*x_1*x_4+143/14112*x_3*x_4-20797205/199148544*x_1*x_5-143/14112*x_2*x_5+7790705065/33456955392*x_1*x_6+39325/1185408*x_3*x_6-715/56448*x_5*x_6-33769307/398297088*x_1*x_7-39325/1185408*x_2*x_7+715/56448*x_4*x_7-11290372951/66913910784*x_1+1121042065/8364238848*x_2-7252817/99574272*x_3-36264085/398297088*x_4+196625/4741632*x_5-103986025/796594176*x_6+423995/9483264*x_7+168846535/1593188352,
74844/125*x_1*x_5*x_6-74844/125*x_1*x_4*x_7+131983236/3125*x_1*x_4+462/25*x_3*x_4-3634092/625*x_1*x_5-462/25*x_2*x_5+401845752/3125*x_1*x_6+24486/125*x_3*x_6-66528/125*x_5*x_6-8598744/625*x_1*x_7-24486/125*x_2*x_7+66528/125*x_4*x_7-173937456/625*x_1+30777054/3125*x_2-923538/625*x_3-132989472/3125*x_4+3525984/625*x_5-523309248/3125*x_6+10777536/625*x_7+1238219136/3125,
74844/125*x_1*x_5*x_6-74844/125*x_1*x_4*x_7+131983236/3125*x_1*x_4+462/25*x_3*x_4-3634092/625*x_1*x_5-462/25*x_2*x_5+401845752/3125*x_1*x_6+24486/125*x_3*x_6-66528/125*x_5*x_6-8598744/625*x_1*x_7-24486/125*x_2*x_7+66528/125*x_4*x_7-173937456/625*x_1+30777054/3125*x_2-923538/625*x_3-132989472/3125*x_4+3525984/625*x_5-523309248/3125*x_6+10777536/625*x_7+1238219136/3125)
I = homogenize(trim I, h)
time J=eliminate(toList(x_1..x_6),I);
quit

R=QQ[x_1..x_8,h]
I = ideal( 
-539445/16*x_2*x_5-117675/16*x_3*x_5-3795/8*x_4*x_5+539445/16*x_1*x_6-12945/16*x_3*x_6-555/8*x_4*x_6+117675/16*x_1*x_7+12945/16*x_2*x_7-15/4*x_4*x_7+3795/8*x_1*x_8+555/8*x_2*x_8+15/4*x_3*x_8-1357665/4*x_1-1205205/8*x_2-197745/8*x_3-5685/4*x_4+596925*x_5+398475/2*x_6+58275/2*x_7+1575*x_8+661500,
-93925/41472*x_2*x_5-19705/20736*x_3*x_5-205/1728*x_4*x_5+93925/41472*x_1*x_6-8305/41472*x_3*x_6-115/3456*x_4*x_6+19705/20736*x_1*x_7+8305/41472*x_2*x_7-1/288*x_4*x_7+205/1728*x_1*x_8+115/3456*x_2*x_8+1/288*x_3*x_8-29005/4608*x_1-18415/3456*x_2-23213/13824*x_3-215/1152*x_4+1505/256*x_5+1435/384*x_6+805/768*x_7+7/64*x_8+441/128,
-43043803578009/413220935680000*x_2*x_5-1193518511991/8433080320000*x_3*x_5-10652778279/210827008000*x_4*x_5+43043803578009/413220935680000*x_1*x_6-866311318431/8433080320000*x_3*x_6-204464871/4302592000*x_4*x_6+1193518511991/8433080320000*x_1*x_7+866311318431/8433080320000*x_2*x_7-1584999/107564800*x_4*x_7+10652778279/210827008000*x_1*x_8+204464871/4302592000*x_2*x_8+1584999/107564800*x_3*x_8-1757763891/84330803200*x_1-527058132471/8264418713600*x_2-11147297967/168661606400*x_3-90344943/4216540160*x_4+90344943/20661046784*x_5+10652778279/1033052339200*x_6+204464871/21082700800*x_7+1584999/527067520*x_8+1584999/2582630848,
13421/82944000000000*x_2*x_5+4597/4147200000000*x_3*x_5+77/34560000000*x_4*x_5-13421/82944000000000*x_1*x_6+3193/829440000000*x_3*x_6+71/6912000000*x_4*x_6-4597/4147200000000*x_1*x_7-3193/829440000000*x_2*x_7+1/57600000*x_4*x_7-77/34560000000*x_1*x_8-71/6912000000*x_2*x_8-1/57600000*x_3*x_8+533/331776000000000*x_1+313/13824000000000*x_2+1939/16588800000000*x_3+29/138240000000*x_4-29/331776000000000*x_5-77/82944000000000*x_6-71/16588800000000*x_7-1/138240000000*x_8-1/331776000000000,
26089/104485552128000*x_2*x_5-613753/435356467200000*x_3*x_5+2849/1209323520000*x_4*x_5-26089/104485552128000*x_1*x_6+291403/72559411200000*x_3*x_6-1799/201553920000*x_4*x_6+613753/435356467200000*x_1*x_7-291403/72559411200000*x_2*x_7+7/559872000*x_4*x_7-2849/1209323520000*x_1*x_8+1799/201553920000*x_2*x_8-7/559872000*x_3*x_8+217/58047528960000*x_1-22463/522427760640000*x_2+79513/435356467200000*x_3-329/1209323520000*x_4+329/1306069401600000*x_5-2849/1306069401600000*x_6+1799/217678233600000*x_7-7/604661760000*x_8-7/653034700800000,
-122949761/7782481350000*x_2*x_5+4941739/222356610000*x_3*x_5-9823/1058841000*x_4*x_5+122949761/7782481350000*x_1*x_6-2499761/158826150000*x_3*x_6+6611/756315000*x_4*x_6-4941739/222356610000*x_1*x_7+2499761/158826150000*x_2*x_7-11/3601500*x_4*x_7+9823/1058841000*x_1*x_8-6611/756315000*x_2*x_8+11/3601500*x_3*x_8-277783/72060012500*x_1+2853257/259416045000*x_2-2155417/185297175000*x_3+3817/882367500*x_4-3817/3603000625*x_5+9823/4323600750*x_6-6611/3088286250*x_7+11/14706125*x_8+132/720600125,
-4410845887/83980800000*x_2*x_5+98726719/2799360000*x_3*x_5-328937/46656000*x_4*x_5+4410845887/83980800000*x_1*x_6-9253111/777600000*x_3*x_6+123137/38880000*x_4*x_6-98726719/2799360000*x_1*x_7+9253111/777600000*x_2*x_7-343/648000*x_4*x_7+328937/46656000*x_1*x_8-123137/38880000*x_2*x_8+343/648000*x_3*x_8-4769137513/83980800000*x_1+71883539/933120000*x_2-15109493/388800000*x_3+16807/2430000*x_4-5764801/174960000*x_5+112825391/3359232000*x_6-42235991/2799360000*x_7+117649/46656000*x_8+40353607/3359232000,
368830385/144*x_2*x_5-191905945/432*x_3*x_5+1569491/72*x_4*x_5-368830385/144*x_1*x_6+17350795/432*x_3*x_6-187187/72*x_4*x_6+191905945/432*x_1*x_7-17350795/432*x_2*x_7+1309/12*x_4*x_7-1569491/72*x_1*x_8+187187/72*x_2*x_8-1309/12*x_3*x_8+3636796009/108*x_1-2778704621/216*x_2+367872197/216*x_3-2710939/36*x_4+189765730/3*x_5-54932185/3*x_6+6551545/3*x_7-91630*x_8-76969200,
368830385/144*x_2*x_5-191905945/432*x_3*x_5+1569491/72*x_4*x_5-368830385/144*x_1*x_6+17350795/432*x_3*x_6-187187/72*x_4*x_6+191905945/432*x_1*x_7-17350795/432*x_2*x_7+1309/12*x_4*x_7-1569491/72*x_1*x_8+187187/72*x_2*x_8-1309/12*x_3*x_8+3636796009/108*x_1-2778704621/216*x_2+367872197/216*x_3-2710939/36*x_4+189765730/3*x_5-54932185/3*x_6+6551545/3*x_7-91630*x_8-76969200)
I = homogenize(trim I, h)
time J=eliminate(toList(x_1..x_7),I);
quit
