--- status: done
--- author(s): MES
--- notes: 

doc ///
   Key
     truncate
     (truncate,ZZ,Module)
     (truncate,List,Module)
     (truncate,ZZ,Ideal)
     (truncate,List,Ideal)
   Headline
     truncate the module at a specified degree
   Usage
     truncate(i,M)
   Inputs
     i:ZZ
       or list of integers
     M:Module
       ideal
   Outputs
     :Module
       or ideal, the submodule of M consisting of all elements of degree $\ge i$
   Description
    Text
    Example
      R = ZZ/101[a..c];
      truncate(2,R^1)
      truncate(2,R^1 ++ R^{-3})
      truncate(2, ideal(a,b,c^3)/ideal(a^2,b^2,c^4))
      truncate(2,ideal(a,b*c,c^7))
    Text
      The base may be ZZ, or another polynomial ring.  In this case, the generators may not
      be minimal, but they do generate.
    Example
      A = ZZ[x,y,z];
      truncate(2,ideal(3*x,5*y,15))
      trim oo
      truncate(2,comodule ideal(3*x,5*y,15))
    Text
      If  {\tt i} is a multi-degree, then the result is the submodule generated by all elements
      of degree exactly {\tt i}, together with all generators of {\tt M} whose first degree is 
      higher than the first degree of {\tt i}.
      The following includes the generator of degree {8,20}.
    Example
      S = ZZ/101[x,y,z,Degrees=>{{1,3},{1,4},{1,-1}}];
      truncate({7,24}, S^1 ++ S^{{-8,-20}})
    Text
      The coefficient ring may also be a polynomial ring.  In this example, the coefficient variables
      also have degree one.  The given generators will generate the truncation over the coefficient ring.
    Example
      B = R[x,y,z, Join=>false]
      degree x
      degree B_3
      truncate(2, B^1)
      truncate(4, ideal(b^2*y,x^3))
    Text
      If the coefficient variables have degree 0:
    Example
      A1 = ZZ/101[a,b,c,Degrees=>{3:{}}]
      degree a
      B1 = A1[x,y]
      truncate(2,B1^1)
      truncate(2, ideal(a^3*x, b*y^2))
   Caveat
   SeeAlso
      basis
      comodule
///

TEST ///
A = ZZ/101[a..d, Degrees => {1,2,3,4}]
assert(truncate(2, A^1) == image matrix {{a^2, a*b, a*c, a*d, b, c, d}})
assert(truncate(4, ideal"a3,b3") == ideal(a^4,a^3*b,a^3*c,a^3*d,b^3))
///

TEST ///
A = ZZ/101[a..d, Degrees => {4:0}]
assert(truncate(2, A^1) == image matrix{{1_A}})
///

TEST ///
A = ZZ/101[a..d]
truncate(2, ideal"a-1,b3+c")
///

TEST ///
A = ZZ/101[a..d, Degrees=>{2:{1,2},2:{0,1}}]
basis({3}, A^1)


A = ZZ/101[a..d, Degrees=>{2:{2,1},2:{1,0}}]
basis({3}, A^1)


A = ZZ/101[a..d, Degrees=>{2:{2,1,0},2:{1,0,0}}]
basis({3,1}, A^1)
///

TEST ///
R=(ZZ/101)[x_0,x_1,y_0,y_1,y_2,Degrees=>{2:{1,1,0},3:{1,0,1}}];
I=ideal random(R^1,R^{6:{-6,-2,-4},4:{-6,-3,-3}});
J = truncate({4,2,2},I);
assert(J == I)
///

TEST ///
-- Singly generated case
R = QQ[a..d]
I = ideal(b*c-a*d,b^2-a*c,d^10)
assert(truncate(2,I) == I)
assert(truncate(3,I) == intersect((ideal vars R)^3, I))

R = QQ[a..d,Degrees=>{3,4,7,9}]
I = ideal(a^3,b^4,c^6)
assert(truncate(12,I) == ideal(a^4,a^3*b,a^3*c,a^3*d,b^4,c^6))

R = ZZ[a,b,c]
I = ideal(15*a,21*b,19*c)
trim truncate(2,I) == ideal(19*c^2,b*c,a*c,21*b^2,3*a*b,15*a^2)
///
