-- -*- coding: utf-8 -*-
newPackage(
	"SubalgebraBases",
	AuxiliaryFiles => true,
    	Version => "0.1", 
    	Date => "November 24, 2006",
    	Authors => {{Name => "Mike Stillman", 
		  Email => "mike@math.cornell.edu", 
		  HomePage => "http://www.math.cornell.edu/~mike/"}},
    	Headline => "Canonical subalgebra bases (sagbi bases)",
    	DebuggingMode => true
    	)

export {subalgebraBasis, "sagbi" => subalgebraBasis, PrintLevel}

load "SubalgebraBases/sagbi-common.m2"
load "SubalgebraBases/sagbitop.m2"
load "SubalgebraBases/sagbieng.m2"

beginDocumentation()
document { 
	Key => SubalgebraBases,
	Headline => "a package for finding canonical subalgebra bases (sagbi bases)",
	EM "SubalgebraBases", " is "
	}

document {
	Key => {(subalgebraBasis,Matrix),sagbi},
	Headline => "subalgebra basis (sagbi basis)",
	Usage => "sagbi M\nsubalgebraBasis M",
	Inputs => { "M"},
	Outputs => { Matrix => { "
		  whose entries form a subalgebra basis (sagbi) 
                  of the subalgebra generated by the entries of the matrix M"}
              },
     	 "This routine computes a sagbi basis degree by degree,
     	 for a graded or nongraded subalgebra.",
	 EXAMPLE lines ///
     	 ///,
	 Caveat => "M should be a matrix over a polynomial ring over a field,
     	 and NOT a quotient ring.",
     PARA{},
     TEX ///References: Kapur, D., Madlener, K. (1989). A completion procedure
     for computing a canonical basis of a $k$-subalgebra.
     Proceedings of {\it Computers and Mathematics 89}
     (eds. Kaltofen and Watt), MIT, Cambridge, June 1989.///,
     PARA{},
     TEX ///Robbiano, L., Sweedler, M. (1990). Subalgebra bases,
     in W.~Bruns, A.~Simis (eds.): {\sl Commutative Algebra},
     Springer Lecture Notes in Mathematics {\bf 1430}, pp.~61--87.///,
     PARA{},
     TEX ///F. Ollivier, Canonical Bases: Relations with Standard bases, finiteness
     conditions and applications to tame automorphisms, in Effective Methods
     in Algebraic Geometry, Castiglioncello 1990, pp. 379-400, 
     Progress in Math. {\bf 94} Birkhauser, Boston (1991)///,
     PARA{},
     TEX ///B. Sturmfels, Groebner bases and Convex Polytopes, Univ. Lecture 
     Series 8, Amer Math Soc, Providence, 1996///
	}

load "SubalgebraBases/sagbi-tests.m2"

