/**
* Copyright (c) 2012, Ynon Perek
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following
* conditions are met:
* Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
* Neither the name of the <ORGANIZATION> nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef FLWEBVIEW_H
#define FLWEBVIEW_H

#include <QtWebKit/QWebView>
#include <QtCore/QMap>
#include <QtGui>
#include "pdfwindow.h"

class QDragEnterEvent;

class FlWebView : public QWebView
{
Q_OBJECT

public:
    enum TWebViewOptions
    {
        WV_IGNORE_DROPS,
        WV_OPEN_NEW_WINDOWS
    };

public:
//    FlWebView( QWidget *parent = 0);
    FlWebView( QWidget *parent = 0, bool withClose = false);
//    FlWebView( QWidget *parent = 0, bool withClose = false , PDFWindow *pdfview = 0);

public:
    void setOption(FlWebView::TWebViewOptions opt, bool value);
    bool getOption(TWebViewOptions opt);
    void setPDFview(PDFWindow *pdfwin);
    PDFWindow *getPDFview();
    bool topLevel;
    bool linksHighlighted;

public slots:
    void windowCloseRequested();
    void windowCloseByJavaScript();
    void removeTargets();
    void increaseFontSize();
    void resetFontSize();
    void decreaseFontSize();
    void download(QNetworkReply* reply);
    void myraise();
    void openPDF();

signals:
    void pdfDownloaded(QByteArray pdfdata);

protected:
    // Reimplemented from QWebView
    virtual void dropEvent         ( QDropEvent * ev );
    virtual FlWebView *createWindow ( QWebPage::WebWindowType type );
    ~FlWebView();
    virtual bool eventFilter(QEvent* e, QObject* o);


protected slots:
    void adjustTitle();
    void setProgress(qint64 part, qint64 all);

private:
    QMap<TWebViewOptions, bool> m_opts;
    int defaultFontSize;
    int FontSize;
    QNetworkReply *netReply;
    PDFWindow *pdfview;
    int progress;
};

#endif /* FLWEBVIEW_H */
