 /****************************************************************************
 **
 ** Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
 ** All rights reserved.
 ** Contact: Nokia Corporation (qt-info@nokia.com)
 **
 ** This file is part of the examples of the Qt Toolkit.
 **
 ** $QT_BEGIN_LICENSE:BSD$
 ** You may use this file under the terms of the BSD license as follows:
 **
 ** "Redistribution and use in source and binary forms, with or without
 ** modification, are permitted provided that the following conditions are
 ** met:
 **   * Redistributions of source code must retain the above copyright
 **     notice, this list of conditions and the following disclaimer.
 **   * Redistributions in binary form must reproduce the above copyright
 **     notice, this list of conditions and the following disclaimer in
 **     the documentation and/or other materials provided with the
 **     distribution.
 **   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
 **     the names of its contributors may be used to endorse or promote
 **     products derived from this software without specific prior written
 **     permission.
 **
 ** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 ** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 ** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 ** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 ** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 ** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 ** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 ** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 ** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 ** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 ** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
 ** $QT_END_LICENSE$
 **
 ****************************************************************************/

 #include <QtGui>
#include <QtWebKit>

 #include "mainwindow.h"
 #include "pdfwindow.h"
 #include "flwebview.h"


 MainWindow::MainWindow(QWidget *parent):
     QMainWindow(parent)
 {
     setupUi(this);

     progress = 0;
     QFile file;
     file.setFileName(":/jquery.min.js");
     file.open(QIODevice::ReadOnly);
     jQuery = file.readAll();
     file.close();

     QNetworkProxyFactory::setUseSystemConfiguration(true);

     connect(flWebView, SIGNAL(loadFinished(bool)), SLOT(adjustLocation()));
     connect(flWebView, SIGNAL(titleChanged(QString)), SLOT(adjustTitle()));
     connect(flWebView, SIGNAL(loadProgress(int)), SLOT(setProgress(int)));
     connect(flWebView, SIGNAL(loadFinished(bool)), SLOT(finishLoading(bool)));

     locationEdit = new QLineEdit(this);
     locationEdit->setSizePolicy(QSizePolicy::Expanding, locationEdit->sizePolicy().verticalPolicy());
     locationEdit->setDisabled(true);
     connect(locationEdit, SIGNAL(returnPressed()), SLOT(changeLocation()));



     QToolBar *toolBar = addToolBar(tr("Navigation"));
     QAction *back = flWebView->pageAction(QWebPage::Back);
     back->setShortcut(QKeySequence::Back);
     toolBar->addAction(back);
     QAction *forward = flWebView->pageAction(QWebPage::Forward);
     forward->setShortcut(QKeySequence::Forward);
     toolBar->addAction(forward);
     QAction *reload = flWebView->pageAction(QWebPage::Reload);
     reload->setShortcut(QKeySequence(tr("Ctrl-R")));
     toolBar->addAction(reload);
     QAction *stop = flWebView->pageAction(QWebPage::Stop);
     stop->setShortcut(QKeySequence::Quit);
     toolBar->addAction(stop);

     QToolButton *homeButton = new QToolButton;
     homeButton->setGeometry(0,0,20,20);
     homeButton->setIcon(QIcon(":/icons/home.png"));
     homeButton->setToolTip(tr("Home"));
     homeButton->setAccessibleDescription(tr("Home"));
     homeButton->setShortcut(QKeySequence(tr("Alt+Home")));
     connect(homeButton,SIGNAL(clicked()),this,SLOT(reloadHome()));
     toolBar->addWidget(homeButton);

     QToolButton *closeButton = new QToolButton(this);
     closeButton->setIcon(QIcon(":/icons/cancel.png"));
     closeButton->setToolTip(tr("Close"));


     connect(closeButton,SIGNAL(clicked()),this,SLOT(close()));

//     toolBar->addAction(view->pageAction(QWebPage::~QWebPage));
     toolBar->addWidget(locationEdit);

     QToolButton *incButton = new QToolButton(this);
     incButton->setIcon(QIcon(":/icons/fontsizeup.png"));
     incButton->setToolTip(tr("Larger Fontsize"));
     incButton->setShortcut(QKeySequence::ZoomIn);
     connect(incButton,SIGNAL(clicked()),flWebView,SLOT(increaseFontSize()));


     QToolButton *resetButton = new QToolButton(this);
     resetButton->setIcon(QIcon(":/icons/fontsizedefault.png"));
     resetButton->setToolTip(tr("Default Fontsize"));
     resetButton->setShortcut(QKeySequence(tr("Ctrl+0")));
     connect(resetButton,SIGNAL(clicked()),flWebView,SLOT(resetFontSize()));

     QToolButton *decButton = new QToolButton(this);
     decButton->setIcon(QIcon(":/icons/fontsizedown.png"));
     decButton->setToolTip(tr("Smaller Fontsize"));
     decButton->setShortcut(QKeySequence::ZoomOut);
     connect(decButton,SIGNAL(clicked()),flWebView,SLOT(decreaseFontSize()));

     toolBar->addWidget(decButton);
     toolBar->addWidget(resetButton);
     toolBar->addWidget(incButton);

     QToolButton *highlightButton = new QToolButton;
     highlightButton->setGeometry(0,0,20,20);
     highlightButton->setIcon(QIcon(":/icons/link.png"));
     highlightButton->setToolTip(tr("Links"));
     highlightButton->setAccessibleDescription(tr("Highlight Links"));
     highlightButton->setShortcut(QKeySequence(tr("Ctrl+L")));
     connect(highlightButton,SIGNAL(clicked()),this,SLOT(highlightAllLinks()));
     toolBar->addWidget(highlightButton);


     toolBar->addWidget(closeButton);

//     setCentralWidget(view);
     setUnifiedTitleAndToolBarOnMac(true);
     this->pdfview = new PDFWindow(this);
     this->pdfview->hide();
    this->flWebView->setPDFview(this->pdfview);
     this->flWebView->topLevel=true;

 }


 void MainWindow::adjustLocation()
 {
     locationEdit->setText(flWebView->url().toString());
 }

 void MainWindow::changeLocation()
 {
     QUrl url = QUrl(locationEdit->text());
     flWebView->load(url);
     flWebView->setFocus();
 }

 void MainWindow::adjustTitle()
 {
     if (progress <= 0 || progress >= 100)
         setWindowTitle(flWebView->title());
     else
         setWindowTitle(QString("%1 (%2%)").arg(flWebView->title()).arg(progress));
 }

 void MainWindow::setProgress(int p)
 {
     progress = p;
     adjustTitle();
 }

 void MainWindow::finishLoading(bool)
 {
     progress = 100;
     adjustTitle();
     flWebView->page()->mainFrame()->evaluateJavaScript(jQuery);
 }

 void MainWindow::highlightAllLinks()
 {
//     QString codeSet = "$('a').each( function () { $(this).css('background-color', 'yellow') } )";
     QString codeSet = "$('a').each( function () { $(this).css('border', '2px dotted red') } )";
//     QString codeUnset = "$('a').each( function () { $(this).css('background-color', '') } )";
     QString codeUnset = "$('a').each( function () { $(this).css('border', '') } )";

     if(!flWebView->linksHighlighted){
         flWebView->page()->mainFrame()->evaluateJavaScript(codeSet);
         flWebView->linksHighlighted=true;
     }else{
         flWebView->page()->mainFrame()->evaluateJavaScript(codeUnset);
         flWebView->linksHighlighted=false;
     }
 }


 void MainWindow::windowCloseRequested(){
   qDebug() << "close was called";
   this->hide();
 }


 void MainWindow::loadUrl(QUrl url){
     this->startUrl=url;
     flWebView->setUrl(url);
 }

 void MainWindow::reloadHome(){
     flWebView->setUrl(this->startUrl);
 }

